/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.photo;

import com.geolocsystems.prismandroid.model.evenements.ValeurNature;
import com.neogls.prism.central.vaadin.service.bean.IPhotoItem;
import com.neogls.prism.central.vaadin.service.event.EventPhotoService;
import com.neogls.prism.central.vaadin.service.event.InMemoryPhotoItem;
import com.neogls.prism.central.vaadin.util.vaadin.PhotoItemVaadinUtils;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.photo.PhotoUploadDialog;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.SucceededEvent;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import java.io.IOException;
import java.io.Serializable;

final class PhotoUploadDialog
extends Dialog {
    private final MemoryBuffer buffer = new MemoryBuffer();
    private final Div errorLabel = new Div();
    private final Image image = new Image();
    private final Button bConfirm = new Button(this.getTranslation("generic.add", new Object[0]), arg_0 -> this.onConfirmClick(arg_0));
    private final EventPhotoService service;
    private final ValeurNature valeurNature;
    private IPhotoItem photoItem;

    public PhotoUploadDialog(EventPhotoService service, ValeurNature valeurNature, ComponentEventListener<PhotoAddEvent> listener) {
        this.service = service;
        this.valeurNature = valeurNature;
        this.addListener(PhotoAddEvent.class, listener);
        Upload upload = new Upload((Receiver)this.buffer);
        upload.addSucceededListener(arg_0 -> this.onUploadSucceeded(arg_0));
        upload.setWidthFull();
        this.errorLabel.addClassNames(new String[]{"flex-grow", "text-error", "mt-xs", "mx-s", "mb-s"});
        Div errorLabelContainer = new Div(new Component[]{this.errorLabel});
        errorLabelContainer.addClassName("flex");
        this.image.setMaxWidth(50.0f, Unit.EM);
        this.image.setMaxHeight(30.0f, Unit.EM);
        this.image.setVisible(false);
        this.image.addClassNames(new String[]{"block", "mx-auto"});
        Div content = new Div(new Component[]{upload, errorLabelContainer, this.image});
        content.addClassName("inline-block");
        this.add(new Component[]{content});
        Button bCancel = new Button(this.getTranslation("generic.cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
        this.bConfirm.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.bConfirm.addClassName("ml-auto");
        this.bConfirm.setEnabled(false);
        this.getFooter().add(new Component[]{bCancel, this.bConfirm});
    }

    private void onConfirmClick(ClickEvent<Button> event) {
        PhotoAddEvent photoAddEvent = new PhotoAddEvent(this, event.isFromClient(), this.photoItem);
        this.fireEvent((ComponentEvent)photoAddEvent);
        if (!photoAddEvent.isCanceled()) {
            this.close();
        }
    }

    private void onUploadSucceeded(SucceededEvent event) {
        try {
            byte[] compressedData = this.service.compressPhoto(this.buffer.getInputStream().readAllBytes(), this.valeurNature);
            this.photoItem = new InMemoryPhotoItem(this.service.getHash(compressedData), compressedData);
            PhotoItemVaadinUtils.setImageSrc((Image)this.image, (IPhotoItem)this.photoItem);
            this.image.setVisible(true);
            this.bConfirm.setEnabled(true);
            this.errorLabel.setText(null);
        }
        catch (EventPhotoService.EventPhotoServiceException e) {
            this.errorLabel.setText(e.getLocalizedMessage());
        }
        catch (IOException e) {
            this.errorLabel.setText(null);
            throw new RuntimeException(e);
        }
    }
}

