/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.photo;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.neogls.prism.central.vaadin.common.component.ErrorDialog;
import com.neogls.prism.central.vaadin.service.bean.IPhotoItem;
import com.neogls.prism.central.vaadin.service.event.EventPhotoService;
import com.neogls.prism.central.vaadin.service.event.InDatabasePhotoItem;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.photo.PhotoContainer;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.photo.PhotoUploadDialog;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ScrollOptions;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Div;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PhotoContainer
extends Div {
    private final LinkedList<IPhotoItem> photoList = new LinkedList();
    private final Map<IPhotoItem, PhotoItemComponent> photoItemComponents = new HashMap();
    private final Div container = new Div();
    private final EventPhotoService service;
    private final Evenement event;
    private final boolean readOnly;
    private static final ScrollOptions SCROLL_OPTIONS = new ScrollOptions(ScrollOptions.Behavior.AUTO, ScrollOptions.Alignment.NEAREST, ScrollOptions.Alignment.NEAREST);

    public PhotoContainer(EventPhotoService service, Evenement event, boolean readOnly) {
        this.service = service;
        this.event = event;
        this.readOnly = readOnly;
        Button bAddPhoto = new Button("Ajouter une photo", arg_0 -> this.onAddPhotoClick(arg_0));
        bAddPhoto.setVisible(!readOnly);
        this.container.addClassName("container");
        event.getPhotos().stream().map(InDatabasePhotoItem::new).forEach(this.photoList::add);
        this.add(new Component[]{bAddPhoto, this.container});
        this.addClassName("photo-container");
        for (IPhotoItem photoItem : this.photoList) {
            PhotoItemComponent imageComponent = new PhotoItemComponent(this, photoItem);
            this.container.add(new Component[]{imageComponent});
            this.photoItemComponents.put(photoItem, imageComponent);
        }
    }

    private void onAddPhotoClick(ClickEvent<Button> event) {
        new PhotoUploadDialog(this.service, this.event.getValeurNature(), arg_0 -> this.onPhotoAdded(arg_0)).open();
    }

    private void onPhotoAdded(PhotoUploadDialog.PhotoAddEvent event) {
        IPhotoItem photoItem = event.getPhotoItem();
        if (this.photoList.contains(photoItem)) {
            event.setCanceled(true);
            ErrorDialog.builder().title("Ajout impossible").message("Cette photo est d\u00e9j\u00e0 ajout\u00e9e \u00e0 l'\u00e9v\u00e9nement").build().open();
            return;
        }
        IPhotoItem previousLast = (IPhotoItem)this.photoList.peekLast();
        this.photoList.add(photoItem);
        PhotoItemComponent imageComponent = new PhotoItemComponent(this, photoItem);
        this.container.add(new Component[]{imageComponent});
        this.photoItemComponents.put(photoItem, imageComponent);
        imageComponent.scrollIntoView(SCROLL_OPTIONS);
        if (previousLast != null) {
            ((PhotoItemComponent)this.photoItemComponents.get(previousLast)).updateButtons();
        }
    }

    public List<IPhotoItem> getPhotoList() {
        return Collections.unmodifiableList(this.photoList);
    }
}

