/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismcentral.beans.Onglet;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.event.EventPhotoService;
import com.neogls.prism.central.vaadin.service.event.EventService;
import com.neogls.prism.central.vaadin.service.util.GeometryUtils;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.mct.common.carto.SuiviStyleService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.IPrismLayer;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PrismLayerFactory;
import com.neogls.prism.central.vaadin.view.mct.common.field.IVaadinFieldComponentFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.Polyline;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;

@Service
public class EventSheetService {
    private final ConfigurationService configurationService;
    private final IBusinessService businessService;
    private final EventPhotoService eventPhotoService;
    private final IVaadinFieldComponentFactory vaadinComponentFactory;
    private final UserPermissionService userPermissionService;
    private final EventService eventService;
    private final PrismLayerFactory prismLayerFactory;
    private final SuiviStyleService suiviStyleService;

    public List<Onglet> getFieldTabs() {
        return this.businessService.getOngletsChamps();
    }

    public boolean canShowField(Champ field) {
        return MetierCommun.peutAfficherChamp((Profil)this.userPermissionService.getCurrentUser().getProfil(), (Champ)field);
    }

    public Nature getNatureOfEventWithValues(@Nonnull Evenement event) {
        return this.eventService.getNatureOfEventWithValues(event);
    }

    public Optional<IPrismLayer> tryCreateCartoLayer(int businessModuleCode) {
        return this.prismLayerFactory.tryCreateCartoLayer(businessModuleCode);
    }

    @Nullable
    public Layer createEventLinear(ChampLocalisation localisation, int mmCode) {
        if (localisation.getX() == null || localisation.getX().length <= 2) {
            return null;
        }
        List<LatLng> coordinates = GeometryUtils.lineFromFloatArrays((float[])localisation.getX(), (float[])localisation.getY()).stream().map(LeafletUtils::pointToLatLng).toList();
        Polyline linear = new Polyline(coordinates);
        linear.setStyle(this.suiviStyleService.getStyle(null, Integer.valueOf(mmCode)));
        return linear;
    }

    public String getEditorUsername(Evenement event) {
        PrismCentralUser user = this.businessService.getUtilisateur(event.getCodeUtilisateur());
        return user != null ? user.getNom() : event.getCodeUtilisateur();
    }

    public boolean isShowEventId() {
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "afficheIdEvenement").orElse(false);
    }

    public List<Evenement> getEventVersions(Evenement event) {
        return this.eventService.getEventVersions(event);
    }

    @Generated
    public EventSheetService(ConfigurationService configurationService, IBusinessService businessService, EventPhotoService eventPhotoService, IVaadinFieldComponentFactory vaadinComponentFactory, UserPermissionService userPermissionService, EventService eventService, PrismLayerFactory prismLayerFactory, SuiviStyleService suiviStyleService) {
        this.configurationService = configurationService;
        this.businessService = businessService;
        this.eventPhotoService = eventPhotoService;
        this.vaadinComponentFactory = vaadinComponentFactory;
        this.userPermissionService = userPermissionService;
        this.eventService = eventService;
        this.prismLayerFactory = prismLayerFactory;
        this.suiviStyleService = suiviStyleService;
    }

    @Generated
    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Generated
    public EventPhotoService getEventPhotoService() {
        return this.eventPhotoService;
    }

    @Generated
    public IVaadinFieldComponentFactory getVaadinComponentFactory() {
        return this.vaadinComponentFactory;
    }
}

