/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.NatureOuRaccourci;
import com.geolocsystems.prismandroid.model.evenements.RaccourciNature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.Restriction;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismcentral.beans.Onglet;
import com.neogls.prism.central.vaadin.common.bean.Point3D;
import com.neogls.prism.central.vaadin.layout.LocalisationSearch;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.bean.IPhotoItem;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.util.ToStringFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.IPrismLayer;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.EventSheetService;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.EventValueChangeEvent;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.photo.PhotoContainer;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.IVaadinFieldComponentFactory;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.TabSheet;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.controls.LayersControl;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;

public class EventSheetContent
extends HorizontalLayout {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventSheetContent.class);
    private static final String NAME_FIELD_TAB_PHOTO = "photos";
    private final boolean readOnly;
    private final Evenement event;
    private final NatureOuRaccourci natureOuRaccourci;
    private final Nature nature;
    private final Map<String, String> originalAttributes;
    private final EventSheetService eventSheetService;
    private final IVaadinFieldComponentFactory componentFactory;
    private final Map<String, HasComponents> fieldTabContents = new HashMap();
    private final Map<String, Tab> tabsByName = new HashMap();
    private final Map<String, AbstractFieldComponent<?>> components = new HashMap();
    private final LeafletMap map;
    private final LayersControl layersControl = new LayersControl();
    @Nullable
    private Layer layerLinear = null;
    private final PhotoContainer photoContainer;
    private Point3D centerZoom = null;

    EventSheetContent(@Nullable Evenement event, NatureOuRaccourci natureOuRaccourci, @Nullable ValeurChampLocalisation localisation, boolean readOnly, EventSheetService eventSheetService, Point3D centerZoom) {
        this.readOnly = readOnly;
        this.centerZoom = centerZoom;
        this.natureOuRaccourci = (NatureOuRaccourci)DeepCopy.copy((Object)natureOuRaccourci);
        this.nature = this.natureOuRaccourci.getNature();
        if (localisation != null) {
            this.nature.getLocalisation().setValeurChamp((ValeurChamp)localisation);
        }
        this.originalAttributes = MetierCommun.convertirAttributs((Nature)this.nature, null);
        this.event = Objects.requireNonNullElseGet(event, () -> this.initNewEvent());
        this.eventSheetService = eventSheetService;
        this.componentFactory = eventSheetService.getVaadinComponentFactory();
        this.nature.getDescription().setStyle(2);
        TabSheet fields = new TabSheet();
        fields.setWidth(30.0f, Unit.EM);
        Onglet photosTab = null;
        for (Onglet fieldTab : eventSheetService.getFieldTabs()) {
            if (NAME_FIELD_TAB_PHOTO.equalsIgnoreCase(fieldTab.getNom())) {
                photosTab = fieldTab;
                continue;
            }
            VerticalLayout fieldTabContent = new VerticalLayout();
            fieldTabContent.setPadding(false);
            fieldTabContent.setSpacing(false);
            fieldTabContent.addClassName("gap-s");
            Tab tab = new Tab(fieldTab.getLibelle());
            fields.add(tab, (Component)fieldTabContent);
            this.fieldTabContents.put(fieldTab.getNom(), fieldTabContent);
            this.tabsByName.put(fieldTab.getNom(), tab);
        }
        this.map = this.createLeafletMap();
        this.layersControl.addTo(this.map);
        Layer osmLayer = LeafletUtils.createOSMLayer();
        osmLayer.addTo(this.map);
        this.layersControl.addOverlay(osmLayer, "OSM");
        eventSheetService.tryCreateCartoLayer(this.nature.getCodeMM()).map(IPrismLayer::getLayer).ifPresent(cartoLayer -> {
            cartoLayer.addTo(this.map);
            this.layersControl.addOverlay(cartoLayer, "Carto");
        });
        this.map.setHeight(null);
        this.map.setWidthFull();
        this.componentFactory.runWithContext(this.map, () -> this.createFieldComponents());
        this.applyRestrictions();
        LocalisationSearch searchComponent = new LocalisationSearch(this.map);
        searchComponent.addClassName("overflow-auto");
        VerticalLayout mapLayout = new VerticalLayout(new Component[]{this.map, searchComponent});
        mapLayout.setFlexGrow(1.0, new HasElement[]{this.map});
        mapLayout.setPadding(false);
        mapLayout.setSpacing(false);
        mapLayout.setMinWidth("0");
        this.photoContainer = new PhotoContainer(eventSheetService.getEventPhotoService(), this.event, readOnly);
        this.photoContainer.setVisible(photosTab != null && (!readOnly || !this.event.getPhotos().isEmpty()));
        this.add(new Component[]{fields, mapLayout, this.photoContainer});
        this.setFlexShrink(0.0, new HasElement[]{fields, this.photoContainer});
        mapLayout.setSizeUndefined();
        this.setFlexGrow(1.0, new HasElement[]{mapLayout});
        for (Map.Entry tabEntry : this.tabsByName.entrySet()) {
            if (((HasComponents)this.fieldTabContents.get(tabEntry.getKey())).getElement().getChildCount() != 0) continue;
            ((Tab)tabEntry.getValue()).setVisible(false);
        }
        this.updateLocalisation();
        this.addClassName("event-sheet");
    }

    private Evenement initNewEvent() {
        Evenement newEvent = new Evenement();
        newEvent.setValeurNature(this.nature.extraireValeurs());
        return newEvent;
    }

    private LeafletMap createLeafletMap() {
        LatLngBounds bounds = null;
        Integer zoom = null;
        if (this.event.getLocalisation().getPositionDebut() != null) {
            Position positionDebut = this.event.getLocalisation().getPositionDebut();
            Position positionFin = this.event.getLocalisation().getPositionFin();
            bounds = new LatLngBounds(LatLng.latlng((double)positionDebut.getY(), (double)positionDebut.getX()));
            if (positionFin != null) {
                bounds.extend(new LatLng[]{LatLng.latlng((double)positionFin.getY(), (double)positionFin.getX())});
            }
        } else if (this.centerZoom != null) {
            bounds = new LatLngBounds(LatLng.latlng((double)this.centerZoom.getLat(), (double)this.centerZoom.getLng()));
            zoom = this.centerZoom.getZoom();
        }
        return LeafletUtils.createMap((ConfigurationService)this.eventSheetService.getConfigurationService(), bounds, zoom);
    }

    private void updateLocalisation() {
        log.debug("Updating localisation on map");
        if (this.layerLinear != null) {
            this.layerLinear.remove();
        }
        this.layerLinear = this.eventSheetService.createEventLinear(this.nature.getLocalisation(), this.nature.getCodeMM());
        if (this.layerLinear != null) {
            this.layerLinear.addTo(this.map);
        }
    }

    private void createFieldComponents() {
        for (Champ champ : this.nature.getChamps()) {
            this.createFieldComponent(champ);
        }
    }

    private void createFieldComponent(Champ field) {
        if (field == null) {
            log.warn("Field is null");
            return;
        }
        AbstractFieldComponent component = this.componentFactory.getView(field);
        if (component == null) {
            return;
        }
        component.setReadOnly(this.readOnly);
        component.addComponentValueChangeListener(arg_0 -> this.onComponentValueChange(arg_0));
        ((HasComponents)this.fieldTabContents.get(field.getOnglet())).add(new Component[]{component});
        this.addFieldComponentToComponentMap(component);
        if (field == this.nature.getLocalisation()) {
            component.addComponentValueChangeListener((ComponentEventListener & Serializable)e -> this.updateLocalisation());
        }
    }

    private void addFieldComponentToComponentMap(AbstractFieldComponent<?> fieldComponent) {
        this.components.put(fieldComponent.getField().getNom(), fieldComponent);
        fieldComponent.getSubComponents().forEach(arg_0 -> this.addFieldComponentToComponentMap(arg_0));
    }

    private void applyRestrictions() {
        Map fields = MetierCommun.getChamps((Nature)this.nature);
        for (Champ field : fields.values()) {
            boolean display = !field.estCache() && this.eventSheetService.canShowField(field) && (field != this.nature.getDescription() || this.shouldDisplayDescription());
            Iterator iterator = MetierCommun.getRestrictionsValeurChamp((Champ)field).iterator();
            while (display && iterator.hasNext()) {
                Restriction restriction = (Restriction)iterator.next();
                Champ restrictionField = (Champ)fields.get(restriction.getNomChamp());
                if (restrictionField == null) {
                    String message = "Le champs %s n'existe pas !!!".formatted(restriction.getNomChamp());
                    log.error(message);
                    throw new IllegalStateException(message);
                }
                if (restriction.accept(restrictionField.getValeurChamp())) continue;
                display = false;
            }
            AbstractFieldComponent component = (AbstractFieldComponent)this.components.get(field.getNom());
            if (component != null) {
                component.setVisible(display);
                continue;
            }
            log.warn("Le composant '{}' n'existe pas !!!", (Object)field.getNom());
        }
    }

    private boolean shouldDisplayDescription() {
        if (this.readOnly) {
            return true;
        }
        if (this.nature.getDescription().getValeurs().size() == 1) {
            log.trace("Not showing description because only one value is allowed");
            return false;
        }
        if (this.natureOuRaccourci instanceof RaccourciNature) {
            ValeurChampCollectionChoixUnique descriptionValue = new ValeurChampCollectionChoixUnique("description");
            descriptionValue.setValeur(this.natureOuRaccourci.getLabel());
            this.nature.getDescription().setValeurChamp((ValeurChamp)descriptionValue);
            log.trace("Not showing description because RaccourciNature");
            return false;
        }
        return true;
    }

    private void onComponentValueChange(AbstractFieldComponent.ComponentValueChangeEvent e) {
        Champ field = ((AbstractFieldComponent)e.getSource()).getField();
        log.atDebug().addArgument((Object)field.getLibelle()).addArgument((Object)field.getClass().getSimpleName()).addArgument(() -> field.getView((IComposantFactory)ToStringFactory.INSTANCE)).log("[ValueChange] {} ({}): {}");
        this.applyRestrictions();
        this.fireEvent((ComponentEvent)new EventValueChangeEvent((Component)this, e.isFromClient(), field));
    }

    public boolean isModified() {
        if (this.readOnly) {
            return false;
        }
        HashMap currentAttributes = MetierCommun.convertirAttributs((Nature)this.nature, null);
        if (this.originalAttributes.size() != currentAttributes.size() || !this.originalAttributes.keySet().equals(currentAttributes.keySet())) {
            return true;
        }
        for (String fieldName : this.originalAttributes.keySet()) {
            if (Objects.equals(this.originalAttributes.get(fieldName), currentAttributes.get(fieldName))) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return this.components.values().stream().filter(Component::isVisible).allMatch(AbstractFieldComponent::isValid);
    }

    public Evenement getEvent() {
        Evenement newEvent = (Evenement)DeepCopy.copy((Object)this.event);
        newEvent.setValeurNature(this.nature.extraireValeurs());
        newEvent.setEtat(1);
        newEvent.setErreur(null);
        return newEvent;
    }

    public List<IPhotoItem> getPhotoList() {
        return this.photoContainer.getPhotoList();
    }

    public void addEventValueChangeListener(ComponentEventListener<EventValueChangeEvent<EventSheetContent>> listener) {
        ComponentEventListener & Serializable componentListener = (ComponentEventListener & Serializable)event -> {
            EventValueChangeEvent eventValueChangeEvent = (EventValueChangeEvent)event;
            listener.onComponentEvent((ComponentEvent)eventValueChangeEvent);
        };
        this.addListener(EventValueChangeEvent.class, (ComponentEventListener)componentListener);
    }
}

