/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.NatureOuRaccourci;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.neogls.prism.central.vaadin.common.bean.Point3D;
import com.neogls.prism.central.vaadin.rest.eventicon.EventIconController;
import com.neogls.prism.central.vaadin.service.bean.IPhotoItem;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.EventSheet;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.EventSheetContent;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.EventSheetService;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.EventValueChangeEvent;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventVersionComboBox;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class EventSheet
extends VerticalLayout {
    private final EventSheetService service;
    private final boolean readOnly;
    private final EventSheetContent mainContent;
    private final String title;
    private final String iconURL;
    private final Map<Integer, EventSheetContent> eventSheetsByVersion = new HashMap();
    private EventSheetContent currentContent;

    public EventSheet(EventSheetService service, Evenement event, boolean readonly) {
        this(service, event, (NatureOuRaccourci)service.getNatureOfEventWithValues(event), null, readonly, null);
    }

    public EventSheet(EventSheetService service, NatureOuRaccourci natureOuRaccourci, Point3D centerZoom) {
        this(service, natureOuRaccourci, null, centerZoom);
    }

    public EventSheet(EventSheetService service, NatureOuRaccourci natureOuRaccourci, @Nullable ValeurChampLocalisation localisation, Point3D centerZoom) {
        this(service, null, natureOuRaccourci, localisation, false, centerZoom);
    }

    private EventSheet(EventSheetService service, @Nullable Evenement event, NatureOuRaccourci natureOuRaccourci, @Nullable ValeurChampLocalisation localisation, boolean readOnly, Point3D centerZoom) {
        this.service = service;
        this.readOnly = readOnly;
        this.mainContent = new EventSheetContent(event, natureOuRaccourci, localisation, readOnly, service, centerZoom);
        this.iconURL = EventIconController.Helper.createEventIconURL((String)natureOuRaccourci.getCode());
        Image icon = new Image(this.iconURL, null);
        icon.setWidth(3.0f, Unit.EM);
        icon.addClassName("block");
        this.title = event != null && service.isShowEventId() ? natureOuRaccourci.getLabel() + " - " + event.getCodeEvenement() : natureOuRaccourci.getLabel();
        HorizontalLayout header = new HorizontalLayout(new Component[]{icon, new H2(this.title)});
        header.setAlignItems(FlexComponent.Alignment.CENTER);
        this.add(new Component[]{header});
        this.setPadding(false);
        this.setAlignItems(FlexComponent.Alignment.STRETCH);
        this.addContent(this.mainContent);
        if (event != null) {
            EventVersionComboBox cbVersions = new EventVersionComboBox(event, (Collection)service.getEventVersions(event), arg_0 -> ((EventSheetService)service).getEditorUsername(arg_0));
            this.eventSheetsByVersion.put(event.getNumVersion(), this.mainContent);
            this.currentContent = this.mainContent;
            cbVersions.addValueChangeListener(arg_0 -> this.onCbVersionValueChange(arg_0));
            cbVersions.addClassName("ms-auto");
            cbVersions.setWidth(40.0f, Unit.EM);
            header.add(new Component[]{cbVersions});
        }
        this.mainContent.addEventValueChangeListener((ComponentEventListener & Serializable)e -> this.fireEvent((ComponentEvent)new EventValueChangeEvent((Component)this, e.isFromClient(), e.getField())));
    }

    private EventSheetContent addContent(EventSheetContent content) {
        this.add(new Component[]{content});
        this.setFlexGrow(1.0, new HasElement[]{content});
        content.setMinHeight("0");
        return content;
    }

    private void onCbVersionValueChange(HasValue.ValueChangeEvent<Evenement> valueChangeEvent) {
        if (valueChangeEvent.getHasValue().isEmpty()) {
            valueChangeEvent.getHasValue().setValue((Object)((Evenement)valueChangeEvent.getOldValue()));
            return;
        }
        Evenement event = (Evenement)valueChangeEvent.getValue();
        this.currentContent.setVisible(false);
        this.currentContent = this.eventSheetsByVersion.computeIfAbsent(event.getNumVersion(), version -> this.addContent(new EventSheetContent(event, (NatureOuRaccourci)this.service.getNatureOfEventWithValues(event), null, this.readOnly, this.service, null)));
        this.currentContent.setVisible(true);
        this.fireEvent((ComponentEvent)new EventVersionChangeEvent(this, valueChangeEvent.isFromClient()));
    }

    public boolean isMainVersionSelected() {
        return this.currentContent == null || this.currentContent == this.mainContent;
    }

    public void addEventVersionChangeListener(ComponentEventListener<EventVersionChangeEvent> listener) {
        this.addListener(EventVersionChangeEvent.class, listener);
    }

    public void addEventValueChangeListener(ComponentEventListener<EventValueChangeEvent<EventSheet>> listener) {
        ComponentEventListener & Serializable componentListener = (ComponentEventListener & Serializable)event -> {
            EventValueChangeEvent eventValueChangeEvent = (EventValueChangeEvent)event;
            listener.onComponentEvent((ComponentEvent)eventValueChangeEvent);
        };
        this.addListener(EventValueChangeEvent.class, (ComponentEventListener)componentListener);
    }

    public boolean isModified() {
        return this.currentContent == null || this.mainContent.isModified();
    }

    public boolean isValid() {
        return this.mainContent.isValid();
    }

    public Evenement getEvent() {
        return this.mainContent.getEvent();
    }

    public List<IPhotoItem> getPhotoList() {
        return this.mainContent.getPhotoList();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getIconURL() {
        return this.iconURL;
    }
}

