/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventassociationdialog;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.beans.EvenementASauvegarder;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class EventAssociationDialogService {
    private final IBusinessService businessService;
    private final UserPermissionService userPermissionService;
    private final ConfigurationService configurationService;

    public int getDefaultDistanceValue() {
        return this.configurationService.getInt(ConfigurationService.ConfigurationType.DATABASE, "evenement.associer.distance").orElse(2500);
    }

    public int getDefaultIntervalValue() {
        return this.configurationService.getInt(ConfigurationService.ConfigurationType.DATABASE, "evenement.associer.intervalle").orElse(15);
    }

    public List<Evenement> getEvents(Evenement eventToAssociate, int distance, int interval) {
        IBusinessService.EvenementFiltre filter = IBusinessService.EvenementFiltre.moduleMetier((String)this.userPermissionService.getCurrentUser().getPrismUser().getDelegation(), (String)this.userPermissionService.getCurrentUser().getPrismUser().getCentre(), (int)5);
        filter.point = eventToAssociate.getLocalisation().getPositionDebut();
        filter.distance = distance;
        Instant endOfToday = Instant.now().truncatedTo(ChronoUnit.DAYS).plus(1L, ChronoUnit.DAYS);
        filter.dateMin = new Timestamp(endOfToday.minus(interval, ChronoUnit.DAYS).toEpochMilli());
        filter.dateMax = new Timestamp(endOfToday.toEpochMilli());
        filter.termines = -1;
        return this.businessService.getEvenements(filter, null).stream().map(Situation::getEvenements).filter(Objects::nonNull).filter(Predicate.not(Collection::isEmpty)).flatMap(Collection::stream).filter(Predicate.not(Evenement::isEvenementPrincipalHorsFiltre)).toList();
    }

    public void associateEvent(Evenement eventToAssociate, Evenement interventionEvent) {
        this.businessService.associerEvenement(EvenementASauvegarder.aSauvegarder((Evenement)eventToAssociate), interventionEvent.getIdSituation());
    }

    @Generated
    public EventAssociationDialogService(IBusinessService businessService, UserPermissionService userPermissionService, ConfigurationService configurationService) {
        this.businessService = businessService;
        this.userPermissionService = userPermissionService;
        this.configurationService = configurationService;
    }
}

