/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventassociationdialog;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ButtonConfig;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ConfirmDialog;
import com.neogls.prism.central.vaadin.common.component.prismintegerfield.PrismIntegerField;
import com.neogls.prism.central.vaadin.util.DateTimeFormatterUtils;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventassociationdialog.EventAssociationDialogService;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAssociationDialog
extends Dialog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventAssociationDialog.class);
    private final EventAssociationDialogService service;
    private final Evenement eventToAssociate;
    private final PrismIntegerField distance = new PrismIntegerField(this.getTranslation("dialog.recherche.intervention.distance", new Object[0]));
    private final PrismIntegerField interval = new PrismIntegerField(this.getTranslation("dialog.recherche.intervention.intervalle", new Object[0]));
    private final Grid<Evenement> grid = new Grid();

    public EventAssociationDialog(EventAssociationDialogService service, Evenement eventToAssociate) {
        this.service = service;
        this.eventToAssociate = eventToAssociate;
        this.setHeaderTitle(this.getTranslation("dialog.recherche.intervention.titre", new Object[0]));
        this.configureFields();
        Button bSearch = new Button(this.getTranslation("dialog.recherche.action.lancer", new Object[0]), arg_0 -> this.onSearchClick(arg_0));
        HorizontalLayout controls = new HorizontalLayout(new Component[]{this.distance, this.interval, bSearch});
        controls.setAlignItems(FlexComponent.Alignment.BASELINE);
        this.configureGrid();
        VerticalLayout content = new VerticalLayout(new Component[]{controls, this.grid});
        content.setAlignItems(FlexComponent.Alignment.STRETCH);
        content.setFlexGrow(1.0, new HasElement[]{this.grid});
        content.setPadding(false);
        content.setSizeFull();
        this.add(new Component[]{content});
        Button bCancel = new Button(this.getTranslation("generic.cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
        Button bSave = new Button(this.getTranslation("dialog.recherche.action.sauvegarder", new Object[0]), arg_0 -> this.onSaveClick(arg_0));
        bSave.setEnabled(false);
        this.getFooter().add(new Component[]{bCancel, bSave});
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        bCancel.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        this.grid.addSelectionListener((SelectionListener & Serializable)event -> bSave.setEnabled(event.getFirstSelectedItem().isPresent()));
        bSearch.click();
    }

    private void configureFields() {
        this.distance.setPlaceholder(String.valueOf(this.service.getDefaultDistanceValue()));
        this.distance.setClearButtonVisible(true);
        this.distance.setMin(100);
        this.distance.setMax(5000);
        this.distance.setStep(100);
        this.interval.setPlaceholder(String.valueOf(this.service.getDefaultIntervalValue()));
        this.interval.setClearButtonVisible(true);
        this.interval.setMin(1);
        this.interval.setMax(30);
        this.interval.setStep(1);
    }

    private void configureGrid() {
        this.grid.addColumn(Evenement::getCodeEvenement).setHeader(this.getTranslation("report.code", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)event -> event.getValeurNature().getCode()).setHeader(this.getTranslation("report.nature", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)event -> event.getValeurNature().getDescription().getValeur()).setHeader(this.getTranslation("report.description", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)evenement -> DateTimeFormatterUtils.getDateTimeFormatter().format(Instant.ofEpochMilli(evenement.getDateCreation()))).setHeader(this.getTranslation("report.dateDebut", new Object[0])).setComparator(Comparator.comparingLong(Evenement::getDateCreation));
        this.grid.addColumn((ValueProvider & Serializable)event -> event.getLocalisation().getCommune()).setHeader(this.getTranslation("report.commune", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)event -> event.getLocalisation().getAxe()).setHeader(this.getTranslation("report.axe", new Object[0]));
        this.grid.addColumn(arg_0 -> this.getLabelPR(arg_0)).setHeader(this.getTranslation("report.libellePr", new Object[0]));
        this.grid.getColumns().forEach(column -> {
            column.setResizable(true);
            column.setSortable(true);
            column.setFlexGrow(0);
            column.setAutoWidth(true);
        });
        ((Grid.Column)this.grid.getColumns().get(0)).setFlexGrow(1);
        this.grid.setWidth(1000.0f, Unit.PIXELS);
    }

    private String getLabelPR(Evenement event) {
        int prDeb = event.getLocalisation().getPrDebut();
        int absPrDebut = event.getLocalisation().getAbsPrDebut();
        int prFin = event.getLocalisation().getPrFin();
        int absPrFin = event.getLocalisation().getAbsPrFin();
        if (prDeb == -1) {
            return this.getTranslation("localisation.aucunpr", new Object[0]);
        }
        if (prFin == -1 || prDeb == prFin && absPrDebut == absPrFin) {
            return "Au PR " + prDeb + "+" + absPrDebut;
        }
        return "Du PR " + prDeb + "+" + absPrDebut + " au PR " + prFin + "+" + absPrFin;
    }

    private void onSearchClick(ClickEvent<Button> event) {
        this.grid.setItems((Collection)this.service.getEvents(this.eventToAssociate, this.distance.getOptionalValue().orElseGet(() -> ((EventAssociationDialogService)this.service).getDefaultDistanceValue()).intValue(), this.interval.getOptionalValue().orElseGet(() -> ((EventAssociationDialogService)this.service).getDefaultIntervalValue()).intValue()));
    }

    private void onSaveClick(ClickEvent<Button> event) {
        ConfirmDialog.builder().title(this.getTranslation("Global.Confirmation", new Object[0])).text(this.getTranslation("dialog.recherche.action.validation.message", new Object[0])).confirm(ButtonConfig.builder().text(this.getTranslation("generic.yes", new Object[0])).listener(arg_0 -> this.onSaveConfirmed(arg_0)).build()).cancel(ButtonConfig.builder().text(this.getTranslation("generic.no", new Object[0])).build()).build().open();
    }

    private void onSaveConfirmed(ClickEvent<Button> e) {
        Evenement interventionEvent = (Evenement)this.grid.getSelectionModel().getFirstSelectedItem().orElseThrow();
        this.service.associateEvent(this.eventToAssociate, interventionEvent);
        this.close();
    }
}

