/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenter;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterField;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterEditDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.event.sort.EventSortService;
import com.neogls.prism.central.vaadin.view.mct.common.event.sort.ISortCriteria;
import com.neogls.prism.central.vaadin.view.mct.common.event.sort.SortCriteria;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctFilterComponent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctSortComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.function.SerializableComparator;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class EventFilterSorter
extends FormLayout
implements MctFilterComponent<EventFilter>,
MctSortComponent<Situation> {
    private final ComboBox<EventFilter> cbFilter = new ComboBox();
    private final DelegationAndCenterField delegationAndCenterField;
    private final ComboBox<ISortCriteria> cbSort = new ComboBox();
    private final ComboBox cbChoixOperation = new ComboBox();
    private final EventMctListService<EventActionListener> eventMctListService;
    private String operationSelectionnee;
    private final IVaadinEventFilterFieldFactory factory;
    private EventFilter currentValue;

    public EventFilterSorter(EventMctListService<EventActionListener> eventMctListService, IVaadinEventFilterFieldFactory factory, EventSortService eventSortService) {
        this.eventMctListService = eventMctListService;
        this.factory = factory;
        this.currentValue = (EventFilter)eventMctListService.getDefaultFilter();
        this.cbFilter.setItemLabelGenerator((ItemLabelGenerator & Serializable)filter -> this.getTranslation(filter.getUnlocalizedName(), new Object[0]));
        this.cbFilter.setItems((Collection)eventMctListService.getFilters());
        this.cbFilter.setValue((Object)this.currentValue);
        this.cbFilter.addValueChangeListener(arg_0 -> this.onCbFilterValueChange(arg_0));
        HorizontalLayout filterContainer = new HorizontalLayout(new Component[]{this.cbFilter, new Button((Component)VaadinIcon.PENCIL.create(), (ComponentEventListener & Serializable)event -> this.openFilterEditDialog(this.currentValue))});
        filterContainer.setSpacing(false);
        filterContainer.addClassName("gap-s");
        filterContainer.setFlexGrow(1.0, new HasElement[]{this.cbFilter});
        this.delegationAndCenterField = new DelegationAndCenterField(eventMctListService.getActiveDelegations());
        this.delegationAndCenterField.setDelegationPlaceholder(this.getTranslation("mct.filtre.delegation.toutes", new Object[0]));
        this.delegationAndCenterField.setCenterPlaceholder(this.getTranslation("mct.filtre.centre.tous", new Object[0]));
        this.delegationAndCenterField.setLabelsVisible(false);
        this.delegationAndCenterField.addValueChangeListener(arg_0 -> this.onDelegationCenterValueChange(arg_0));
        this.cbSort.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> this.getTranslation(item.getUnlocalizedName(), new Object[0]));
        this.cbSort.setItems((Collection)SortCriteria.ALL_SORT_CRITERIA);
        this.cbSort.setValue((Object)eventSortService.getDefaultSortCriteria());
        this.cbSort.addValueChangeListener(arg_0 -> this.onSortCriteriaChange(arg_0));
        this.addFormItem((Component)filterContainer, this.getTranslation("mct.filtre.titre", new Object[0]));
        this.addFormItem((Component)this.delegationAndCenterField, this.getTranslation("global.delegation", new Object[0]) + " & " + this.getTranslation("global.centre", new Object[0]));
        this.addFormItem((Component)this.cbSort, this.getTranslation("mct.sort", new Object[0]));
        if (this.currentValue.getMmCodes().contains(8)) {
            this.cbChoixOperation.setClearButtonVisible(true);
            this.cbChoixOperation.setItems(eventMctListService.getEventFilterFormService().getOperations());
            this.cbChoixOperation.addValueChangeListener(arg_0 -> this.onOperationChange(arg_0));
            this.addFormItem((Component)this.cbChoixOperation, this.getTranslation("mct.operations", new Object[0]));
        }
        this.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        AuthenticatedUser authenticatedUser = eventMctListService.getCurrentUser();
        this.delegationAndCenterField.setValue((Object)DelegationAndCenter.of((Delegation)authenticatedUser.getDelegation(), (Centre)authenticatedUser.getCentre()));
        if (eventMctListService.getEventFilterFormService().doitVerrouillerCentre(eventMctListService.getPrimaryBusinessModuleCode())) {
            this.delegationAndCenterField.setReadOnly(true);
        } else if (eventMctListService.getEventFilterFormService().doitVerrouillerDelegation(eventMctListService.getPrimaryBusinessModuleCode())) {
            this.delegationAndCenterField.setDelegationReadOnly();
        }
    }

    private void openFilterEditDialog(EventFilter filterToEdit) {
        EventFilterEditDialog dialog = new EventFilterEditDialog(filterToEdit, this.eventMctListService.getBusinessModuleCodes(), this.eventMctListService.getEventFilterFormService(), this.factory);
        dialog.addCancelListener((ComponentEventListener & Serializable)event -> this.cbFilter.setValue((Object)this.currentValue));
        dialog.addValidateListener((ComponentEventListener & Serializable)event -> {
            this.currentValue = event.getFilter();
            this.cbFilter.setValue((Object)this.currentValue);
            this.delegationAndCenterField.setValue((Object)this.currentValue.getDelegationAndCenter());
            this.fireFilterChangeEvent();
        });
        dialog.open();
    }

    private void fireFilterChangeEvent() {
        this.currentValue.getSqlFilter().operation = this.operationSelectionnee;
        this.currentValue = this.currentValue.toBuilder().sqlFilter((IBusinessService.EvenementFiltre)DeepCopy.copy((Object)this.currentValue.getSqlFilter())).delegationAndCenter((DelegationAndCenter)this.delegationAndCenterField.getValue()).build();
        this.fireEvent((ComponentEvent)new MctFilterComponent.FilterChangeEvent((Component)this, true, (Object)this.currentValue));
    }

    private void onCbFilterValueChange(HasValue.ValueChangeEvent<EventFilter> event) {
        if (!event.isFromClient()) {
            return;
        }
        if (this.cbFilter.isEmpty()) {
            this.cbFilter.setValue((Object)((EventFilter)event.getOldValue()));
        } else if (((EventFilter)event.getValue()).isCustom()) {
            this.openFilterEditDialog((EventFilter)event.getValue());
        } else {
            this.currentValue = (EventFilter)event.getValue();
            this.fireFilterChangeEvent();
        }
    }

    private void onDelegationCenterValueChange(HasValue.ValueChangeEvent<DelegationAndCenter> event) {
        if (event.isFromClient()) {
            this.fireFilterChangeEvent();
        }
    }

    private void onSortCriteriaChange(HasValue.ValueChangeEvent<ISortCriteria> event) {
        if (!event.isFromClient()) {
            return;
        }
        if (this.cbSort.isEmpty()) {
            this.cbSort.setValue((Object)((ISortCriteria)event.getOldValue()));
        } else {
            this.fireEvent((ComponentEvent)new MctSortComponent.SortChangeEvent((Component)this, true, (SerializableComparator)event.getValue()));
        }
    }

    private void onOperationChange(HasValue.ValueChangeEvent<String> event) {
        if (event.isFromClient()) {
            this.operationSelectionnee = (String)event.getValue();
            System.out.println((String)event.getValue());
            this.fireFilterChangeEvent();
        }
    }

    public EventFilter getFilter() {
        return this.currentValue;
    }

    public void setFilter(EventFilter filter) {
        if (!Objects.equals(this.currentValue, filter)) {
            this.currentValue = filter;
            this.cbFilter.setValue((Object)filter);
            this.fireFilterChangeEvent();
        }
    }

    public SerializableComparator<Situation> getSort() {
        return (SerializableComparator)this.cbSort.getValue();
    }
}

