/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event;

import com.geolocsystems.prismandroid.model.evenements.NatureOuRaccourci;
import com.neogls.prism.central.vaadin.service.event.EventService;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.event.EventCreationTab;
import com.neogls.prism.central.vaadin.view.mct.common.event.NatureSelectionComponent;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSaveEvent;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogFactory;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import java.util.List;

public class EventCreationTab
extends Composite<NatureSelectionComponent> {
    private final List<NatureOuRaccourci> natures;
    private final EventService eventService;
    private final EventSheetDialogFactory eventSheetDialogFactory;
    private final ICartoPane cartoPane;

    public EventCreationTab(List<NatureOuRaccourci> natures, EventService eventService, EventSheetDialogFactory eventSheetDialogFactory, ICartoPane cartoPane) {
        this.natures = natures;
        this.eventService = eventService;
        this.eventSheetDialogFactory = eventSheetDialogFactory;
        this.cartoPane = cartoPane;
        ((NatureSelectionComponent)this.getContent()).addNatureSelectionListener(arg_0 -> this.onNatureSelection(arg_0));
    }

    protected NatureSelectionComponent initContent() {
        return new NatureSelectionComponent(this.natures);
    }

    private void onNatureSelection(NatureSelectionComponent.NatureSelectionEvent event) {
        EventSheetDialog eventSheetDialog = this.eventSheetDialogFactory.createEventSheetDialogForCreation(event.getNatureOuRaccourci(), this.cartoPane.getCenterZoom());
        eventSheetDialog.addEventSaveListener(arg_0 -> this.onEventSave(arg_0));
        eventSheetDialog.open();
    }

    private void onEventSave(EventSaveEvent e) {
        this.eventService.saveEvent(e.getEvent(), e.getPhotoList());
        this.fireEvent((ComponentEvent)new EventCreationEvent(this, e.isFromClient()));
    }

    public void addEventCreationListener(ComponentEventListener<EventCreationEvent> listener) {
        this.addListener(EventCreationEvent.class, listener);
    }
}

