/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.carto.layer;

import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.neogls.prism.central.vaadin.service.util.GeometryUtils;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.mct.common.carto.SuiviStyleService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.ICompositePrismLayer;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.groups.LayerGroup;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.Polyline;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;

/*
 * Exception performing whole class analysis ignored.
 */
public class TronconVhLayer
implements ICompositePrismLayer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TronconVhLayer.class);
    private final LayerGroup layer = new LayerGroup(new Layer[0]);
    private final int codeModuleMetier;
    private final SuiviStyleService suiviStyleService;
    private LatLng min = null;
    private LatLng max = null;

    public void clearLayer() {
        this.layer.clearLayers();
    }

    public void setTronconsSuivis(Collection<TronconSuivi> tronconsSuivis) {
        this.afficherTroncons(tronconsSuivis);
    }

    private void afficherTroncons(Collection<TronconSuivi> tronconsSuivis) {
        for (TronconSuivi troncon : tronconsSuivis) {
            if (troncon.getX() == null) {
                log.warn("CARTOPANE AFFICH TRONCON - TRONCON {} EN ERREUR ", (Object)troncon.getIdTronconSuivi());
                continue;
            }
            List<LatLng> coordinates = GeometryUtils.lineFromFloatArrays((float[])troncon.getX(), (float[])troncon.getY()).stream().map(LeafletUtils::pointToLatLng).toList();
            Object code = troncon.getCode();
            if (troncon.getDate() != null && this.codeModuleMetier == 0) {
                code = "col" + TronconVhLayer.getDayNumberOld((Date)new Date(troncon.getDate().getTime()));
            }
            Polyline line = new Polyline(coordinates);
            line.setStyle(this.suiviStyleService.getStyle((String)code, Integer.valueOf(this.codeModuleMetier)));
            line.addTo(this.layer);
            coordinates.stream().forEach(p -> {
                if (this.min == null) {
                    this.min = new LatLng(p.getLat().doubleValue(), p.getLng().doubleValue());
                }
                if (this.max == null) {
                    this.max = new LatLng(p.getLat().doubleValue(), p.getLng().doubleValue());
                }
                if (p.getLat() < this.min.getLat()) {
                    this.min.setLat(p.getLat());
                }
                if (p.getLat() > this.max.getLat()) {
                    this.max.setLat(p.getLat());
                }
                if (p.getLng() < this.min.getLng()) {
                    this.min.setLng(p.getLng());
                }
                if (p.getLng() > this.max.getLng()) {
                    this.max.setLng(p.getLng());
                }
            });
        }
    }

    private static int getDayNumberOld(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public LayerGroup getLayer() {
        return this.layer;
    }

    public LatLngBounds getLayerBounds() {
        LatLngBounds bounds = new LatLngBounds(new LatLng[]{this.min, this.max});
        return bounds;
    }

    @Generated
    public TronconVhLayer(int codeModuleMetier, SuiviStyleService suiviStyleService) {
        this.codeModuleMetier = codeModuleMetier;
        this.suiviStyleService = suiviStyleService;
    }
}

