/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.carto.layer;

import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.neogls.prism.central.vaadin.rest.WMSController;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.PatrolService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.SuiviStyleService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.IPrismLayer;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PrismLayerFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.TronconVhLayer;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolMctListService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.raster.TileLayer;

@Service
public class PrismLayerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrismLayerFactory.class);
    private final SuiviStyleService suiviStyleService;
    private final BusinessModuleService businessModuleService;
    private final ConfigurationService configurationService;
    private final PatrolService patrolService;

    public Optional<IPrismLayer> tryCreateCartoLayer(int businessModuleCode) {
        Optional layers = this.businessModuleService.findBusinessModuleByCode(Integer.valueOf(businessModuleCode)).map(ModuleMetier::getNom).map("carto.layers."::concat).flatMap(propertyName -> this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, propertyName)).or(() -> this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.layers"));
        if (layers.isEmpty()) {
            log.error("Carto layers are not configured");
            return Optional.empty();
        }
        return this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.url").map(cartoUrl -> new TileLayer(WMSController.Helper.createWMSLayerURL((String)cartoUrl, (String)((String)layers.get()), (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.formatImage").orElse(null)))).map(SimplePrismLayer::new);
    }

    public Optional<Map<String, IPrismLayer>> tryCreateCartoLayerSupp(int businessModuleCode) {
        Optional layers = this.businessModuleService.findBusinessModuleByCode(Integer.valueOf(businessModuleCode)).map(ModuleMetier::getNom).map("carto.layers.supp."::concat).flatMap(propertyName -> this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, propertyName)).or(() -> this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.layers.supp"));
        if (layers.isEmpty()) {
            log.error("Carto layers are not configured");
            return Optional.empty();
        }
        Optional configCartoUrl = this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.url");
        Map<String, IPrismLayer> layersSupp = Arrays.stream(((String)layers.get()).split(",")).collect(Collectors.toMap(cartoLayerName -> cartoLayerName, cartoLayerName -> new SimplePrismLayer((Layer)new TileLayer(WMSController.Helper.createWMSLayerURL((String)((String)configCartoUrl.get()), (String)cartoLayerName, (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.formatImage").orElse(null))))));
        return Optional.of(layersSupp);
    }

    public Optional<Map<String, IPrismLayer>> tryCreateCartoLayerSingleTile(int businessModuleCode) {
        Optional layers = this.businessModuleService.findBusinessModuleByCode(Integer.valueOf(businessModuleCode)).map(ModuleMetier::getNom).map("carto.layers.singletile."::concat).flatMap(propertyName -> this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, propertyName)).or(() -> this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.layers.singletile"));
        if (layers.isEmpty()) {
            log.error("Carto layers are not configured");
            return Optional.empty();
        }
        Optional configCartoUrl = this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("singleTile", "true");
        Map<String, IPrismLayer> layersSupp = Arrays.stream(((String)layers.get()).split(",")).collect(Collectors.toMap(cartoLayerName -> cartoLayerName, cartoLayerName -> new SimplePrismLayer((Layer)new TileLayer(WMSController.Helper.createWMSLayerURL((String)((String)configCartoUrl.get()), (String)cartoLayerName, (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.formatImage").orElse(null), (Map)params)))));
        return Optional.of(layersSupp);
    }

    public TronconVhLayer createTronconVhLayer(PatrolMctListService patrolMctListService) {
        return new TronconVhLayer(patrolMctListService.getPrimaryBusinessModuleCode(), this.suiviStyleService);
    }

    public TronconVhLayer createTronconVhLayer(int codeModuleMetier) {
        return new TronconVhLayer(codeModuleMetier, this.suiviStyleService);
    }

    @Generated
    public PrismLayerFactory(SuiviStyleService suiviStyleService, BusinessModuleService businessModuleService, ConfigurationService configurationService, PatrolService patrolService) {
        this.suiviStyleService = suiviStyleService;
        this.businessModuleService = businessModuleService;
        this.configurationService = configurationService;
        this.patrolService = patrolService;
    }
}

