/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.carto.layer;

import com.geolocsystems.prismcentral.beans.Coordonnees;
import com.geolocsystems.prismcentral.beans.LocalisationDonneesSaleuse;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.neogls.prism.central.vaadin.service.PatrolService;
import com.neogls.prism.central.vaadin.service.util.GeometryUtils;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.mct.common.carto.SuiviStyleService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.IPrismLayer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.groups.LayerGroup;
import org.vaadin.addons.componentfactory.leaflet.layer.ui.marker.Marker;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.Polyline;
import org.vaadin.addons.componentfactory.leaflet.types.Icon;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;
import org.vaadin.addons.componentfactory.leaflet.types.Point;

public class PatrolTracksLayer
implements IPrismLayer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PatrolTracksLayer.class);
    private final LayerGroup layerGroup = new LayerGroup(new Layer[0]);
    private final LayerGroup selectionLayer = new LayerGroup(new Layer[0]);
    private final LayerGroup focusLayer = new LayerGroup(new Layer[0]);
    private final SuiviStyleService suiviStyleService;
    private final PatrolService patrolService;
    private final int codeMM;

    public PatrolTracksLayer(SuiviStyleService suiviStyleService, PatrolService patrolService, int codeMM) {
        this.suiviStyleService = suiviStyleService;
        this.patrolService = patrolService;
        this.codeMM = codeMM;
        this.selectionLayer.addTo(this.layerGroup);
        this.focusLayer.addTo(this.layerGroup);
    }

    public void setSelectedPatrols(@Nonnull Collection<VehiculeEnIntervention> patrols) {
        this.selectionLayer.clearLayers();
        for (TronconSuivi troncon : this.patrolService.getTronconsSuivis(patrols)) {
            this.afficherTroncon(troncon, this.selectionLayer);
        }
    }

    public void setFocusedPatrol(@Nullable VehiculeEnIntervention patrol) {
        List<Object> patrolList = patrol != null ? List.of(patrol) : List.of();
        this.focusLayer.clearLayers();
        for (TronconSuivi troncon : this.patrolService.getTronconsSuivis(patrolList)) {
            this.afficherTroncon(troncon, this.focusLayer);
        }
        for (LocalisationDonneesSaleuse localisation : this.patrolService.getLocalisationDonneesSaleuses(patrolList)) {
            this.afficherDonneesSaleuse(localisation, this.focusLayer);
        }
    }

    private void afficherTroncon(TronconSuivi troncon, LayerGroup layer) {
        if (troncon.getX() == null) {
            log.warn("CARTOPANE AFFICH TRONCON - TRONCON {} EN ERREUR", (Object)troncon.getIdTronconSuivi());
            return;
        }
        List<LatLng> coordinates = GeometryUtils.lineFromFloatArrays((float[])troncon.getX(), (float[])troncon.getY()).stream().map(LeafletUtils::pointToLatLng).toList();
        if (this.suiviStyleService.hasStyleBorder(troncon.getCode(), Integer.valueOf(this.codeMM))) {
            Polyline lineBorder = new Polyline(coordinates);
            lineBorder.setStyle(this.suiviStyleService.getStyleBorder(troncon.getCode(), Integer.valueOf(this.codeMM)));
            lineBorder.addTo(layer);
        }
        Polyline line = new Polyline(coordinates);
        line.setStyle(this.suiviStyleService.getStyle(troncon.getCode(), Integer.valueOf(this.codeMM)));
        line.addTo(layer);
    }

    private void afficherDonneesSaleuse(LocalisationDonneesSaleuse localisation, LayerGroup layer) {
        if (localisation.getCoordonnees().isEmpty()) {
            return;
        }
        double x = ((Coordonnees)localisation.getCoordonnees().get(0)).getX();
        double y = ((Coordonnees)localisation.getCoordonnees().get(0)).getY();
        if (x == 0.0 || y == 0.0) {
            return;
        }
        Marker marker = new Marker(LatLng.latlng((double)y, (double)x));
        Icon icon = new Icon("images/ico/marker.png", 16);
        icon.setShadowUrl(null);
        icon.setIconAnchor(Point.of((double)8.0, (double)16.0));
        marker.setIcon(icon);
        marker.bindPopup(localisation.toHtml());
        marker.addTo(layer);
    }

    public Layer getLayer() {
        return this.layerGroup;
    }
}

