/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.carto.cluster;

import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.neogls.prism.central.vaadin.rest.eventicon.EventIconController;
import com.neogls.prism.central.vaadin.service.util.GeometryUtils;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.mct.common.carto.SuiviStyleService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.event.SituationMarkerClickEvent;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.event.SituationMarkerDoubleClickEvent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctCartoComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.ui.marker.Marker;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.Polyline;
import org.vaadin.addons.componentfactory.leaflet.types.Icon;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;

public class SituationClusterCartoComponent
implements MctCartoComponent<Situation> {
    @Nullable
    private final Integer mmCode;
    private final ClusterCartoPane clusterCartoPane;
    private final SuiviStyleService suiviStyleService;
    @Nullable
    private Polyline linear = null;
    private final Table<String, String, Marker> markersBySid = HashBasedTable.create();

    public void renderItems(Collection<Situation> items) {
        this.focusOn(null, false);
        this.markersBySid.clear();
        this.clusterCartoPane.clearMarkers(ClusterCartoPane.ItemType.SITUATION);
        this.clusterCartoPane.addMarkers(ClusterCartoPane.ItemType.SITUATION, items.stream().map(arg_0 -> this.createMarker(arg_0)).toList());
    }

    private Marker createMarker(Situation situation) {
        Marker marker = new Marker();
        Position position = situation.getEvenementPrincipal().getLocalisation().getPositionDebut();
        marker.setLatLng(LatLng.latlng((double)position.getY(), (double)position.getX()));
        Icon icon = new Icon(EventIconController.Helper.createEventIconURL((String)situation.getEvenementPrincipal().getValeurNature().getCode()), 32);
        icon.setShadowSize(null);
        icon.setShadowUrl(null);
        marker.setIcon(icon);
        marker.onClick(event -> ComponentUtil.fireEvent((Component)this.clusterCartoPane, (ComponentEvent)new SituationMarkerClickEvent((Component)this.clusterCartoPane, event.isFromClient(), situation)));
        marker.onDoubleClick(event -> ComponentUtil.fireEvent((Component)this.clusterCartoPane, (ComponentEvent)new SituationMarkerDoubleClickEvent((Component)this.clusterCartoPane, event.isFromClient(), situation)));
        this.markersBySid.put((Object)situation.getSid(), (Object)situation.getEvenementPrincipal().getIdReference(), (Object)marker);
        return marker;
    }

    public void focusOn(Situation item, boolean zoom) {
        Marker marker = item != null ? (Marker)this.markersBySid.get((Object)item.getSid(), (Object)item.getEvenementPrincipal().getIdReference()) : null;
        this.clusterCartoPane.focusMarker(marker, zoom);
        if (this.linear != null) {
            this.linear.remove();
        }
        if (item == null || item.getEvenementPrincipal().getLocalisation() == null || item.getEvenementPrincipal().getLocalisation().getX().length <= 2) {
            this.linear = null;
        } else {
            ValeurChampLocalisation localisation = item.getEvenementPrincipal().getLocalisation();
            List<LatLng> coordinates = GeometryUtils.lineFromFloatArrays((float[])localisation.getX(), (float[])localisation.getY()).stream().map(LeafletUtils::pointToLatLng).toList();
            this.linear = new Polyline(coordinates);
            this.linear.setStyle(this.suiviStyleService.getStyle(null, this.mmCode));
            this.clusterCartoPane.addLayer((Layer)this.linear);
        }
    }

    public void addItemClickListener(ComponentEventListener<MctCartoComponent.ItemClickEvent<Situation>> listener) {
        ComponentUtil.addListener((Component)this.clusterCartoPane, SituationMarkerClickEvent.class, arg_0 -> listener.onComponentEvent(arg_0));
    }

    public void addItemDoubleClickListener(ComponentEventListener<MctCartoComponent.ItemDoubleClickEvent<Situation>> listener) {
        ComponentUtil.addListener((Component)this.clusterCartoPane, SituationMarkerDoubleClickEvent.class, arg_0 -> listener.onComponentEvent(arg_0));
    }

    @Generated
    public SituationClusterCartoComponent(@Nullable Integer mmCode, ClusterCartoPane clusterCartoPane, SuiviStyleService suiviStyleService) {
        this.mmCode = mmCode;
        this.clusterCartoPane = clusterCartoPane;
        this.suiviStyleService = suiviStyleService;
    }
}

