/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.carto.cluster;

import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.neogls.prism.central.vaadin.rest.patrolicon.PatrolIconController;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.event.PatrolClusterCartoComponentService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.event.PatrolMarkerClickEvent;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.event.PatrolMarkerDoubleClickEvent;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PatrolTracksLayer;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctCartoComponent;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolActionListener;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.vaadin.addons.componentfactory.leaflet.layer.ui.marker.Marker;
import org.vaadin.addons.componentfactory.leaflet.types.Icon;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;

public class PatrolClusterCartoComponent
implements MctCartoComponent<VehiculeEnIntervention> {
    @Nullable
    private final Integer codeMM;
    private final ClusterCartoPane clusterCartoPane;
    private final PatrolClusterCartoComponentService service;
    private final Map<String, Marker> markersById = new HashMap();
    @Nullable
    private PatrolTracksLayer patrolTracksLayer = null;

    public void renderItems(Collection<VehiculeEnIntervention> items) {
        this.focusOn(null, false);
        this.markersById.clear();
        this.clusterCartoPane.clearMarkers(ClusterCartoPane.ItemType.PATROL);
        this.clusterCartoPane.addMarkers(ClusterCartoPane.ItemType.PATROL, items.stream().map(arg_0 -> this.createMarker(arg_0)).toList());
        if (this.patrolTracksLayer != null) {
            this.patrolTracksLayer.setSelectedPatrols(items);
        }
    }

    private Marker createMarker(VehiculeEnIntervention patrol) {
        Marker marker = new Marker();
        marker.setLatLng(LatLng.latlng((double)patrol.getY(), (double)patrol.getX()));
        Icon icon = new Icon(PatrolIconController.Helper.createPatrolIconURL((VehiculeEnIntervention)patrol), 32);
        icon.setShadowSize(null);
        icon.setShadowUrl(null);
        marker.setIcon(icon);
        marker.onClick(event -> ComponentUtil.fireEvent((Component)this.clusterCartoPane, (ComponentEvent)new PatrolMarkerClickEvent((Component)this.clusterCartoPane, event.isFromClient(), patrol)));
        marker.onDoubleClick(event -> ComponentUtil.fireEvent((Component)this.clusterCartoPane, (ComponentEvent)new PatrolMarkerDoubleClickEvent((Component)this.clusterCartoPane, event.isFromClient(), patrol)));
        this.markersById.put(patrol.getIdPatrouille(), marker);
        return marker;
    }

    public void focusOn(VehiculeEnIntervention item, boolean zoom) {
        Marker marker = item != null ? (Marker)this.markersById.get(item.getIdPatrouille()) : null;
        this.clusterCartoPane.focusMarker(marker, zoom);
        if (this.patrolTracksLayer != null) {
            this.patrolTracksLayer.setFocusedPatrol(item);
        }
    }

    public void addItemClickListener(ComponentEventListener<MctCartoComponent.ItemClickEvent<VehiculeEnIntervention>> listener) {
        ComponentUtil.addListener((Component)this.clusterCartoPane, PatrolMarkerClickEvent.class, arg_0 -> listener.onComponentEvent(arg_0));
    }

    public void addItemDoubleClickListener(ComponentEventListener<MctCartoComponent.ItemDoubleClickEvent<VehiculeEnIntervention>> listener) {
        ComponentUtil.addListener((Component)this.clusterCartoPane, PatrolMarkerDoubleClickEvent.class, arg_0 -> listener.onComponentEvent(arg_0));
    }

    public void addPatrolTracksLayer(@Nonnull PatrolActionListener patrolActionListener) {
        if (this.codeMM == null) {
            throw new IllegalStateException("Impossible d'ajouter la couche 'Trac\u00e9s', aucun code module m\u00e9tier associ\u00e9 \u00e0 ce ClusterCartoPane");
        }
        this.patrolTracksLayer = this.service.createPatrolTracksLayer(this.codeMM.intValue());
        patrolActionListener.setPatrolTracksLayer(this.patrolTracksLayer);
        this.patrolTracksLayer.addTo((ICartoPane)this.clusterCartoPane, "Trac\u00e9s");
    }

    @Generated
    public PatrolClusterCartoComponent(@Nullable Integer codeMM, ClusterCartoPane clusterCartoPane, PatrolClusterCartoComponentService service) {
        this.codeMM = codeMM;
        this.clusterCartoPane = clusterCartoPane;
        this.service = service;
    }
}

