/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.carto.cluster;

import com.geolocsystems.prismandroid.model.Bounds;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.mct.common.carto.SuiviStyleService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.PatrolClusterCartoComponent;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.SituationClusterCartoComponent;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.event.PatrolClusterCartoComponentService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.IPrismLayer;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PrismLayerFactory;
import jakarta.annotation.Nullable;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;

@Service
public class ClusterCartoPaneService {
    private final ConfigurationService configurationService;
    private final PatrolClusterCartoComponentService patrolClusterCartoComponentService;
    private final PrismLayerFactory prismLayerFactory;
    private final SuiviStyleService suiviStyleService;
    private final UserPermissionService userPermissionService;

    public LatLngBounds getMapBounds() {
        return LeafletUtils.toLeafletMapBounds((Bounds)this.userPermissionService.getBounds());
    }

    public LeafletMap createMap(LatLngBounds initialBounds) {
        return LeafletUtils.createMap((ConfigurationService)this.configurationService, (LatLngBounds)initialBounds, null);
    }

    public SituationClusterCartoComponent createSituationClusterCartoComponent(ClusterCartoPane clusterCartoPane, @Nullable Integer codeMM) {
        return new SituationClusterCartoComponent(codeMM, clusterCartoPane, this.suiviStyleService);
    }

    public PatrolClusterCartoComponent createPatrolClusterCartoComponent(ClusterCartoPane clusterCartoPane, @Nullable Integer codeMM) {
        return new PatrolClusterCartoComponent(codeMM, clusterCartoPane, this.patrolClusterCartoComponentService);
    }

    public Optional<IPrismLayer> createCartoLayer(int codeMM) {
        return this.prismLayerFactory.tryCreateCartoLayer(codeMM);
    }

    @Generated
    public ClusterCartoPaneService(ConfigurationService configurationService, PatrolClusterCartoComponentService patrolClusterCartoComponentService, PrismLayerFactory prismLayerFactory, SuiviStyleService suiviStyleService, UserPermissionService userPermissionService) {
        this.configurationService = configurationService;
        this.patrolClusterCartoComponentService = patrolClusterCartoComponentService;
        this.prismLayerFactory = prismLayerFactory;
        this.suiviStyleService = suiviStyleService;
        this.userPermissionService = userPermissionService;
    }
}

