/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.carto.cluster;

import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.neogls.prism.central.vaadin.common.bean.Point3D;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.PatrolClusterCartoComponent;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.SituationClusterCartoComponent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctCartoComponent;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolActionListener;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.controls.LayersControl;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.groups.LayerGroup;
import org.vaadin.addons.componentfactory.leaflet.layer.ui.marker.Marker;
import org.vaadin.addons.componentfactory.leaflet.plugins.markercluster.MarkerClusterGroup;
import org.vaadin.addons.componentfactory.leaflet.plugins.markercluster.MarkerClusterOptions;
import org.vaadin.addons.componentfactory.leaflet.types.Icon;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;
import org.vaadin.addons.componentfactory.leaflet.types.Point;

public class ClusterCartoPane
extends VerticalLayout
implements ICartoPane {
    private final LatLngBounds maxBounds;
    private final LeafletMap map;
    private final LayersControl layersControl;
    private final SituationClusterCartoComponent situationClusterCartoComponent;
    private final PatrolClusterCartoComponent patrolClusterCartoComponent;
    private final ClusterCartoPaneService service;
    @Nullable
    private final Integer codeMM;
    private final MarkerClusterGroup markerClusterGroup;
    private final Multimap<ItemType, Layer> layersByItemType = ArrayListMultimap.create();
    private Marker focused = null;
    private LatLng latLng = null;
    private Integer zoom = null;

    protected ClusterCartoPane(ClusterCartoPaneService service, @Nullable Integer codeMM) {
        this.situationClusterCartoComponent = service.createSituationClusterCartoComponent(this, codeMM);
        this.patrolClusterCartoComponent = service.createPatrolClusterCartoComponent(this, codeMM);
        this.service = service;
        this.codeMM = codeMM;
        this.maxBounds = service.getMapBounds();
        this.map = service.createMap(this.maxBounds);
        this.map.whenReady((ComponentEventListener & Serializable)event -> this.refreshState());
        this.map.onMoveEnd(event -> this.refreshState());
        this.map.onZoomEnd(event -> this.refreshState());
        this.layersControl = new LayersControl();
        this.layersControl.addTo(this.map);
        Layer osmLayer = LeafletUtils.createOSMLayer();
        osmLayer.addTo(this.map);
        this.layersControl.addOverlay(osmLayer, "OSM");
        this.add(new Component[]{this.map});
        this.setPadding(false);
        MarkerClusterOptions markerClusterOptions = new MarkerClusterOptions();
        markerClusterOptions.setShowCoverageOnHover(false);
        this.markerClusterGroup = new MarkerClusterGroup(markerClusterOptions);
        this.markerClusterGroup.addTo(this.map);
    }

    private void refreshState() {
        if (this.map.isReady()) {
            this.map.getCenter().thenAccept(center -> {
                this.latLng = center;
            });
            this.map.getZoom().thenAccept(zoomValue -> {
                this.zoom = zoomValue;
            });
        }
    }

    public MctCartoComponent<Situation> getSituationCartoComponent() {
        return this.situationClusterCartoComponent;
    }

    public MctCartoComponent<VehiculeEnIntervention> getPatrolCartoComponent() {
        return this.patrolClusterCartoComponent;
    }

    public void invalidateMapSize() {
        this.map.invalidateSize();
    }

    public void addLayer(@Nonnull Layer layer) {
        layer.addTo(this.map);
    }

    public void addOverlayLayer(@Nonnull Layer layer, String name) {
        layer.addTo(this.map);
        this.layersControl.addOverlay(layer, name);
    }

    public void removeLayer(@Nonnull Layer layer) {
        layer.remove();
        this.layersControl.removeLayer(layer);
    }

    public LeafletMap getMap() {
        return this.map;
    }

    public void clearMarkers(ItemType itemType) {
        this.layersByItemType.get((Object)itemType).clear();
        this.markerClusterGroup.clearLayers();
        this.layersByItemType.values().forEach(layer -> layer.addTo((LayerGroup)this.markerClusterGroup));
    }

    public void addMarkers(ItemType itemType, Collection<? extends Layer> markers) {
        markers.forEach(layer -> layer.addTo((LayerGroup)this.markerClusterGroup));
        this.layersByItemType.putAll((Object)itemType, markers);
    }

    public void focusMarker(Marker toFocus, boolean zoom) {
        Icon icon;
        if (this.focused == toFocus) {
            return;
        }
        if (this.focused != null) {
            icon = this.focused.getIcon();
            icon.setIconSize(LeafletUtils.scale((Point)icon.getIconSize(), (double)0.5));
            icon.setIconAnchor(LeafletUtils.scale((Point)icon.getIconAnchor(), (double)0.5));
            this.focused.setIcon(icon);
            this.focused.setZIndexOffset(0);
        }
        this.focused = toFocus;
        if (toFocus != null) {
            icon = toFocus.getIcon();
            icon.setIconSize(LeafletUtils.scale((Point)icon.getIconSize(), (double)2.0));
            icon.setIconAnchor(LeafletUtils.scale((Point)icon.getIconAnchor(), (double)2.0));
            toFocus.setIcon(icon);
            if (zoom) {
                this.map.setView(toFocus.getLatLng(), 17);
            }
        } else if (zoom) {
            this.map.fitBounds(this.maxBounds);
        }
    }

    public Point3D getCenterZoom() {
        if (this.latLng != null && this.zoom != null) {
            return new Point3D(this.latLng.getLng().doubleValue(), this.latLng.getLat().doubleValue(), this.zoom.intValue());
        }
        return null;
    }

    public void addCartoLayer() {
        Optional.ofNullable(this.codeMM).flatMap(arg_0 -> ((ClusterCartoPaneService)this.service).createCartoLayer(arg_0)).ifPresent(cartoLayer -> cartoLayer.addTo((ICartoPane)this, "Carto"));
    }

    public void addPatrolTracksLayer(@Nonnull PatrolActionListener patrolActionListener) {
        this.patrolClusterCartoComponent.addPatrolTracksLayer(patrolActionListener);
    }
}

