/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.carto;

import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import gls.outils.ConstantesGLS;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Service;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.PathOptions;

@Service
public class SuiviStyleService {
    private final Map<String, PathOptions> styles = new HashMap();
    private final ConfigurationService configurationService;
    private final BusinessModuleService businessModuleService;
    private static final String COULEUR_LIGNE_HEX = "#9966FF";
    private static final String KEY_WIDTH = "largeur";
    public static final double WIDTH_DEFAULT = 3.0;
    private static final String KEY_OPACITY = "opacite";
    private static final String KEY_DASH = "pointille";
    private static final String KEY_BORDER = "border";
    private static final String KEY_BORDER_COLOR = "couleur";
    private static String[] CODES_DASH = new String[0];
    public static final double OPACITY_STANDARD = 1.0;
    public static final double OPACITY_FAIBLE = 0.8;
    public static final double WIDTH_DEFAUT = 3.0;
    public static final boolean POINTILLE_DEFAUT = false;
    public static final boolean BORDER_DEFAUT = false;
    private static final String COULEUR_LIGNE_BORDER = "#000000";
    private static final String DASH_OFFSET_DEFAULT = "3";
    private static final String DASH_ARRAY_DEFAULT = "3,1";
    private static final int DEFAULT_CARTO_STYLE_WIDTH_COEFF = 10;

    @Nonnull
    private String getCode(String code) {
        return ConstantesGLS.estVide((String)code) ? "NR" : code;
    }

    @Nonnull
    private String getCodeStyle(@Nonnull String code, @Nullable String businessModuleName) {
        return ((String)(ConstantesGLS.estVide((String)businessModuleName) ? code : businessModuleName + "." + code)).toLowerCase();
    }

    public PathOptions getStyle(@Nullable String code, @Nullable Integer businessModuleCode) {
        String businessModuleName = this.businessModuleService.findBusinessModuleByCode(businessModuleCode).map(ModuleMetier::getNom).orElse(null);
        String safeCode = this.getCode(code);
        String fullCode = this.getCodeStyle(safeCode, businessModuleName);
        return this.styles.computeIfAbsent(fullCode, ignored -> this.createStyle(fullCode, safeCode));
    }

    private PathOptions createStyle(String fullCode, String safeCode) {
        PathOptions style = new PathOptions();
        String codeCouleur = this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + fullCode).or(() -> this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + safeCode.toLowerCase())).orElse(COULEUR_LIGNE_HEX);
        style.setColor(codeCouleur);
        style.setFill(false);
        style.setWeight(this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + fullCode + ".largeur").filter(NumberUtils::isParsable).map(Double::parseDouble).orElse(3.0).doubleValue());
        if (this.configurationService.getBoolean(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + fullCode + ".pointille").or(() -> this.configurationService.getBoolean(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + safeCode.toLowerCase() + ".pointille")).orElse(false).booleanValue()) {
            style.setDashArray(DASH_ARRAY_DEFAULT);
            style.setDashOffset(DASH_OFFSET_DEFAULT);
        }
        return style;
    }

    public boolean hasStyleBorder(@Nullable String code, @Nullable Integer businessModuleCode) {
        String businessModuleName = this.businessModuleService.findBusinessModuleByCode(businessModuleCode).map(ModuleMetier::getNom).orElse(null);
        String safeCode = this.getCode(code);
        String fullCode = this.getCodeStyle(safeCode, businessModuleName);
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + fullCode + ".border").or(() -> this.configurationService.getBoolean(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + safeCode.toLowerCase() + ".border")).orElse(false);
    }

    public PathOptions getStyleBorder(@Nullable String code, @Nullable Integer businessModuleCode) {
        String businessModuleName = this.businessModuleService.findBusinessModuleByCode(businessModuleCode).map(ModuleMetier::getNom).orElse(null);
        String safeCode = this.getCode(code);
        String fullCode = this.getCodeStyle(safeCode, businessModuleName);
        ArrayList<PathOptions> fullStyles = new ArrayList<PathOptions>();
        fullStyles.add(this.styles.computeIfAbsent(fullCode, ignored -> this.createStyle(fullCode, safeCode)));
        PathOptions styleBorder = new PathOptions();
        styleBorder.setFill(false);
        String codeCouleurBorder = this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + fullCode + ".border.couleur").or(() -> this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + safeCode.toLowerCase() + ".border.couleur")).orElse(COULEUR_LIGNE_BORDER);
        styleBorder.setColor(codeCouleurBorder);
        double weigthBorder = this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + fullCode + ".border.largeur").filter(NumberUtils::isParsable).map(Double::parseDouble).orElse(4.0);
        styleBorder.setWeight(weigthBorder);
        double opacity = this.configurationService.getDouble(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + fullCode + ".border.opacite").or(() -> this.configurationService.getDouble(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + safeCode.toLowerCase() + ".border.opacite")).orElse(1.0);
        styleBorder.setOpacity(opacity);
        if (this.configurationService.getBoolean(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + fullCode + ".border.pointille").or(() -> this.configurationService.getBoolean(ConfigurationService.ConfigurationType.PROPERTY, "carto.couleur." + safeCode.toLowerCase() + ".border.pointille")).orElse(false).booleanValue()) {
            styleBorder.setDashArray(DASH_ARRAY_DEFAULT);
            styleBorder.setDashOffset(DASH_OFFSET_DEFAULT);
            styleBorder.setStroke(true);
        }
        return styleBorder;
    }

    @Generated
    public SuiviStyleService(ConfigurationService configurationService, BusinessModuleService businessModuleService) {
        this.configurationService = configurationService;
        this.businessModuleService = businessModuleService;
    }
}

