/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane;

import com.neogls.prism.central.vaadin.layout.LocalisationSearch;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePaneTab;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePaneTabImpl;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.TabSheet;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;

public class BottomSidePaneImpl
extends BottomSidePane {
    private final TabSheet tabSheet = new TabSheet();
    private final HorizontalLayout importantLayout = new HorizontalLayout();
    private final Map<BottomSidePane.DefaultTab, BottomSidePaneTab> tabContents = new EnumMap(BottomSidePane.DefaultTab.class);
    private final Map<BottomSidePaneTab, Tab> tabs = new HashMap();

    BottomSidePaneImpl() {
        this.tabSheet.setSizeFull();
        this.tabSheet.addThemeName("scroller-p-0");
        for (BottomSidePane.DefaultTab defaultTab : BottomSidePane.DefaultTab.values()) {
            BottomSidePaneTabImpl tabContent = new BottomSidePaneTabImpl(this);
            Tab tabSheetTab = this.tabSheet.add(defaultTab.getLabel(), (Component)tabContent);
            this.tabContents.put(defaultTab, tabContent);
            this.tabs.put(tabContent, tabSheetTab);
        }
        Icon expandIcon = new Icon(VaadinIcon.ANGLE_DOUBLE_UP);
        Icon reduceIcon = new Icon(VaadinIcon.ANGLE_DOUBLE_DOWN);
        expandIcon.addClickListener((ComponentEventListener & Serializable)e -> {
            this.tabSheet.setVisible(true);
            reduceIcon.setVisible(true);
            expandIcon.setVisible(false);
            this.importantLayout.setVisible(false);
        });
        reduceIcon.addClickListener((ComponentEventListener & Serializable)e -> {
            this.tabSheet.setVisible(false);
            reduceIcon.setVisible(false);
            expandIcon.setVisible(true);
            this.importantLayout.setVisible(true);
        });
        expandIcon.setVisible(false);
        expandIcon.addClassNames(new String[]{"bottom-side-icon-expand", "icon-m", "content-center"});
        expandIcon.setColor("#666666");
        reduceIcon.addClassNames(new String[]{"bottom-side-icon-reduce", "icon-m", "content-center"});
        reduceIcon.setColor("#666666");
        this.importantLayout.setSizeFull();
        this.importantLayout.addClassNames(new String[]{"bottom-side-important"});
        this.importantLayout.setVisible(false);
        ((HorizontalLayout)this.getContent()).add(new Component[]{expandIcon, reduceIcon, this.tabSheet, this.importantLayout});
        ((HorizontalLayout)this.getContent()).setPadding(false);
        ((HorizontalLayout)this.getContent()).setWidthFull();
        ((HorizontalLayout)this.getContent()).setSpacing(false);
        this.addClassNames(new String[]{"content-center"});
        this.addClassNames(new String[]{"items-start"});
        this.setSelectedTab(this.getTab(BottomSidePane.DefaultTab.INFORMATIONS));
    }

    public void initSearchTab(LeafletMap map) {
        this.getTab(BottomSidePane.DefaultTab.RECHERCHE).newSlot().setContent((Component)new LocalisationSearch(map));
    }

    public void setSelectedTab(BottomSidePaneTab tab) {
        this.tabSheet.setSelectedTab((Tab)this.tabs.get(tab));
    }

    public void setImportantMessage(Component component) {
        this.clearImportantMessage();
        this.importantLayout.add(new Component[]{component});
    }

    public void clearImportantMessage() {
        this.importantLayout.removeAll();
    }

    public BottomSidePaneTab getTab(BottomSidePane.DefaultTab tab) {
        return (BottomSidePaneTab)this.tabContents.get(tab);
    }

    public BottomSidePaneTab newTab(String label) {
        BottomSidePaneTabImpl tabContent = new BottomSidePaneTabImpl(this);
        Tab tabSheetTab = this.tabSheet.add(label, (Component)tabContent);
        this.tabs.put(tabContent, tabSheetTab);
        return tabContent;
    }

    public void removeTab(BottomSidePaneTab tab) {
        Tab tabSheetTab = (Tab)this.tabs.remove(tab);
        this.tabSheet.remove(tabSheetTab);
    }
}

