/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common;

import cartoj.ICouche;
import com.geolocsystems.prism.localisation.ICartoServiceData;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.Utilisateur;
import com.geolocsystems.prismandroid.model.Vehicule;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDropListe;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiCheckBox;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.ListeDestinataireMail;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.ICartoService;
import com.geolocsystems.prismcentralvaadin.data.BusinessServiceFactory;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.service.util.AuthenticatedUserUtils;
import com.neogls.prism.central.vaadin.service.util.ListUtils;
import gls.outils.GLS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class VaadinFieldComponentService {
    private final UserPermissionService userPermissionService;
    private final IBusinessService businessService;
    private final BusinessModuleService businessModuleService;
    private final ConfigurationService configurationService;
    private final ICartoService cartoService;

    public List<String> getChampDropListValues(ChampDropListe champDropListe) {
        return this.getValues(champDropListe.getValeursSystemes(), champDropListe.getValeurs(), true);
    }

    public List<String> getChampMultiCheckBoxValues(ChampMultiCheckBox champMultiCheckBox) {
        return this.getValues(champMultiCheckBox.getValeursSystemes(), champMultiCheckBox.getValeurs(), false);
    }

    private List<String> getValues(String systemValues, List<String> values, boolean addEmptyValueIfSysteme) {
        if (systemValues == null) {
            return Objects.requireNonNullElseGet(values, List::of);
        }
        AuthenticatedUser currentUser = this.userPermissionService.getCurrentUser();
        if ("<utilisateur_delegation>".equals(systemValues)) {
            return this.getUsers(AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)currentUser), AuthenticatedUserUtils.getCenterString((AuthenticatedUser)currentUser), false);
        }
        List systemValueList = switch (systemValues) {
            case "<vehicule>" -> this.getVehicles(-1);
            case "<vehiculevh>" -> this.getVehicles(1);
            case "<vehiculeesh>" -> this.getVehicles(1000);
            case "<circuit>" -> this.getCircuits(this.businessModuleService.getBusinessModulePatrouillage());
            case "<circuitvh>" -> this.getCircuits(this.businessModuleService.getBusinessModuleVH().orElseGet(() -> ((BusinessModuleService)this.businessModuleService).getBusinessModulePatrouillage()));
            case "<circuitesh>" -> this.getCircuits(this.businessModuleService.getBusinessModuleESH().orElseGet(() -> ((BusinessModuleService)this.businessModuleService).getBusinessModulePatrouillage()));
            case "<utilisateur>" -> this.getUsers(AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)currentUser), AuthenticatedUserUtils.getCenterString((AuthenticatedUser)currentUser), true);
            case "<utilisateur_cei>" -> this.getUsers(AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)currentUser), AuthenticatedUserUtils.getCenterString((AuthenticatedUser)currentUser), false);
            case "<utilisateur_tous>" -> this.getUsers(null, null, false);
            case "<delegation>" -> this.getDelegations();
            case "<centre>" -> this.getCentresString();
            case "<centre-delegation>" -> this.getCentresDelegationString();
            case "<delegation_auto>" -> this.getDelegations();
            case "<modalite_ig4>", "<rythme_ig4>" -> List.of();
            case "<declenchement_intervention>" -> this.configurationService.getList(ConfigurationService.ConfigurationType.DATABASE, "provenanceInformation").orElseGet(() -> List.of(MetierCommun.PROVENANCE_INFORMATION_DEFAUT));
            case "<liste_destinataire>" -> this.businessService.getListeDestinataireMails().stream().map(ListeDestinataireMail::getNom).toList();
            case "<ppcircuit>" -> this.getPointsPassage();
            default -> this.getDefaultSystemValue(systemValues);
        };
        return systemValueList != null ? ListUtils.concat(List.of(""), (List)systemValueList) : Objects.requireNonNullElseGet(values, List::of);
    }

    private List<String> getDefaultSystemValue(String systemValues) {
        if (systemValues.startsWith("<referentiel-")) {
            return this.getReferentielCentreValeursSysteme(systemValues);
        }
        return null;
    }

    private List<String> getVehicles(int businessModuleCode) {
        return this.businessService.getListeVehicule().stream().filter(vehicule -> businessModuleCode == -1 || businessModuleCode == vehicule.getType()).filter(this.getDelegationFilter(Vehicule::getDelegation)).filter(this.getCenterFilter(Vehicule::getCentre)).filter(Predicate.not(Vehicule::isArchive)).map(Object::toString).toList();
    }

    private List<String> getCircuits(ModuleMetier businessModule) {
        return businessModule.getCircuits().stream().filter(this.getDelegationFilter(Circuit::getDelegation)).filter(this.getCenterFilter(Circuit::getCentre)).map(Objects::toString).toList();
    }

    private List<String> getDelegations() {
        return this.businessService.getDelegationsActives().stream().map(Delegation::getNom).toList();
    }

    private List<String> getUsers(@Nullable String delegationStr, @Nullable String centerStr, boolean allowEmpty) {
        return this.businessService.rechercheToutUtilisateurEmbarque().stream().filter(this.getDelegationFilter(delegationStr, Utilisateur::getDelegation, allowEmpty)).filter(this.getCenterFilter(centerStr, Utilisateur::getCentre, allowEmpty)).map(MetierCommun::getLibelleUnique).toList();
    }

    private List<String> getPointsPassage() {
        return this.businessService.getZonesSensibles().values().stream().flatMap(Collection::stream).filter(zoneSensible -> zoneSensible.getType() == 5).map(Troncon::getDescription).sorted().toList();
    }

    private <T> Predicate<T> getDelegationFilter(Function<T, String> delegationGetter) {
        return this.getDelegationFilter(AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)this.userPermissionService.getCurrentUser()), delegationGetter, true);
    }

    private <T> Predicate<T> getDelegationFilter(String delegationStr, Function<T, String> delegationGetter, boolean allowEmpty) {
        return delegationStr == null ? item -> true : item -> {
            String itemDelegation = (String)delegationGetter.apply(item);
            return allowEmpty && MetierCommun.estDelegationVide((String)itemDelegation) || delegationStr.equals(itemDelegation);
        };
    }

    private <T> Predicate<T> getCenterFilter(Function<T, String> centerGetter) {
        return this.getCenterFilter(AuthenticatedUserUtils.getCenterString((AuthenticatedUser)this.userPermissionService.getCurrentUser()), centerGetter, true);
    }

    private <T> Predicate<T> getCenterFilter(String centerStr, Function<T, String> centerGetter, boolean allowEmpty) {
        return centerStr == null ? item -> true : item -> {
            String itemCenter = (String)centerGetter.apply(item);
            return allowEmpty && MetierCommun.estCentreVide((String)itemCenter) || centerStr.equals(itemCenter);
        };
    }

    public ICouche getCouche(String nomCouche) {
        ICartoServiceData carto = BusinessServiceFactory.getCartoService();
        return carto.getCarto().getCouche(nomCouche);
    }

    public static String parseParametreReferentielCentre(String parametre) {
        try {
            return parametre.replace("<referentiel-", "").replace(">", "");
        }
        catch (Exception e) {
            return "[ERR]";
        }
    }

    public List<String> getReferentielCentreValeursSysteme(String valeurSysteme) {
        List liste = new ArrayList();
        String centre = AuthenticatedUserUtils.getCenterString((AuthenticatedUser)this.userPermissionService.getCurrentUser());
        String delegation = AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)this.userPermissionService.getCurrentUser());
        String parametre = VaadinFieldComponentService.parseParametreReferentielCentre((String)valeurSysteme);
        if (!GLS.estVide((String)centre)) {
            liste = this.getReferentielCentre(parametre, centre, "*");
        } else if (!GLS.estVide((String)delegation)) {
            int indice = GLS.getIndiceObjetListe((List)this.businessService.getDelegations(), (Object)delegation);
            if (indice > -1) {
                Delegation d = (Delegation)this.businessService.getDelegations().get(indice);
                for (Centre c : d.getCentres()) {
                    liste.addAll(this.getReferentielCentre(parametre, c.getNom(), null));
                }
                liste = MetierCommun.trier(liste);
            }
        } else {
            for (List l : ((Map)this.getReferentielCentre().get(parametre)).values()) {
                liste.addAll(l);
            }
            liste = MetierCommun.trier(liste);
        }
        return liste;
    }

    public List<String> getCentresString() {
        List l = this.businessService.getDelegations();
        ArrayList<String> centresString = new ArrayList<String>(l.size());
        for (Delegation d : l) {
            for (Centre c : d.getCentres()) {
                centresString.add(c.getNom());
            }
        }
        return MetierCommun.trier(centresString);
    }

    public List<String> getCentresDelegationString() {
        Delegation d = this.userPermissionService.getCurrentUser().getDelegation();
        ArrayList<String> centresString = new ArrayList<String>();
        if (d != null) {
            for (Centre c : d.getCentres()) {
                centresString.add(c.getNom());
            }
        } else {
            return this.getCentresString();
        }
        return MetierCommun.trier(centresString);
    }

    public List<String> getReferentielCentre(String type, String centre, String defaut) {
        try {
            if (this.getReferentielCentre().containsKey(type)) {
                if (((Map)this.getReferentielCentre().get(type)).containsKey(centre)) {
                    return (List)((Map)this.getReferentielCentre().get(type)).get(centre);
                }
                if (defaut != null && ((Map)this.getReferentielCentre().get(type)).containsKey(defaut)) {
                    return (List)((Map)this.getReferentielCentre().get(type)).get(defaut);
                }
            }
        }
        catch (Exception e) {
            Log.error((Object)("err ref centre " + type + " - " + centre), (Throwable)e);
        }
        return new ArrayList<String>();
    }

    public Map<String, Map<String, List<String>>> getReferentielCentre() {
        return this.businessService.getReferentielCentre();
    }

    @Generated
    public VaadinFieldComponentService(UserPermissionService userPermissionService, IBusinessService businessService, BusinessModuleService businessModuleService, ConfigurationService configurationService, ICartoService cartoService) {
        this.userPermissionService = userPermissionService;
        this.businessService = businessService;
        this.businessModuleService = businessModuleService;
        this.configurationService = configurationService;
        this.cartoService = cartoService;
    }
}

