/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common;

import com.neogls.prism.central.vaadin.common.bean.Point3D;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.LeftSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePane;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.UIDetachedException;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.server.Command;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;

public abstract class CommonMct
extends Composite<SplitLayout> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonMct.class);
    private final ConfigurationService configurationService;
    private final String logPrefix = this.getClass().getSimpleName();
    private boolean autoRefresh = true;
    private boolean refreshRequested = false;

    @PostConstruct
    private void commonInit() {
        SplitLayout content = (SplitLayout)this.getContent();
        content.setSizeFull();
        LeftSidePane leftSidePane = this.getLeftSidePane();
        leftSidePane.setMinWidth((float)((Integer)this.configurationService.getInt(ConfigurationService.ConfigurationType.PROPERTY, "mctLeftDefaultWidth").orElseThrow()).intValue(), Unit.PIXELS);
        BottomSidePane bottomSidePane = this.getBottomSidePane();
        ICartoPane cartoPane = this.getCartoPane();
        cartoPane.setSizeFull();
        Point3D centerZoom = (Point3D)UI.getCurrent().getSession().getAttribute(this.getClass().getName());
        if (centerZoom != null) {
            LatLngBounds bounds = new LatLngBounds(LatLng.latlng((double)centerZoom.getLat(), (double)centerZoom.getLng()));
            cartoPane.getMap().onLoad(event -> {
                cartoPane.getMap().fitBounds(bounds);
                cartoPane.getMap().setZoom(centerZoom.getZoom());
            });
        }
        VerticalLayout layoutCarto = new VerticalLayout();
        layoutCarto.setMinWidth(100.0f, Unit.PIXELS);
        layoutCarto.setMargin(false);
        layoutCarto.setSpacing(false);
        layoutCarto.setPadding(false);
        if (!(cartoPane instanceof Component)) {
            throw new IllegalStateException("CartoPane should extends Component but %s does not".formatted(cartoPane.getClass().getSimpleName()));
        }
        Component cartoPaneComponent = (Component)cartoPane;
        layoutCarto.add(new Component[]{cartoPaneComponent, bottomSidePane});
        content.addSplitterDragendListener((ComponentEventListener & Serializable)e -> cartoPane.invalidateMapSize());
        content.addToPrimary(new Component[]{leftSidePane});
        content.addToSecondary(new Component[]{layoutCarto});
        content.setSplitterPosition(0.0);
        content.addClassNames(new String[]{"p-m", "box-border"});
        bottomSidePane.initSearchTab(cartoPane.getMap());
        this.createUpdaterThread();
        this.init();
        this.addDetachListener((ComponentEventListener & Serializable)event -> UI.getCurrent().getSession().setAttribute(this.getClass().getName(), (Object)cartoPane.getCenterZoom()));
    }

    private void createUpdaterThread() {
        Thread thread = new Thread((Runnable)new DelegatingSecurityContextRunnable(() -> {
            log.debug("[{}] Updater thread started", (Object)this.logPrefix);
            try {
                while (true) {
                    AtomicReference<Object> future = new AtomicReference<Object>(null);
                    ((UI)this.getUI().orElseThrow()).accessSynchronously((Command & Serializable)() -> {
                        log.debug("[{}] Refresh (requested: {})", (Object)this.logPrefix, (Object)this.refreshRequested);
                        future.set(this.refresh());
                    });
                    ((CompletableFuture)future.get()).get();
                    log.debug("[{}] Refresh DONE", (Object)this.logPrefix);
                    CommonMct commonMct = this;
                    synchronized (commonMct) {
                        this.refreshRequested = false;
                        do {
                            this.wait(Duration.ofMinutes(1L).toMillis());
                        } while (!this.autoRefresh && !this.refreshRequested);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug("[{}] Updater thread interrupted", (Object)this.logPrefix);
                return;
            }
            catch (UIDetachedException e) {
                log.debug("[{}] UI Detached", (Object)this.logPrefix);
                return;
            }
            catch (ExecutionException e) {
                log.error("[{}] Error while refreshing", (Object)this.logPrefix, (Object)e);
                return;
            }
        }));
        this.addAttachListener((ComponentEventListener & Serializable)event -> {
            try {
                thread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            thread.start();
        });
        this.addDetachListener((ComponentEventListener & Serializable)event -> thread.interrupt());
    }

    protected abstract void init();

    protected abstract CompletableFuture<Void> refresh();

    public abstract LeftSidePane getLeftSidePane();

    protected abstract BottomSidePane getBottomSidePane();

    protected abstract ICartoPane getCartoPane();

    public final synchronized void setAutoRefresh(boolean autoRefresh) {
        this.setAutoRefresh(autoRefresh, autoRefresh);
    }

    public final synchronized void setAutoRefresh(boolean autoRefresh, boolean requestRefresh) {
        this.autoRefresh = autoRefresh;
        if (requestRefresh) {
            this.requestRefresh();
        }
    }

    public final synchronized void requestRefresh() {
        this.refreshRequested = true;
        this.notifyAll();
    }

    @Generated
    protected CommonMct(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

