/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.neogls.prism.central.vaadin.util.DateTimeFormatterUtils;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.Slot;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.MctEventList;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctList;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItemsClearEvent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItemsLoadEvent;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class CommonBottomSideInformationProvider {
    private final BottomSidePane bottomSidePane;
    private final Slot slotLastUpdate;
    private final Slot slotUnread;

    public CommonBottomSideInformationProvider(BottomSidePane bottomSidePane, MctEventList<?> mctEventList) {
        this.bottomSidePane = bottomSidePane;
        this.slotLastUpdate = bottomSidePane.getTab(BottomSidePane.DefaultTab.INFORMATIONS).newSlot();
        this.slotUnread = bottomSidePane.getTab(BottomSidePane.DefaultTab.INFORMATIONS).newSlot();
        mctEventList.addItemsClearListener(arg_0 -> this.onEventsCleared(arg_0));
        mctEventList.addItemsLoadListener(arg_0 -> this.onEventsLoaded(arg_0));
    }

    private void onEventsCleared(MctListItemsClearEvent<Situation> event) {
        event.registerUiAccess(ui -> this.bottomSidePane.getTab(BottomSidePane.DefaultTab.INFORMATIONS).clear());
    }

    protected void onEventsLoaded(MctListItemsLoadEvent<Situation> event) {
        LocalDate today = LocalDate.now();
        AtomicInteger countUnread = new AtomicInteger(0);
        AtomicInteger countUnreadToday = new AtomicInteger(0);
        ((MctList)event.getSource()).getItems().stream().map(Situation::getEvenements).flatMap(Collection::stream).filter(Predicate.not(Evenement::isLu)).forEach(evenement -> {
            countUnread.incrementAndGet();
            if (Instant.ofEpochMilli(evenement.getDateMaj()).atZone(ZoneId.systemDefault()).toLocalDate().equals(today)) {
                countUnreadToday.incrementAndGet();
            }
        });
        if (countUnread.get() > 0) {
            event.registerUiAccess(ui -> {
                String unread = "%d %s %d %s".formatted(countUnread.get(), ui.getTranslation("mct.unreadevents", new Object[0]), countUnreadToday.get(), ui.getTranslation("mct.unreadevents2", new Object[0]));
                this.slotUnread.setMessage(unread);
            });
        }
        LocalDateTime now = LocalDateTime.now(ZoneId.systemDefault());
        event.registerUiAccess(ui -> {
            String lastupdate = "%s %s %s %s".formatted(ui.getTranslation("mct.lastupdate", new Object[0]), DateTimeFormatterUtils.getDateFormatter().format(now), ui.getTranslation("mct.description.a", new Object[0]), DateTimeFormatterUtils.getTimeFormatter().format(now));
            this.slotLastUpdate.setMessage(lastupdate);
        });
    }
}

