/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.cch.saisie;

import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Commentaire;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismcentral.DAO.Jdbc.McigDAOJDBC;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentral.beans.BarreauVHHisto;
import com.geolocsystems.prismcentral.beans.ListeDestinataireMail;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Synthese;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.rest.export.cch.historique.HistoriqueSaisieCCHExportService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SaisieCCHService {
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;
    private final UserPermissionService userPermissionService;
    private final HistoriqueSaisieCCHExportService historiqueExportService;

    public Synthese getSyntheseSerpeVH() {
        return this.businessService.getSyntheseSerpeVH();
    }

    public TreeMap<String, String> getModelesMessagePublicationSynthese() {
        return this.businessService.getModelesMessagePublicationSynthese();
    }

    public PrismCentralUser getUserLogedIn() {
        return this.userPermissionService.getCurrentUser().getPrismUser();
    }

    public MainCourante getMainCourante() {
        return this.userPermissionService.getCurrentUser().getMainCourante();
    }

    public void publierCopieBarreauxVH() {
        this.businessService.publierCopieBarreauxVH();
        this.businessService.datePublicationMaj();
        try {
            this.businessService.ajoutCommentaire(this.getMainCourante(), McigDAOJDBC.genereCommentaire((String)"Publication des barreaux VH"));
        }
        catch (Exception e) {
            Log.error((Object)"", (Throwable)e);
        }
    }

    protected void publierBarreauxVH(List<BarreauVH> barreaux) {
        this.businessService.publierBarreauxVH(barreaux);
        try {
            this.businessService.ajoutCommentaire(this.getMainCourante(), McigDAOJDBC.genereCommentaire((String)"Publication des barreaux VH"));
        }
        catch (Exception e) {
            Log.error((Object)"", (Throwable)e);
        }
    }

    public List<ListeDestinataireMail> getListeDestinataireMails() {
        return this.businessService.getListeDestinataireMails();
    }

    public void remiseAZeroBarreauxVH(String delegationPourSelection, String centrePourSelection) {
        this.businessService.remiseAZeroBarreauxVH(delegationPourSelection, centrePourSelection);
    }

    public void remiseAZeroBarreauxVH(int circuitPourSelection) {
        this.businessService.remiseAZeroBarreauxVH(circuitPourSelection);
    }

    public List<BarreauVH> getBarreauxVH(boolean b) {
        return this.businessService.getBarreauxVH(b);
    }

    public void diffusionVH(String translation, String string, ListeDestinataireMail listeMail) {
        this.businessService.diffusionVH(translation, string, listeMail);
    }

    public void depublierBarreauxVH(List<BarreauVH> barreaux) {
        this.businessService.depublierBarreauxVH(barreaux);
    }

    public void ajoutCommentaire(MainCourante mainCourante, Commentaire commentaire) {
        this.businessService.ajoutCommentaire(mainCourante, commentaire);
    }

    public void updateSyntheseSerpeVH(Synthese mySynthese) {
        this.businessService.updateSyntheseSerpeVH(mySynthese);
    }

    public void pasDeChangementBarreauxVH(int circuitPourSelection) {
        this.businessService.pasDeChangementBarreauxVH(circuitPourSelection);
    }

    public void pasDeChangementBarreauxVH(String delegationPourSelection, String centrePourSelection) {
        this.businessService.pasDeChangementBarreauxVH(delegationPourSelection, centrePourSelection);
    }

    public void pasDeChangementBarreauxVH(String delegationPourSelection, String centrePourSelection, int circuitPourSelection) {
        this.businessService.pasDeChangementBarreauxVH(delegationPourSelection, centrePourSelection, circuitPourSelection);
    }

    public void remiseAZeroBarreauxVH(String delegationPourSelection, String centrePourSelection, int circuitPourSelection) {
        this.businessService.remiseAZeroBarreauxVH(delegationPourSelection, centrePourSelection, circuitPourSelection);
    }

    public void previsionPatrouilleBarreauxVH(int circuitPourSelection) {
        this.businessService.previsionPatrouilleBarreauxVH(circuitPourSelection);
    }

    public void previsionPatrouilleBarreauxVH(String delegationPourSelection, String centrePourSelection) {
        this.businessService.previsionPatrouilleBarreauxVH(delegationPourSelection, centrePourSelection);
    }

    public void previsionPatrouilleBarreauxVH(String delegationPourSelection, String centrePourSelection, int circuitPourSelection) {
        this.businessService.previsionPatrouilleBarreauxVH(delegationPourSelection, centrePourSelection, circuitPourSelection);
    }

    public boolean transmettreBarreauxSerpeVH(boolean selectionBarreauxParDelegation) {
        return this.businessService.transmettreBarreauxSerpeVH(selectionBarreauxParDelegation);
    }

    public boolean transmettreBarreauxSerpeVH(boolean selectionBarreauxParDelegation, List<BarreauVH> barreaux) {
        return this.businessService.transmettreBarreauxSerpeVH(selectionBarreauxParDelegation, barreaux);
    }

    public List<Circuit> getCircuitsVHActifs() {
        return this.businessService.getCircuitsVHActifs();
    }

    public List<Delegation> getDelegationsActives() {
        return this.businessService.getDelegationsActives();
    }

    public List<BarreauVHHisto> getBarreauxVH(String delegation, String centre, int circuit, boolean b) {
        return this.businessService.getBarreauxVHExtend(delegation, centre, Integer.valueOf(circuit), b);
    }

    public void diffusionVH() {
        this.businessService.diffusionVH();
    }

    public void updateBarreauxVH(List<BarreauVH> listeBarreaux) {
        this.businessService.updateBarreauxVH(listeBarreaux);
    }

    public void exportHistorique(String id) {
        this.historiqueExportService.exportHistoriqueSaisieCCH(id, "PDF", null);
    }

    public Optional<String> getString(String variable) {
        return this.configurationService.getString(ConfigurationService.ConfigurationType.DATABASE, variable);
    }

    public Optional<Boolean> getBoolean(String variable) {
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, variable);
    }

    public void pasDeChangementBarreauxVH(Set<BarreauVHHisto> barreaux) {
        Date date = new Date();
        if (barreaux != null && barreaux.size() > 0) {
            for (BarreauVH barreauVH : barreaux) {
                barreauVH.setMajDate(date);
                barreauVH.setMcig(this.getMainCourante().getId());
            }
            this.businessService.updateBarreauxVH(barreaux.stream().collect(Collectors.toUnmodifiableList()));
        }
    }

    public void remiseAZeroBarreauxVH(List<BarreauVHHisto> barreaux) {
        Date date = new Date();
        ConstantesPrismCommun.EnumVHTypeCCH vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.C1;
        try {
            vhTypeCCH = ConstantesPrismCommun.EnumVHTypeCCH.valueOf((String)((String)this.businessService.getConfiguration().get((Object)"vh.raz.valeur")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (barreaux != null && barreaux.size() > 0) {
            for (BarreauVH barreauVH : barreaux) {
                barreauVH.setMajDate(date);
                barreauVH.setCch(vhTypeCCH.getValue());
                barreauVH.setCch2(vhTypeCCH.getValue());
                barreauVH.setTendanceCC(ConstantesPrismCommun.EnumVHTendanceCC.EGAL.getValue());
                barreauVH.setEquipements(ConstantesPrismCommun.EnumVHTypeEquipement.NR.getValue());
                barreauVH.setEtatChaussee(ConstantesPrismCommun.EnumVHEtatChaussees.NR.getValue());
                barreauVH.setMeteo(ConstantesPrismCommun.EnumVHMeteo.NR.getValue());
                barreauVH.setTraitement(ConstantesPrismCommun.EnumVHTraitement.NR.getValue());
                barreauVH.setTemperature("NR");
                barreauVH.setVent(ConstantesPrismCommun.EnumVHVent.NR.getValue());
                barreauVH.setCommentaire("");
                barreauVH.setCommentaireInterne("");
                barreauVH.setMcig(this.getMainCourante().getId());
            }
            this.businessService.updateBarreauxVH(barreaux.stream().collect(Collectors.toUnmodifiableList()));
        }
    }

    @Generated
    public SaisieCCHService(IBusinessService businessService, ConfigurationService configurationService, UserPermissionService userPermissionService, HistoriqueSaisieCCHExportService historiqueExportService) {
        this.businessService = businessService;
        this.configurationService = configurationService;
        this.userPermissionService = userPermissionService;
        this.historiqueExportService = historiqueExportService;
    }
}

