/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.cch.saisie;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentralvaadin.util.ConfigUtils;
import com.neogls.prism.central.vaadin.view.mct.cch.saisie.SaisieCCH;
import com.neogls.prism.central.vaadin.view.mct.cch.saisie.SaisieCCHService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import gls.outils.GLS;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;

public class SaisieCCHModification
extends VerticalLayout {
    private boolean DUREE_VALIDITE_VARIABLE = false;
    private long TIME_LIMIT_HOUR = 6L;
    private long TIME_LIMIT = this.TIME_LIMIT_HOUR * 60L * 60L * 1000L;
    private static int TAILLE_PAGE_LENGTH_MAX = 10;
    private static int TAILLE_PAGE_LENGTH_MIN = 5;
    private SaisieCCHService saisieVhService;
    private HorizontalLayout headerInfoComponent;
    private List<BarreauVH> listeBarreaux;
    private List<BarreauVH> listeOldBarreaux;
    private HashMap<String, BarreauVH> mapBarreaux;
    private HashMap<String, BarreauVH> mapOldBarreaux;
    private Grid<BarreauVH> table;
    private Button retour;
    private Button enregistrer;
    private Vector<String> changements;
    final Pattern pattern = Pattern.compile("(\\+|-)?\\d\\d?([\\.]\\d)?|NR");
    private boolean selectAll = false;
    private List<String> tableColumns;
    private List<String> tableAllColumns;
    private boolean dureeValiditeVariable;
    private List<String> meteoChoix;
    private List<String> ventChoix;
    private List<String> etatChausseeChoix;
    private List<String> equipementsChoix;
    private List<String> traitementChoix;

    public SaisieCCHModification(SaisieCCHService saisieVhService, List<BarreauVH> liste) {
        this.saisieVhService = saisieVhService;
        String listeColonnes = saisieVhService.getString("VH_BARREAUXVH_LISTE_COLONNES").orElse("");
        this.dureeValiditeVariable = saisieVhService.getBoolean("CONFIG_VALIDITE_TRONCON_VH_VARIABLE").orElse(false);
        this.tableColumns = new ArrayList();
        this.tableAllColumns = new ArrayList();
        this.tableAllColumns.add("combo");
        this.tableAllColumns.add("centre");
        this.tableAllColumns.add("departement");
        this.tableAllColumns.add("idGroupe");
        this.tableAllColumns.add("tronconId");
        this.tableAllColumns.add("libelle");
        this.tableAllColumns.add("cch");
        this.tableAllColumns.add("cch2");
        this.tableAllColumns.add("meteo");
        this.tableAllColumns.add("temperature");
        this.tableAllColumns.add("vent");
        this.tableAllColumns.add("etatChaussee");
        this.tableAllColumns.add("equipements");
        this.tableAllColumns.add("traitement");
        this.tableAllColumns.add("commentaireInterne");
        this.tableAllColumns.add("commentaire");
        this.tableAllColumns.add("dureeValidite");
        if (listeColonnes != null && !listeColonnes.equals("")) {
            if (!listeColonnes.contains("combo")) {
                this.tableColumns.add("combo");
            }
            if (!listeColonnes.contains("centre")) {
                this.tableColumns.add("centre");
            }
            if (!listeColonnes.contains("departement")) {
                this.tableColumns.add("departement");
            }
            for (String colonne : listeColonnes.split(";")) {
                if (colonne.equals("publie") || colonne.equals("circuit") || colonne.equals("tendanceCC") || colonne.equals("majDate")) continue;
                this.tableColumns.add(colonne);
            }
            if (this.dureeValiditeVariable && !listeColonnes.contains("dureeValidite")) {
                this.tableColumns.add("dureeValidite");
            }
        } else {
            this.tableColumns = this.tableAllColumns;
        }
        this.meteoChoix = ConfigUtils.getListe((int)1, (String)"vh.liste.meteo", (List)ConstantesPrismCommun.EnumVHMeteo.VALUES);
        this.ventChoix = ConfigUtils.getListe((int)1, (String)"vh.liste.vent", (List)ConstantesPrismCommun.EnumVHVent.VALUES);
        this.etatChausseeChoix = ConfigUtils.getListe((int)1, (String)"vh.liste.etatChaussees", (List)ConstantesPrismCommun.EnumVHEtatChaussees.VALUES);
        this.equipementsChoix = ConfigUtils.getListe((int)1, (String)"vh.liste.equipements", (List)ConstantesPrismCommun.EnumVHTypeEquipement.VALUES);
        this.traitementChoix = ConfigUtils.getListe((int)1, (String)"vh.liste.traitement", (List)ConstantesPrismCommun.EnumVHTraitement.VALUES);
        this.listeBarreaux = liste;
        this.listeOldBarreaux = (List)DeepCopy.copy((Object)this.listeBarreaux);
        this.mapBarreaux = new HashMap();
        this.mapOldBarreaux = new HashMap();
        for (BarreauVH b : this.listeBarreaux) {
            this.mapBarreaux.put(b.getId(), b);
        }
        for (BarreauVH b : this.listeOldBarreaux) {
            this.mapOldBarreaux.put(b.getId(), b);
        }
        this.changements = new Vector();
        this.setSizeUndefined();
        this.setWidth(100.0f, Unit.PERCENTAGE);
        this.setHeight(100.0f, Unit.PERCENTAGE);
        this.setSpacing(true);
        this.headerInfoComponent = new HorizontalLayout();
        this.createIHM();
        this.initValeurs();
    }

    private void initValeurs() {
        this.table.setItems((Collection)this.listeBarreaux);
    }

    protected void changementLignesSelectionnees(HasValue.ValueChangeEvent event, String propertyID) {
    }

    private void createIHM() {
        this.table = new Grid();
        this.table.setItems((Collection)this.listeBarreaux);
        this.table.setWidth(100.0f, Unit.PERCENTAGE);
        this.table.setHeight(100.0f, Unit.PERCENTAGE);
        this.table.setSelectionMode(Grid.SelectionMode.MULTI);
        this.table.addSelectionListener((SelectionListener & Serializable)selection -> {
            Set col = selection.getAllSelectedItems();
        });
        this.table.addComponentColumn((ValueProvider & Serializable)i -> i.isPublie() ? new Image("ico/publish.png", "alt text") : null).setHeader(this.getTranslation("vh.champ.publie", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("publie"));
        this.table.addColumn(Troncon::getCircuit).setHeader(this.getTranslation("vh.champ.circuit", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("circuit"));
        this.table.addColumn(BarreauVH::getIdGroupe).setHeader(this.getTranslation("vh.champ.idgroupe", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("idGroupe"));
        this.table.addColumn(Troncon::getTronconId).setHeader(this.getTranslation("vh.champ.id", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("tronconId"));
        this.table.addColumn(Troncon::getDescription).setHeader(this.getTranslation("vh.champ.description", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("libelle"));
        ArrayList<String> cchActivees = new ArrayList<String>();
        for (ConstantesPrismCommun.EnumVHTypeCCH cch : ConstantesPrismCommun.EnumVHTypeCCH.values()) {
            if (!MetierCommun.estDedans((List)ConfigUtils.getCCHActivee(), (Object)cch.getValue())) continue;
            cchActivees.add(cch.getValue());
        }
        this.table.addComponentColumn((ValueProvider & Serializable)b -> {
            ComboBox cchBox = new ComboBox();
            cchBox.setItems((Collection)cchActivees);
            cchBox.setValue((Object)b.getCch());
            cchBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                b.setCch(e.getValue().toString());
                for (BarreauVH vh : this.table.getSelectedItems()) {
                    vh.setCch(e.getValue().toString());
                }
            });
            return cchBox;
        }).setHeader(this.getTranslation("vh.champ.cch", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("cch"));
        this.table.addComponentColumn((ValueProvider & Serializable)b -> {
            ComboBox cchBox = new ComboBox();
            cchBox.setItems((Collection)cchActivees);
            cchBox.setValue((Object)b.getCch2());
            cchBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                b.setCch2(e.getValue().toString());
                for (BarreauVH vh : this.table.getSelectedItems()) {
                    vh.setCch2(e.getValue().toString());
                }
            });
            return cchBox;
        }).setHeader(this.getTranslation("vh.champ.cch2", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("cch2"));
        this.table.addColumn(BarreauVH::getTendanceCC).setHeader(this.getTranslation("vh.champ.tendance", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("tendanceCC"));
        this.table.addComponentColumn((ValueProvider & Serializable)b -> {
            ComboBox meteoBox = new ComboBox();
            meteoBox.setItems((Collection)this.meteoChoix);
            meteoBox.setValue((Object)b.getMeteo());
            meteoBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                b.setMeteo(e.getValue().toString());
                for (BarreauVH vh : this.table.getSelectedItems()) {
                    vh.setMeteo(e.getValue().toString());
                }
            });
            return meteoBox;
        }).setHeader(this.getTranslation("vh.champ.meteo", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("meteo"));
        this.table.addComponentColumn((ValueProvider & Serializable)b -> {
            NumberField cchBox = new NumberField();
            cchBox.setStep(0.1);
            cchBox.setStepButtonsVisible(true);
            if (!b.getTemperature().equals("NR")) {
                cchBox.setValue((Number)Double.valueOf(b.getTemperature()));
            }
            cchBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                b.setTemperature(((Double)e.getValue()).toString());
                for (BarreauVH vh : this.table.getSelectedItems()) {
                    vh.setTemperature(((Double)e.getValue()).toString());
                }
            });
            return cchBox;
        }).setHeader(this.getTranslation("vh.champ.temperature", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("temperature"));
        this.table.addComponentColumn((ValueProvider & Serializable)b -> {
            ComboBox ventBox = new ComboBox();
            ventBox.setItems((Collection)this.ventChoix);
            ventBox.setValue((Object)b.getVent());
            ventBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                b.setVent(e.getValue().toString());
                for (BarreauVH vh : this.table.getSelectedItems()) {
                    vh.setVent(e.getValue().toString());
                }
            });
            return ventBox;
        }).setHeader(this.getTranslation("vh.champ.vent", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("vent"));
        this.table.addComponentColumn((ValueProvider & Serializable)b -> {
            ComboBox etatChausseBox = new ComboBox();
            etatChausseBox.setItems((Collection)this.etatChausseeChoix);
            etatChausseBox.setValue((Object)b.getEtatChaussee());
            etatChausseBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                b.setEtatChaussee(e.getValue().toString());
                for (BarreauVH vh : this.table.getSelectedItems()) {
                    vh.setEtatChaussee(e.getValue().toString());
                }
            });
            return etatChausseBox;
        }).setHeader(this.getTranslation("vh.champ.etat_chaussee", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("etatChaussee"));
        this.table.addComponentColumn((ValueProvider & Serializable)b -> {
            ComboBox equipementBox = new ComboBox();
            equipementBox.setItems((Collection)this.equipementsChoix);
            equipementBox.setValue((Object)b.getEquipements());
            equipementBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                b.setEquipements(e.getValue().toString());
                for (BarreauVH vh : this.table.getSelectedItems()) {
                    vh.setEquipements(e.getValue().toString());
                }
            });
            return equipementBox;
        }).setHeader(this.getTranslation("vh.champ.equipements", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("equipements"));
        this.table.addComponentColumn((ValueProvider & Serializable)b -> {
            ComboBox traitementBox = new ComboBox();
            traitementBox.setItems((Collection)this.traitementChoix);
            traitementBox.setValue((Object)b.getTraitement());
            traitementBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                b.setTraitement(e.getValue().toString());
                for (BarreauVH vh : this.table.getSelectedItems()) {
                    vh.setTraitement(e.getValue().toString());
                }
            });
            return traitementBox;
        }).setHeader(this.getTranslation("vh.champ.traitement", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("traitement"));
        this.table.addComponentColumn((ValueProvider & Serializable)b -> {
            TextField commentaireInterneTextField = new TextField();
            commentaireInterneTextField.setWidth(200.0f, Unit.PIXELS);
            commentaireInterneTextField.setValue(b.getCommentaireInterne());
            commentaireInterneTextField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                b.setCommentaireInterne(((String)e.getValue()).toString());
                for (BarreauVH vh : this.table.getSelectedItems()) {
                    vh.setCommentaireInterne(((String)e.getValue()).toString());
                }
            });
            return commentaireInterneTextField;
        }).setHeader(this.getTranslation("vh.champ.comentaire_interne", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("commentaireInterne"));
        this.table.addComponentColumn((ValueProvider & Serializable)b -> {
            TextField commentaireTextfield = new TextField();
            commentaireTextfield.setWidth(200.0f, Unit.PIXELS);
            commentaireTextfield.setValue(b.getCommentaire());
            commentaireTextfield.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                b.setCommentaire(((String)e.getValue()).toString());
                for (BarreauVH vh : this.table.getSelectedItems()) {
                    vh.setCommentaire(((String)e.getValue()).toString());
                }
            });
            return commentaireTextfield;
        }).setHeader(this.getTranslation("vh.champ.commentaire", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("commentaire"));
        this.table.addColumn(BarreauVH::getDuree).setHeader(this.getTranslation("vh.champ.duree_validite", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("dureeValidite"));
        this.table.addColumn((ValueProvider & Serializable)d -> {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            return d.getMajDate() != null ? sdf.format(d.getMajDate()) : "";
        }).setClassNameGenerator((SerializableFunction & Serializable)d -> d.estDateValide(this.DUREE_VALIDITE_VARIABLE, this.TIME_LIMIT) ? "OK" : "OUTDATED").setHeader(this.getTranslation("vh.champ.date", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("majDate"));
        this.table.setAllRowsVisible(true);
        HorizontalLayout hlButtons = new HorizontalLayout();
        hlButtons.setSpacing(true);
        hlButtons.setSizeUndefined();
        hlButtons.setMargin(true);
        this.retour = new Button(this.getTranslation("vh.saisieCCH.button.retour", new Object[0]));
        this.retour.setWidth((float)SaisieCCH.TAILLE_BOUTTON, Unit.PIXELS);
        this.enregistrer = new Button(this.getTranslation("vh.saisieCCH.button.enregistrer", new Object[0]));
        this.enregistrer.setWidth((float)SaisieCCH.TAILLE_BOUTTON, Unit.PIXELS);
        hlButtons.add(new Component[]{this.retour});
        hlButtons.add(new Component[]{this.enregistrer});
        this.add(new Component[]{this.table});
        this.add(new Component[]{hlButtons});
        this.setAlignItems(FlexComponent.Alignment.CENTER);
    }

    protected void enregistrerModifications() {
        Set col = this.table.getSelectedItems();
        Iterator it = col.iterator();
        this.changements = new Vector();
        while (it.hasNext()) {
            String idBarreaux = ((BarreauVH)it.next()).getId();
            BarreauVH b = (BarreauVH)this.mapBarreaux.get(idBarreaux);
            b.setMajDate(new Date());
            if (!this.pattern.matcher(b.getTemperature()).matches()) {
                b.setTemperature("NR");
            }
            b.setMcig(this.saisieVhService.getMainCourante().getId());
            b.setMajIdPartenaire(-1);
            String comment = this.genererMainCourante((BarreauVH)this.mapOldBarreaux.get(idBarreaux), b);
            b.calculerTendance();
            if (comment == null) continue;
            this.changements.add(comment);
        }
    }

    public Button getRetour() {
        return this.retour;
    }

    public Button getEnregistrer() {
        return this.enregistrer;
    }

    public List<BarreauVH> getListeBarreaux() {
        return this.listeBarreaux;
    }

    public List<BarreauVH> getListeOldBarreaux() {
        return this.listeOldBarreaux;
    }

    public HashMap<String, BarreauVH> getMapBarreaux() {
        return this.mapBarreaux;
    }

    public HashMap<String, BarreauVH> getMapOldBarreaux() {
        return this.mapOldBarreaux;
    }

    public void reinit() {
    }

    public int getActionId() {
        return 302;
    }

    public void onPause() {
        Log.debug((Object)"SuiviVH : onPause()");
    }

    public void onResume() {
        Log.debug((Object)"SuiviVH : onResume()");
    }

    public Component getInfoComponent() {
        return this.headerInfoComponent;
    }

    public String getPath() {
        return this.getTranslation("vh.title", new Object[0]) + " > " + this.getTranslation("vh.saisieCCH.title", new Object[0]);
    }

    private String getChangements(BarreauVH barreau, Vector<String> changements) {
        return barreau.getTronconID().concat("- (").concat(GLS.getString(changements, (String)",")).concat(")");
    }

    private String genererMainCourante(BarreauVH barreauInit, BarreauVH barreauNew) {
        Vector changements = this.getListeChangements(barreauInit, barreauNew);
        if (changements.size() > 0) {
            return this.getChangements(barreauInit, changements);
        }
        return null;
    }

    public Vector<String> getListeChangements(BarreauVH barreauInit, BarreauVH barreauNew) {
        Vector<String> changements = new Vector<String>();
        if (!GLS.egal((String)barreauInit.getCch(), (String)barreauNew.getCch())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.cch", new Object[0]), barreauNew.getCch()));
        }
        if (!GLS.egal((String)barreauInit.getCch2(), (String)barreauNew.getCch2())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.cch2", new Object[0]), barreauNew.getCch2()));
        }
        if (!GLS.egal((String)barreauInit.getTendanceCC(), (String)barreauNew.getTendanceCC())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.tendance", new Object[0]), barreauNew.getTendanceCC()));
        }
        if (!GLS.egal((String)barreauInit.getTraitement(), (String)barreauNew.getTraitement())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.traitement", new Object[0]), barreauNew.getTraitement()));
        }
        if (!GLS.egal((String)barreauInit.getMeteo(), (String)barreauNew.getMeteo())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.meteo", new Object[0]), barreauNew.getMeteo()));
        }
        if (!GLS.egal((String)barreauInit.getCommentaire(), (String)barreauNew.getCommentaire())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.commentaire", new Object[0]), barreauNew.getCommentaire()));
        }
        if (!GLS.egal((String)barreauInit.getCommentaireInterne(), (String)barreauNew.getCommentaireInterne())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.comentaire_interne", new Object[0]), barreauNew.getCommentaireInterne()));
        }
        if (!GLS.egal((String)barreauInit.getEquipements(), (String)barreauNew.getEquipements())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.equipements", new Object[0]), barreauNew.getEquipements()));
        }
        if (!GLS.egal((String)barreauInit.getTemperature(), (String)barreauNew.getTemperature())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.temperature", new Object[0]), barreauNew.getTemperature()));
        }
        if (!GLS.egal((String)barreauInit.getEtatChaussee(), (String)barreauNew.getEtatChaussee())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.etat_chaussee", new Object[0]), barreauNew.getEtatChaussee()));
        }
        if (!GLS.egal((String)barreauInit.getVent(), (String)barreauNew.getVent())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.vent", new Object[0]), barreauNew.getVent()));
        }
        if (!GLS.egal((Object)barreauInit.getDuree(), (Object)barreauNew.getDuree())) {
            changements.add(this.genereChangementChamp(this.getTranslation("vh.champ.duree_validite", new Object[0]), "" + barreauNew.getDuree()));
        }
        return changements;
    }

    private String genereChangementChamp(String nomChamp, String valeur) {
        return nomChamp.concat(" --> ").concat(valeur);
    }

    public Vector<String> getChangements() {
        return this.changements;
    }

    public String getMainMenu() {
        return "vh.title";
    }

    public Component getNotificationsComponent() {
        return null;
    }
}

