/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.cch.saisie;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Commentaire;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentral.beans.BarreauVHHisto;
import com.geolocsystems.prismcentral.beans.ListeDestinataireMail;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Synthese;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.data.BusinessServiceFactory;
import com.geolocsystems.prismcentralvaadin.util.ConfigUtils;
import com.geolocsystems.prismcentralvaadin.util.ProfilUtils;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.rest.export.cch.historique.HistoriqueSaisieCCHExportController;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.mct.cch.saisie.SaisieCCH;
import com.neogls.prism.central.vaadin.view.mct.cch.saisie.SaisieCCHModification;
import com.neogls.prism.central.vaadin.view.mct.cch.saisie.SaisieCCHService;
import com.neogls.prism.central.vaadin.view.mct.cch.saisie.SuiviVhUpdateListener;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PrismLayerFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.TronconVhLayer;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.accordion.Accordion;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.AnchorTarget;
import com.vaadin.flow.component.html.AnchorTargetValue;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import com.wontlost.ckeditor.Config;
import com.wontlost.ckeditor.Constants;
import com.wontlost.ckeditor.VaadinCKEditor;
import com.wontlost.ckeditor.VaadinCKEditorBuilder;
import gls.outils.GLS;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.controls.LeafletControl;
import org.vaadin.addons.componentfactory.leaflet.controls.ScaleControl;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;

@CssImport(themeFor="vaadin-grid", value="themes/prism-theme/grid-vh.css")
@RolesAllowed(value={"ACTION_VH_CONSULTATION"})
@Route(value="vh/cch", layout=PrismLayout.class)
public class SaisieCCH
extends VerticalLayout
implements HasDynamicTitle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaisieCCH.class);
    public static int TAILLE_BOUTTON = 250;
    public static int TAILLE_SYNTHESE = 150;
    private static int TAILLE_PAGE_LENGTH_MAX = 15;
    private static int TAILLE_PAGE_LENGTH_MIN = 5;
    private long TIME_LIMIT_HOUR = 6L;
    private long TIME_LIMIT = this.TIME_LIMIT_HOUR * 60L * 60L * 1000L;
    private Image iconPatrouilleur;
    private Image iconBureau;
    private HorizontalLayout headerInfoComponent;
    private HorizontalLayout hlCombo;
    private HorizontalLayout hlButtons;
    private HorizontalLayout hlSynthese;
    private VerticalLayout vlSynthese;
    private ComboBox delegationsBox;
    private ComboBox centresBox;
    private ComboBox circuitsBox;
    private ComboBox modeleBox;
    private Grid<BarreauVHHisto> table;
    private Button pasDeChangement;
    private Button remiseZero;
    private Button transmettreSerpe;
    private Button modifier;
    private Button publier;
    private Button depublier;
    private Button actualiser;
    private Button previsionPatrouille;
    private Button validerSynthese;
    private Button annulerSynthese;
    private Button modifierSynthese;
    private TextArea syntheseSimple;
    private VaadinCKEditor syntheseRich;
    private PrismCentralUser user;
    private String oldSynthese;
    private Synthese mySynthese;
    private boolean selectionBarreauxParDelegation = false;
    private boolean publicationParCopie = false;
    private boolean modeleSynthese = false;
    private boolean bSyntheseRich = false;
    private boolean afficherSynthese = true;
    private boolean filtrerParCircuit = false;
    private Button diffuserMail;
    private boolean selectAll = false;
    private Image publishIcon;
    private TreeMap<String, String> modeles;
    private List<Circuit> circuits;
    static final int FILTRE_DEFAUT = -1;
    static final int FILTRE_CIRCUIT = 1;
    static final int FILTRE_DELEGATION_CENTRE = 2;
    static final int FILTRE_TOUS = 3;
    private int filtreEvolue = -1;
    private List<String> tableColumns;
    private List<String> tableAllColumns;
    protected Collection<TronconSuivi> tronconsSuivi = null;
    protected Set<SuiviVhUpdateListener> updateListeners;
    private HashMap<String, String> mapNomsCircuits;
    private Delegation delegationNull;
    private Centre centreNull;
    private Circuit circuitNull;
    private final SaisieCCHService saisieVhService;
    private boolean DUREE_VALIDITE_VARIABLE = false;
    protected ICartoPane cartoPane = null;
    private final LatLngBounds maxBounds;
    private TronconVhLayer tronconVhLayer;
    private ConfigurationService configurationService;
    private boolean barreauVHSelection = false;
    private final AtomicReference<List<BarreauVHHisto>> filterValue = new AtomicReference(List.of());

    private boolean filter(BarreauVHHisto usageReception) {
        return ((List)this.filterValue.get()).stream().allMatch(str -> usageReception.getMajDate().after(str.getMajDate()));
    }

    public SaisieCCH(ConfigurationService configurationService, SaisieCCHService saisieVhService, PrismLayerFactory prismLayerFactory, ClusterCartoPaneFactory clusterCartoPaneFactory) {
        this.saisieVhService = saisieVhService;
        this.configurationService = configurationService;
        this.iconPatrouilleur = new Image("images/ico/patrouilleur.png", "PATROUILLEUR");
        this.iconBureau = new Image("images/ico/bureau.png", "BUREAU");
        this.setSizeFull();
        this.setSpacing(true);
        this.setMargin(true);
        this.user = saisieVhService.getUserLogedIn();
        try {
            this.selectionBarreauxParDelegation = ConfigurationFactory.getInstance().getBoolean("vh.barreauxvh.delegation", true);
        }
        catch (Exception e) {
            this.selectionBarreauxParDelegation = true;
        }
        this.delegationNull = new Delegation();
        this.delegationNull.setNom("");
        this.centreNull = new Centre();
        this.centreNull.setNom("");
        this.circuitNull = new Circuit();
        this.circuitNull.setId("");
        this.publicationParCopie = configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "VH_PUBLICATION_PAR_COPIE").orElse(false);
        this.modeleSynthese = configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "VH_MODELE_SYNTHESE").orElse(false);
        this.bSyntheseRich = configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "VH_SYNTHESE_RICH").orElse(false);
        this.afficherSynthese = configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "VH_BARREAUXVH_AFFICHER_SYNTHESE").orElse(true);
        this.filtrerParCircuit = configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "VH_BARREAUXVH_FILTRER_PAR_CIRCUIT").orElse(false);
        this.filtreEvolue = configurationService.getInt(ConfigurationService.ConfigurationType.DATABASE, "VH_BARREAUXVH_FILTRE_EVOLUE").orElse(-1);
        this.TIME_LIMIT_HOUR = configurationService.getLong(ConfigurationService.ConfigurationType.DATABASE, "validiteTronconVH").orElse(6L);
        this.TIME_LIMIT = this.TIME_LIMIT_HOUR * 3600L * 1000L;
        this.DUREE_VALIDITE_VARIABLE = configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "CONFIG_VALIDITE_TRONCON_VH_VARIABLE").orElse(false);
        String listeColonnes = configurationService.getString(ConfigurationService.ConfigurationType.DATABASE, "VH_BARREAUXVH_LISTE_COLONNES").orElse("");
        this.tableColumns = new ArrayList();
        this.tableAllColumns = new ArrayList();
        this.tableAllColumns.add("combo");
        this.tableAllColumns.add("publie");
        this.tableAllColumns.add("circuit");
        this.tableAllColumns.add("idGroupe");
        this.tableAllColumns.add("tronconId");
        this.tableAllColumns.add("libelle");
        this.tableAllColumns.add("cch");
        this.tableAllColumns.add("cch2");
        this.tableAllColumns.add("tendanceCC");
        this.tableAllColumns.add("meteo");
        this.tableAllColumns.add("temperature");
        this.tableAllColumns.add("vent");
        this.tableAllColumns.add("etatChaussee");
        this.tableAllColumns.add("equipements");
        this.tableAllColumns.add("traitement");
        this.tableAllColumns.add("commentaireInterne");
        this.tableAllColumns.add("commentaire");
        this.tableAllColumns.add("dureeValidite");
        this.tableAllColumns.add("majDate");
        this.tableAllColumns.add("auteur");
        this.tableAllColumns.add("source");
        this.tableAllColumns.add("historique");
        if (listeColonnes != null && !listeColonnes.equals("")) {
            if (!listeColonnes.contains("combo")) {
                this.tableColumns.add("combo");
            }
            if (!this.publicationParCopie && !listeColonnes.contains("publie")) {
                this.tableColumns.add("publie");
            }
            if (this.filtreEvolue == 3 && !listeColonnes.contains("circuit")) {
                this.tableColumns.add("circuit");
            }
            for (String colonne : listeColonnes.split(";")) {
                this.tableColumns.add(colonne);
            }
            if (this.DUREE_VALIDITE_VARIABLE && !listeColonnes.contains("dureeValidite")) {
                this.tableColumns.add("dureeValidite");
            }
            if (!listeColonnes.contains("majDate")) {
                this.tableColumns.add("majDate");
            }
        } else {
            this.tableColumns = this.tableAllColumns;
        }
        this.headerInfoComponent = new HorizontalLayout();
        Span titre = new Span(this.getTranslation("vh.saisieCCH.title", new Object[0]));
        titre.addClassNames(new String[]{"text-header", "p-s", "bg-base", "shadow-xs", "rounded-l"});
        this.add(new Component[]{titre});
        this.publishIcon = new Image("ico/publish.png", "PUBLISH");
        this.updateListeners = new HashSet();
        if (configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "VH_BARREAUXVH_AFFICHER_CARTE").orElse(false).booleanValue()) {
            this.cartoPane = clusterCartoPaneFactory.newClusterCartoPane(Integer.valueOf(saisieVhService.getMainCourante().getCodeModuleMetier()));
            this.tronconVhLayer = prismLayerFactory.createTronconVhLayer(saisieVhService.getMainCourante().getCodeModuleMetier());
            if (this.tronconVhLayer != null) {
                this.tronconVhLayer.addTo(this.cartoPane, "Barreaux VH");
            }
            this.cartoPane.addCartoLayer();
            prismLayerFactory.tryCreateCartoLayerSupp(saisieVhService.getMainCourante().getCodeModuleMetier()).ifPresent(cartoLayers -> cartoLayers.forEach((layerName, layer) -> layer.addTo(this.cartoPane, layerName)));
            this.barreauVHSelection = configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "vh.barreauxvh.selection").orElse(false);
        }
        this.maxBounds = LeafletUtils.getMaxBounds((ConfigurationService)configurationService);
        this.createIHM();
        this.initSynthese();
    }

    private void initSynthese() {
        try {
            this.mySynthese = this.saisieVhService.getSyntheseSerpeVH();
            this.syntheseSimple.setValue(this.mySynthese.getCommentaire());
            this.syntheseRich.setValue(this.mySynthese.getCommentaire());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshHeader() {
        this.headerInfoComponent.removeAll();
        DateFormat dateFormat = DateFormat.getDateInstance(3, UI.getCurrent().getLocale());
        DateFormat timeFormat = DateFormat.getTimeInstance(3, UI.getCurrent().getLocale());
        Date d = new Date();
        TextField lastupdate = new TextField(this.getTranslation("mct.lastupdate", new Object[0]) + " " + dateFormat.format(d) + " " + this.getTranslation("mct.description.a", new Object[0]) + " " + timeFormat.format(d));
        this.headerInfoComponent.add(new Component[]{lastupdate});
    }

    private void createIHM() {
        if (this.afficherSynthese) {
            this.createSynthese();
            this.add(new Component[]{this.vlSynthese});
            this.setAlignItems(FlexComponent.Alignment.CENTER);
        }
        this.createButtons();
        this.table = new Grid();
        this.table.setWidthFull();
        this.table.setMinHeight(80.0f, Unit.PERCENTAGE);
        this.createTableau();
        this.createComboBox();
        this.add(new Component[]{this.hlCombo});
        this.add(new Component[]{this.table});
        this.setAlignItems(FlexComponent.Alignment.CENTER);
        if (this.user.canDo(304) || this.user.canDo(301)) {
            this.diffuserMail.setVisible(true);
            if (this.user.canDo(301)) {
                this.transmettreSerpe.setVisible(true);
            } else {
                this.transmettreSerpe.setVisible(false);
            }
        } else {
            this.transmettreSerpe.setVisible(false);
            this.diffuserMail.setVisible(false);
        }
        if (this.user.canDo(300) || this.user.canDo(301)) {
            this.add(new Component[]{this.hlButtons});
        }
        if (this.cartoPane != null) {
            ICartoPane iCartoPane = this.cartoPane;
            if (!(iCartoPane instanceof Component)) {
                throw new IllegalStateException("CartoPane should extends Component but %s does not".formatted(this.cartoPane.getClass().getSimpleName()));
            }
            Component cartoPaneComponent = (Component)iCartoPane;
            ScaleControl scaleControl = new ScaleControl();
            scaleControl.setMaxWidth(100);
            scaleControl.setPosition(LeafletControl.ControlPosition.bottomleft);
            scaleControl.addTo(this.cartoPane.getMap());
            1 control = new /* Unavailable Anonymous Inner Class!! */;
            control.addTo(this.cartoPane.getMap());
            this.cartoPane.setMinHeight(1000.0f, Unit.PIXELS);
            this.cartoPane.setSizeFull();
            Accordion accordion = new Accordion();
            Image imageLegende = new Image("images/map/legend/cch/legende.png", "L\u00e9gende");
            accordion.add("L\u00e9gende", (Component)imageLegende);
            accordion.close();
            VerticalLayout h = new VerticalLayout();
            h.add(new Component[]{cartoPaneComponent, accordion});
            this.add(new Component[]{h});
            this.setAlignItems(FlexComponent.Alignment.CENTER);
        } else if (this.user.canDo(300) || this.user.canDo(301)) {
            // empty if block
        }
    }

    private void createSynthese() {
        this.vlSynthese = new VerticalLayout();
        this.vlSynthese.setWidth(100.0f, Unit.PERCENTAGE);
        this.vlSynthese.setSpacing(true);
        this.modeles = this.saisieVhService.getModelesMessagePublicationSynthese();
        this.modeleBox = new ComboBox(this.getTranslation("vh.saisieCCH.modele.synthese", new Object[0]));
        this.modeleBox.setVisible(false);
        this.vlSynthese.add(new Component[]{this.modeleBox});
        this.modeleBox.setItems(this.modeles.keySet());
        this.modeleBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.modeles.get(this.modeleBox.getValue()) != null) {
                if (this.bSyntheseRich) {
                    this.syntheseRich.setValue((String)this.modeles.get(this.modeleBox.getValue()));
                } else {
                    this.syntheseSimple.setValue((String)this.modeles.get(this.modeleBox.getValue()));
                }
            }
        });
        this.hlSynthese = new HorizontalLayout();
        this.hlSynthese.setWidth(100.0f, Unit.PERCENTAGE);
        this.hlSynthese.setSpacing(true);
        this.syntheseSimple = new TextArea();
        this.syntheseSimple.setWidth(100.0f, Unit.PERCENTAGE);
        this.syntheseSimple.setEnabled(false);
        this.syntheseSimple.setMaxLength(2000);
        Config config = new Config();
        Constants.Toolbar[] toolbar = new Constants.Toolbar[]{Constants.Toolbar.bold, Constants.Toolbar.italic, Constants.Toolbar.underline, Constants.Toolbar.fontFamily, Constants.Toolbar.fontSize, Constants.Toolbar.fontColor, Constants.Toolbar.fontBackgroundColor, Constants.Toolbar.highlight};
        config.setEditorToolBar(toolbar);
        this.syntheseRich = new VaadinCKEditorBuilder().with(builder -> {
            builder.config = config;
            builder.editorType = Constants.EditorType.CLASSIC;
            builder.theme = Constants.ThemeType.LIGHT;
            builder.readOnly = true;
        }).createVaadinCKEditor();
        this.syntheseRich.setWidth(100.0f, Unit.PERCENTAGE);
        this.syntheseRich.setHeight(250.0f, Unit.PIXELS);
        this.syntheseRich.setVisible(true);
        this.syntheseRich.setHideToolbar(true);
        this.modifierSynthese = new Button(this.getTranslation("vh.saisieCCH.button.modifsynthese", new Object[0]));
        this.modifierSynthese.setVisible(true);
        this.modifierSynthese.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.validerSynthese = new Button(this.getTranslation("vh.saisieCCH.button.validersynthese", new Object[0]));
        this.validerSynthese.setVisible(false);
        this.validerSynthese.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.annulerSynthese = new Button(this.getTranslation("vh.saisieCCH.button.annulersynthese", new Object[0]));
        this.annulerSynthese.setVisible(false);
        this.annulerSynthese.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        VerticalLayout vlButtons = new VerticalLayout();
        vlButtons.setSpacing(true);
        vlButtons.setSizeUndefined();
        vlButtons.add(new Component[]{this.modifierSynthese});
        vlButtons.add(new Component[]{this.validerSynthese});
        vlButtons.add(new Component[]{this.annulerSynthese});
        if (this.bSyntheseRich) {
            this.hlSynthese.add(new Component[]{this.syntheseRich});
            this.hlSynthese.add(new Component[]{vlButtons});
            this.hlSynthese.setAlignItems(FlexComponent.Alignment.END);
            this.hlSynthese.setMinHeight((float)TAILLE_SYNTHESE, Unit.PIXELS);
        } else {
            this.hlSynthese.add(new Component[]{this.syntheseSimple});
            this.syntheseSimple.setMinHeight((float)TAILLE_SYNTHESE, Unit.PIXELS);
            this.hlSynthese.add(new Component[]{vlButtons});
            this.hlSynthese.setAlignItems(FlexComponent.Alignment.END);
        }
        this.vlSynthese.add(new Component[]{this.hlSynthese});
        if (this.user.canDo(303)) {
            vlButtons.setVisible(true);
            if (!this.bSyntheseRich) {
                this.syntheseSimple.setEnabled(false);
            }
        } else {
            vlButtons.setVisible(false);
            if (!this.bSyntheseRich) {
                this.syntheseSimple.setEnabled(false);
            }
        }
        this.modifierSynthese.addClickListener((ComponentEventListener & Serializable)event -> {
            if (this.bSyntheseRich) {
                this.syntheseRich.setVisible(true);
                this.syntheseRich.setHideToolbar(false);
                this.syntheseRich.setReadOnly(false);
                this.oldSynthese = this.syntheseRich.getValue();
            } else {
                this.syntheseSimple.setEnabled(true);
                this.oldSynthese = this.syntheseSimple.getValue();
            }
            this.modeleBox.setVisible(this.modeleSynthese);
            this.modifierSynthese.setVisible(false);
            this.table.setEnabled(false);
            this.hlButtons.setEnabled(false);
            this.hlCombo.setEnabled(false);
            this.validerSynthese.setVisible(true);
            this.annulerSynthese.setVisible(true);
        });
        this.validerSynthese.addClickListener((ComponentEventListener & Serializable)event -> {
            Vector<String> changements = new Vector<String>();
            changements.add(this.getTranslation("vh.saisieCCH.title", new Object[0]));
            if (this.bSyntheseRich) {
                changements.add(this.getTranslation("vh.saisieCCH.button.modifsynthese", new Object[0]).concat(" --> ").concat(this.syntheseRich.getValue()));
            } else {
                changements.add(this.getTranslation("vh.saisieCCH.button.modifsynthese", new Object[0]).concat(" --> ").concat(this.syntheseSimple.getValue()));
            }
            this.ecrireMainCourant(changements);
            if (this.mySynthese == null) {
                this.mySynthese = new Synthese();
            }
            this.mySynthese.setDate(new Date());
            if (this.bSyntheseRich) {
                this.mySynthese.setCommentaire(this.syntheseRich.getValue());
            } else {
                this.mySynthese.setCommentaire(this.syntheseSimple.getValue());
            }
            this.saisieVhService.updateSyntheseSerpeVH(this.mySynthese);
            this.modeleBox.setVisible(false);
            if (this.bSyntheseRich) {
                this.syntheseRich.setVisible(false);
            } else {
                this.syntheseSimple.setEnabled(false);
            }
            this.modifierSynthese.setVisible(true);
            this.table.setEnabled(true);
            this.hlButtons.setEnabled(true);
            this.hlCombo.setEnabled(true);
            this.validerSynthese.setVisible(false);
            this.annulerSynthese.setVisible(false);
        });
        this.annulerSynthese.addClickListener((ComponentEventListener & Serializable)event -> {
            this.modeleBox.setVisible(false);
            if (this.bSyntheseRich) {
                this.syntheseRich.setVisible(true);
                this.syntheseRich.setValue(this.oldSynthese);
                this.syntheseRich.setReadOnly(true);
                this.syntheseRich.setHideToolbar(true);
            } else {
                this.syntheseSimple.setEnabled(false);
                this.syntheseSimple.setValue(this.oldSynthese);
            }
            this.modifierSynthese.setVisible(true);
            this.table.setEnabled(true);
            this.hlButtons.setEnabled(true);
            this.hlCombo.setEnabled(true);
            this.validerSynthese.setVisible(false);
            this.annulerSynthese.setVisible(false);
        });
    }

    private void createButtons() {
        this.hlButtons = new HorizontalLayout();
        this.hlButtons.setSizeUndefined();
        this.hlButtons.setSpacing(true);
        this.actualiser = new Button(this.getTranslation("vh.saisieCCH.button.actualiser", new Object[0]));
        this.actualiser.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.actualiser.setDisableOnClick(true);
        this.actualiser.setVisible(true);
        this.pasDeChangement = new Button(this.getTranslation("vh.saisieCCH.button.paschangement", new Object[0]));
        this.pasDeChangement.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.pasDeChangement.setDisableOnClick(true);
        this.pasDeChangement.setVisible(false);
        this.remiseZero = new Button(this.getTranslation("vh.saisieCCH.button.remisezero", new Object[0]));
        this.remiseZero.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.remiseZero.setDisableOnClick(true);
        this.remiseZero.setVisible(false);
        this.transmettreSerpe = new Button(this.getTranslation("vh.saisieCCH.button.transmettreSerpe", new Object[0]));
        this.transmettreSerpe.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.previsionPatrouille = new Button(this.getTranslation("vh.saisieCCH.button.previsionPatrouille", new Object[0]));
        this.previsionPatrouille.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.previsionPatrouille.setDisableOnClick(true);
        this.previsionPatrouille.setVisible(false);
        this.diffuserMail = new Button(this.getTranslation("vh.saisieCCH.button.diffuserMail", new Object[0]));
        this.diffuserMail.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.modifier = new Button(this.getTranslation("vh.saisieCCH.button.modifier", new Object[0]));
        this.modifier.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.publier = new Button(this.getTranslation("vh.saisieCCH.button.publier", new Object[0]));
        this.publier.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.depublier = new Button(this.getTranslation("vh.saisieCCH.button.depublier", new Object[0]));
        this.depublier.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.hlButtons.add(new Component[]{this.actualiser});
        this.hlButtons.add(new Component[]{this.pasDeChangement});
        if (!ProfilUtils.estOptionRefusee((int)this.getActionId(), (String)"raz")) {
            this.hlButtons.add(new Component[]{this.remiseZero});
        }
        if (ProfilUtils.estOptionAutorisee((int)this.getActionId(), (String)"previsionPatrouille")) {
            this.hlButtons.add(new Component[]{this.previsionPatrouille});
        }
        this.hlButtons.add(new Component[]{this.transmettreSerpe});
        this.hlButtons.add(new Component[]{this.diffuserMail});
        this.hlButtons.add(new Component[]{this.modifier});
        if (this.user.canDo(504)) {
            this.hlButtons.add(new Component[]{this.publier});
            if (!this.publicationParCopie) {
                this.hlButtons.add(new Component[]{this.depublier});
            }
        }
        this.actualiser.addClickListener((ComponentEventListener & Serializable)event -> this.actualiser());
        this.pasDeChangement.addClickListener((ComponentEventListener & Serializable)event -> {
            ConfirmDialog dialog = new ConfirmDialog();
            if (this.barreauVHSelection) {
                Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.attention", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.aucuntroncon", new Object[0])));
                notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
                this.pasDeChangement.setEnabled(true);
                return;
            }
            dialog.setHeader(this.getTranslation("Global.Confirmation", new Object[0]));
            dialog.setText(this.getTranslation("Global.Conformation.Message", new Object[0]));
            dialog.setConfirmButton(this.getTranslation("Global.Yes", new Object[0]), (ComponentEventListener & Serializable)event1 -> {
                try {
                    Vector<String> changements = new Vector<String>();
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.getTranslation("vh.saisieCCH.title", new Object[0]).concat(" --> ").concat(this.getTranslation("vh.saisieCCH.button.paschangement", new Object[0])));
                    if (this.barreauVHSelection) {
                        if (this.table.getSelectedItems().size() > 0) {
                            this.saisieVhService.pasDeChangementBarreauxVH(this.table.getSelectedItems());
                            changements.add(sb.toString());
                            this.ecrireMainCourant(changements);
                        }
                    } else {
                        switch (this.filtreEvolue) {
                            case 1: {
                                this.saisieVhService.pasDeChangementBarreauxVH(this.getCircuitPourSelection());
                                String circuitNom = GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString()) ? null : ((Circuit)this.circuitsBox.getValue()).toString();
                                sb.append(" --> ");
                                sb.append(circuitNom);
                                break;
                            }
                            case 2: {
                                this.saisieVhService.pasDeChangementBarreauxVH(this.getDelegationPourSelection(), this.getCentrePourSelection());
                                if (this.getDelegationPourSelection() != null) {
                                    sb.append(" --> ");
                                    sb.append(this.getDelegationPourSelection());
                                }
                                if (this.getCentrePourSelection() == null) break;
                                sb.append(" --> ");
                                sb.append(this.getCentrePourSelection());
                                break;
                            }
                            case 3: {
                                String circuitNom;
                                this.saisieVhService.pasDeChangementBarreauxVH(this.getDelegationPourSelection(), this.getCentrePourSelection(), this.getCircuitPourSelection());
                                if (this.getDelegationPourSelection() != null) {
                                    sb.append(" --> ");
                                    sb.append(this.getDelegationPourSelection());
                                }
                                if (this.getCentrePourSelection() != null) {
                                    sb.append(" --> ");
                                    sb.append(this.getCentrePourSelection());
                                }
                                if (this.circuitsBox.getValue() != null && !GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString())) {
                                    circuitNom = GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString()) ? null : ((Circuit)this.circuitsBox.getValue()).toString();
                                    sb.append(" --> ");
                                    sb.append(circuitNom);
                                    break;
                                }
                                circuitNom = null;
                                break;
                            }
                            default: {
                                String circuitNom;
                                if (this.filtrerParCircuit) {
                                    this.saisieVhService.pasDeChangementBarreauxVH(this.getCircuitPourSelection());
                                    circuitNom = GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString()) ? null : ((Circuit)this.circuitsBox.getValue()).toString();
                                    sb.append(" --> ");
                                    sb.append(circuitNom);
                                    break;
                                }
                                this.saisieVhService.pasDeChangementBarreauxVH(this.getDelegationPourSelection(), this.getCentrePourSelection());
                                if (this.getDelegationPourSelection() != null) {
                                    sb.append(" --> ");
                                    sb.append(this.getDelegationPourSelection());
                                }
                                if (this.getCentrePourSelection() == null) break;
                                sb.append(" --> ");
                                sb.append(this.getCentrePourSelection());
                            }
                        }
                        changements.add(sb.toString());
                        this.ecrireMainCourant(changements);
                    }
                    this.chargerTable();
                    if (this.cartoPane != null) {
                        this.refresh();
                    }
                    Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.ok", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.paschangementok", new Object[0])));
                    notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
                }
                catch (Exception e) {
                    Log.error((Object)"Erreur pas de changement barreau - ", (Throwable)e);
                    Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.erreur", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.paschangementerreur", new Object[0])));
                    notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
                }
                finally {
                    this.pasDeChangement.setEnabled(true);
                }
            });
            dialog.setCancelButton(this.getTranslation("Global.No", new Object[0]), (ComponentEventListener & Serializable)e -> this.pasDeChangement.setEnabled(true));
            dialog.open();
        });
        this.remiseZero.addClickListener((ComponentEventListener & Serializable)event -> {
            if (this.barreauVHSelection) {
                Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.attention", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.aucuntroncon", new Object[0])));
                notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
                this.remiseZero.setEnabled(true);
                return;
            }
            ConfirmDialog dialog = new ConfirmDialog();
            dialog.setHeader(this.getTranslation("Global.Confirmation", new Object[0]));
            dialog.setText(this.getTranslation("Global.Conformation.Message", new Object[0]));
            dialog.setConfirmButton(this.getTranslation("Global.Yes", new Object[0]), (ComponentEventListener & Serializable)event1 -> {
                try {
                    Vector<String> changements = new Vector<String>();
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.getTranslation("vh.saisieCCH.title", new Object[0]).concat(" --> ").concat(this.getTranslation("vh.saisieCCH.button.remisezero", new Object[0])));
                    if (this.barreauVHSelection) {
                        if (this.table.getSelectedItems().size() > 0) {
                            this.saisieVhService.remiseAZeroBarreauxVH(this.table.getSelectedItems().stream().toList());
                            changements.add(sb.toString());
                            this.ecrireMainCourant(changements);
                        }
                    } else {
                        switch (this.filtreEvolue) {
                            case 1: {
                                this.saisieVhService.remiseAZeroBarreauxVH(this.getCircuitPourSelection());
                                String circuitNom = GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString()) ? null : ((Circuit)this.circuitsBox.getValue()).toString();
                                sb.append(" --> ");
                                sb.append(circuitNom);
                                break;
                            }
                            case 2: {
                                this.saisieVhService.remiseAZeroBarreauxVH(this.getDelegationPourSelection(), this.getCentrePourSelection());
                                if (this.getDelegationPourSelection() != null) {
                                    sb.append(" --> ");
                                    sb.append(this.getDelegationPourSelection());
                                }
                                if (this.getCentrePourSelection() == null) break;
                                sb.append(" --> ");
                                sb.append(this.getCentrePourSelection());
                                break;
                            }
                            case 3: {
                                String circuitNom;
                                this.saisieVhService.remiseAZeroBarreauxVH(this.getDelegationPourSelection(), this.getCentrePourSelection(), this.getCircuitPourSelection());
                                if (this.getDelegationPourSelection() != null) {
                                    sb.append(" --> ");
                                    sb.append(this.getDelegationPourSelection());
                                }
                                if (this.getCentrePourSelection() != null) {
                                    sb.append(" --> ");
                                    sb.append(this.getCentrePourSelection());
                                }
                                if (this.circuitsBox.getValue() != null && !GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString())) {
                                    circuitNom = GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString()) ? null : ((Circuit)this.circuitsBox.getValue()).toString();
                                    sb.append(" --> ");
                                    sb.append(circuitNom);
                                    break;
                                }
                                circuitNom = null;
                                break;
                            }
                            default: {
                                String circuitNom;
                                if (this.filtrerParCircuit) {
                                    this.saisieVhService.remiseAZeroBarreauxVH(this.getCircuitPourSelection());
                                    circuitNom = GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString()) ? null : ((Circuit)this.circuitsBox.getValue()).toString();
                                    sb.append(" --> ");
                                    sb.append(circuitNom);
                                    break;
                                }
                                this.saisieVhService.remiseAZeroBarreauxVH(this.getDelegationPourSelection(), this.getCentrePourSelection());
                                if (this.getDelegationPourSelection() != null) {
                                    sb.append(" --> ");
                                    sb.append(this.getDelegationPourSelection());
                                }
                                if (this.getCentrePourSelection() == null) break;
                                sb.append(" --> ");
                                sb.append(this.getCentrePourSelection());
                            }
                        }
                        changements.add(sb.toString());
                        this.ecrireMainCourant(changements);
                    }
                    this.chargerTable();
                    if (this.cartoPane != null) {
                        this.refresh();
                    }
                    Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.ok", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.remisezerook", new Object[0])));
                    notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
                }
                catch (Exception e) {
                    Log.error((Object)"Erreur raz barreau - ", (Throwable)e);
                    Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.erreur", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.remisezeroerreur", new Object[0])));
                    notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
                }
                finally {
                    this.remiseZero.setEnabled(true);
                }
            });
            dialog.setCancelButton(this.getTranslation("Global.No", new Object[0]), (ComponentEventListener & Serializable)e -> this.remiseZero.setEnabled(true));
            dialog.open();
        });
        this.previsionPatrouille.addClickListener((ComponentEventListener & Serializable)event -> {
            ConfirmDialog dialog = new ConfirmDialog();
            dialog.setHeader(this.getTranslation("Global.Confirmation", new Object[0]));
            dialog.setText(this.getTranslation("Global.Conformation.Message", new Object[0]));
            dialog.setConfirmButton(this.getTranslation("Global.Yes", new Object[0]), (ComponentEventListener & Serializable)event1 -> {
                try {
                    Vector<String> changements = new Vector<String>();
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.getTranslation("vh.saisieCCH.title", new Object[0]).concat(" --> ").concat(this.getTranslation("vh.saisieCCH.button.previsionPatrouille", new Object[0])));
                    switch (this.filtreEvolue) {
                        case 1: {
                            this.saisieVhService.previsionPatrouilleBarreauxVH(this.getCircuitPourSelection());
                            String circuitNom = GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString()) ? null : ((Circuit)this.circuitsBox.getValue()).toString();
                            sb.append(" --> ");
                            sb.append(circuitNom);
                            break;
                        }
                        case 2: {
                            this.saisieVhService.previsionPatrouilleBarreauxVH(this.getDelegationPourSelection(), this.getCentrePourSelection());
                            if (this.getDelegationPourSelection() != null) {
                                sb.append(" --> ");
                                sb.append(this.getDelegationPourSelection());
                            }
                            if (this.getCentrePourSelection() == null) break;
                            sb.append(" --> ");
                            sb.append(this.getCentrePourSelection());
                            break;
                        }
                        case 3: {
                            String circuitNom;
                            this.saisieVhService.previsionPatrouilleBarreauxVH(this.getDelegationPourSelection(), this.getCentrePourSelection(), this.getCircuitPourSelection());
                            if (this.getDelegationPourSelection() != null) {
                                sb.append(" --> ");
                                sb.append(this.getDelegationPourSelection());
                            }
                            if (this.getCentrePourSelection() != null) {
                                sb.append(" --> ");
                                sb.append(this.getCentrePourSelection());
                            }
                            if (this.circuitsBox.getValue() != null && !GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString())) {
                                circuitNom = GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString()) ? null : ((Circuit)this.circuitsBox.getValue()).toString();
                                sb.append(" --> ");
                                sb.append(circuitNom);
                                break;
                            }
                            circuitNom = null;
                            break;
                        }
                        default: {
                            String circuitNom;
                            if (this.filtrerParCircuit) {
                                this.saisieVhService.previsionPatrouilleBarreauxVH(this.getCircuitPourSelection());
                                circuitNom = GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString()) ? null : ((Circuit)this.circuitsBox.getValue()).toString();
                                sb.append(" --> ");
                                sb.append(circuitNom);
                                break;
                            }
                            this.saisieVhService.previsionPatrouilleBarreauxVH(this.getDelegationPourSelection(), this.getCentrePourSelection());
                            if (this.getDelegationPourSelection() != null) {
                                sb.append(" --> ");
                                sb.append(this.getDelegationPourSelection());
                            }
                            if (this.getCentrePourSelection() == null) break;
                            sb.append(" --> ");
                            sb.append(this.getCentrePourSelection());
                        }
                    }
                    changements.add(sb.toString());
                    this.ecrireMainCourant(changements);
                    this.chargerTable();
                    if (this.cartoPane != null) {
                        this.refresh();
                    }
                    Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.ok", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.previsionpatrouilleok", new Object[0])));
                    notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
                }
                catch (Exception e) {
                    Log.error((Object)"Erreur prevision patrouille - ", (Throwable)e);
                    Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.erreur", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.previsionpatrouilleerreur", new Object[0])));
                    notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
                }
                finally {
                    this.previsionPatrouille.setEnabled(true);
                }
            });
            dialog.setCancelButton(this.getTranslation("Global.No", new Object[0]), (ComponentEventListener & Serializable)e -> this.previsionPatrouille.setEnabled(true));
            dialog.open();
        });
        this.transmettreSerpe.addClickListener((ComponentEventListener & Serializable)event -> {
            if (this.barreauVHSelection) {
                Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.attention", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.aucuntroncon", new Object[0])));
                notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
                this.transmettreSerpe.setEnabled(true);
                return;
            }
            ConfirmDialog dialog = new ConfirmDialog();
            dialog.setHeader(this.getTranslation("Global.Confirmation", new Object[0]));
            dialog.setText(this.getTranslation("Global.Conformation.Message", new Object[0]));
            dialog.setConfirmButton(this.getTranslation("Global.Yes", new Object[0]), (ComponentEventListener & Serializable)confirmEvent -> {
                try {
                    boolean transmissionOK = false;
                    if (this.barreauVHSelection) {
                        Set col = this.table.getSelectedItems();
                        if (col.size() > 0) {
                            transmissionOK = this.saisieVhService.transmettreBarreauxSerpeVH(this.selectionBarreauxParDelegation, col.stream().collect(Collectors.toUnmodifiableList()));
                        }
                    } else {
                        transmissionOK = this.saisieVhService.transmettreBarreauxSerpeVH(this.selectionBarreauxParDelegation);
                    }
                    if (transmissionOK) {
                        Vector<String> changements = new Vector<String>();
                        changements.add(this.getTranslation("vh.saisieCCH.title", new Object[0]).concat(" --> ").concat(this.getTranslation("vh.saisieCCH.button.transmettreSerpe", new Object[0])));
                        this.ecrireMainCourant(changements);
                        Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.ok", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.serpeok", new Object[0])));
                        notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
                    } else {
                        Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.erreur", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.serpeerreur", new Object[0])));
                        notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
                    }
                }
                catch (Exception e) {
                    Log.error((Object)"Erreur transmission barreau tipi - ", (Throwable)e);
                    Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.erreur", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.serpeerreur", new Object[0])));
                    notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
                }
                finally {
                    this.transmettreSerpe.setEnabled(true);
                }
            });
            dialog.setCancelButton(this.getTranslation("Global.No", new Object[0]), (ComponentEventListener & Serializable)e -> this.transmettreSerpe.setEnabled(true));
            dialog.open();
        });
        this.modifier.addClickListener((ComponentEventListener & Serializable)event -> {
            Set col = this.table.getSelectedItems();
            if (col.size() > 0) {
                this.interfaceModificationBarreaux(col.stream().map(b -> b).toList());
            } else {
                Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.attention", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.aucuntroncon", new Object[0])));
                notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
            }
        });
        this.diffuserMail.addClickListener((ComponentEventListener & Serializable)event -> {
            if (BusinessServiceFactory.getBusinessService().getConfiguration().getBoolean("vh.envoimail.choixdestinataire", false)) {
                this.diffuserMailChoixListe();
            } else {
                ConfirmDialog dialog = new ConfirmDialog();
                dialog.setHeader(this.getTranslation("Global.Confirmation", new Object[0]));
                dialog.setText(this.getTranslation("Global.Conformation.Message", new Object[0]));
                dialog.setConfirmButton(this.getTranslation("Global.Yes", new Object[0]), (ComponentEventListener & Serializable)e -> this.diffuserMail());
                dialog.setCancelButton(this.getTranslation("Global.No", new Object[0]), (ComponentEventListener & Serializable)e -> this.transmettreSerpe.setEnabled(true));
                dialog.open();
            }
        });
        this.publier.addClickListener((ComponentEventListener & Serializable)event -> {
            ConfirmDialog dialog = new ConfirmDialog();
            dialog.setHeader(this.getTranslation("Global.Confirmation", new Object[0]));
            dialog.setText(this.getTranslation("Global.Conformation.Message", new Object[0]));
            dialog.setConfirmButton(this.getTranslation("Global.Yes", new Object[0]), (ComponentEventListener & Serializable)e -> {
                if (!this.publicationParCopie) {
                    ArrayList liste = new ArrayList();
                    Set col = this.table.getSelectedItems();
                    if (col.size() > 0) {
                        this.publierBarreauxVH(liste.stream().map(b -> b).toList());
                    } else {
                        Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.attention", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.aucuntroncon", new Object[0])));
                        notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
                    }
                } else {
                    this.publierCopieBarreauxVH();
                }
            });
            dialog.setCancelText(this.getTranslation("Global.No", new Object[0]));
            dialog.open();
        });
        this.depublier.addClickListener((ComponentEventListener & Serializable)event -> {
            ConfirmDialog dialog = new ConfirmDialog();
            dialog.setHeader(this.getTranslation("Global.Confirmation", new Object[0]));
            dialog.setText(this.getTranslation("Global.Conformation.Message", new Object[0]));
            dialog.setConfirmButton(this.getTranslation("Global.Yes", new Object[0]), (ComponentEventListener & Serializable)e -> {
                Set liste = this.table.getSelectedItems();
                if (liste.size() > 0) {
                    this.depublierBarreauxVH(liste.stream().map(b -> b).toList());
                } else {
                    Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.attention", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.aucuntroncon", new Object[0])));
                    notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
                }
            });
            dialog.setCancelText(this.getTranslation("Global.No", new Object[0]));
            dialog.open();
        });
        switch (this.filtreEvolue) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.pasDeChangement.setVisible(true);
                this.remiseZero.setVisible(true);
                this.previsionPatrouille.setVisible(true);
            }
        }
    }

    protected void actualiser() {
        this.actualiser.setEnabled(false);
        try {
            this.chargerTable();
            if (this.cartoPane != null) {
                this.refresh();
            }
            this.refreshHeader();
        }
        catch (Exception exception) {
        }
        finally {
            this.actualiser.setEnabled(true);
        }
    }

    private void diffuserMail() {
        this.saisieVhService.diffusionVH();
    }

    private void diffuserMailChoixListe() {
        this.interfaceChoixDestinataires();
    }

    protected void interfaceModificationBarreaux(List<BarreauVH> liste) {
        Dialog win = new Dialog(this.getTranslation("vh.saisieCCH.modification", new Object[0]));
        win.setModal(true);
        win.setResizable(false);
        win.setSizeUndefined();
        win.setWidth(100.0f, Unit.PERCENTAGE);
        SaisieCCHModification form = new SaisieCCHModification(this.saisieVhService, liste);
        form.getRetour().addClickListener((ComponentEventListener & Serializable)event -> win.close());
        form.getEnregistrer().addClickListener((ComponentEventListener & Serializable)event -> {
            ConfirmDialog dialog = new ConfirmDialog();
            dialog.setHeader(this.getTranslation("Global.Confirmation", new Object[0]));
            dialog.setText(this.getTranslation("Global.Conformation.Message", new Object[0]));
            dialog.setConfirmButton(this.getTranslation("Global.Yes", new Object[0]), (ComponentEventListener & Serializable)evenvt -> {
                try {
                    form.enregistrerModifications();
                    this.saisieVhService.updateBarreauxVH(form.getListeBarreaux());
                    Vector<String> changements = new Vector<String>();
                    changements.add(this.getTranslation("vh.saisieCCH.title", new Object[0]));
                    changements.addAll(form.getChangements());
                    this.ecrireMainCourant(changements);
                    win.close();
                    Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.modification", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.modificationok", new Object[0])));
                    notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
                    this.chargerTable();
                    if (this.cartoPane != null) {
                        this.refresh();
                    }
                }
                catch (Exception e) {
                    Log.error((Object)"err modif tron\ufffdons vh", (Throwable)e);
                    Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.modification", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.modificationerreur", new Object[0])));
                    notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_WARNING});
                }
            });
            dialog.open();
        });
        win.add(new Component[]{form});
        win.open();
    }

    private void createComboBox() {
        this.hlCombo = new HorizontalLayout();
        this.hlCombo.setSizeUndefined();
        this.hlCombo.setSpacing(true);
        this.hlCombo.setMargin(true);
        this.delegationsBox = new ComboBox(this.getTranslation("global.delegation", new Object[0]));
        this.centresBox = new ComboBox(this.getTranslation("global.centre", new Object[0]));
        this.circuitsBox = new ComboBox(this.getTranslation("global.circuit", new Object[0]));
        switch (this.filtreEvolue) {
            case 1: {
                this.hlCombo.add(new Component[]{this.circuitsBox});
                break;
            }
            case 2: {
                this.hlCombo.add(new Component[]{this.delegationsBox});
                if (this.selectionBarreauxParDelegation) break;
                this.hlCombo.add(new Component[]{this.centresBox});
                break;
            }
            case 3: {
                this.hlCombo.add(new Component[]{this.delegationsBox});
                if (!this.selectionBarreauxParDelegation) {
                    this.hlCombo.add(new Component[]{this.centresBox});
                }
                this.hlCombo.add(new Component[]{this.circuitsBox});
                break;
            }
            default: {
                if (this.filtrerParCircuit) {
                    this.hlCombo.add(new Component[]{this.circuitsBox});
                    break;
                }
                this.hlCombo.add(new Component[]{this.delegationsBox});
                if (this.selectionBarreauxParDelegation) break;
                this.hlCombo.add(new Component[]{this.centresBox});
            }
        }
        switch (this.filtreEvolue) {
            case 1: {
                this.circuits = this.saisieVhService.getCircuitsVHActifs();
                this.circuitsBox.setValue((Object)this.circuits);
                this.circuitsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                    int idCircuit = this.getCircuitPourSelection();
                    this.chargerTable(idCircuit);
                    if (idCircuit < 0) {
                        this.pasDeChangement.setVisible(false);
                        this.remiseZero.setVisible(false);
                        this.previsionPatrouille.setVisible(false);
                    } else {
                        this.pasDeChangement.setVisible(true);
                        this.remiseZero.setVisible(true);
                        this.previsionPatrouille.setVisible(true);
                    }
                });
                break;
            }
            case 2: {
                this.delegationsBox.setValue((Object)this.saisieVhService.getDelegationsActives());
                if (!GLS.estVide((String)this.user.getDelegation())) {
                    int indice = MetierCommun.getIndiceObjetListe((List)this.saisieVhService.getDelegationsActives(), (Object)this.user.getDelegation());
                    Delegation d = (Delegation)this.saisieVhService.getDelegationsActives().get(indice);
                    this.delegationsBox.setValue((Object)d);
                    this.delegationsBox.setEnabled(false);
                    this.centresBox.setValue((Object)d.getCentres());
                    if (!GLS.estVide((String)this.user.getCentre())) {
                        indice = MetierCommun.getIndiceObjetListe((List)d.getCentres(), (Object)this.user.getCentre());
                        Centre c = (Centre)d.getCentres().get(indice);
                        this.centresBox.setValue((Object)c);
                        this.centresBox.setEnabled(false);
                    }
                } else {
                    this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        this.centresBox.clear();
                        if (event.getValue() != null) {
                            Delegation delegation = (Delegation)event.getValue();
                            this.centresBox.setValue((Object)delegation.getCentres());
                            this.chargerTable(event.getValue().toString(), null);
                            this.pasDeChangement.setVisible(true);
                            this.remiseZero.setVisible(true);
                        } else {
                            this.pasDeChangement.setVisible(false);
                            this.remiseZero.setVisible(false);
                        }
                    });
                }
                if (this.selectionBarreauxParDelegation) {
                    this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        if (event.getValue() != null) {
                            this.chargerTable(event.getValue().toString(), null);
                            this.pasDeChangement.setVisible(true);
                            this.remiseZero.setVisible(true);
                        } else {
                            this.pasDeChangement.setVisible(false);
                            this.remiseZero.setVisible(false);
                        }
                    });
                    if (this.delegationsBox.getValue() == null) break;
                    this.chargerTable(((Delegation)this.delegationsBox.getValue()).getNom(), this.getCentrePourSelection());
                    this.pasDeChangement.setVisible(true);
                    this.remiseZero.setVisible(true);
                    break;
                }
                this.centresBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                    if (this.delegationsBox.getValue() != null) {
                        this.chargerTable(((Delegation)this.delegationsBox.getValue()).getNom(), this.getCentrePourSelection());
                        this.pasDeChangement.setVisible(true);
                        this.remiseZero.setVisible(true);
                        this.previsionPatrouille.setVisible(true);
                    }
                });
                if (this.delegationsBox.getValue() == null) break;
                this.chargerTable(((Delegation)this.delegationsBox.getValue()).getNom(), this.getCentrePourSelection());
                this.pasDeChangement.setVisible(true);
                this.remiseZero.setVisible(true);
                this.previsionPatrouille.setVisible(true);
                break;
            }
            case 3: {
                this.circuits = this.saisieVhService.getCircuitsVHActifs();
                this.mapNomsCircuits = new HashMap();
                for (Circuit circuit : this.circuits) {
                    this.mapNomsCircuits.put(circuit.getId(), circuit.getNom());
                }
                this.remplirComboAvecNull(this.circuitsBox, this.circuits, (Object)this.circuitNull, this.getTranslation("mct.filtre.circuit.tous", new Object[0]));
                this.circuitsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                    int idCircuit = this.getCircuitPourSelection();
                    this.chargerTable();
                    if (idCircuit >= 0) {
                        this.pasDeChangement.setVisible(true);
                        this.remiseZero.setVisible(true);
                        this.previsionPatrouille.setVisible(true);
                    }
                });
                this.remplirComboAvecNull(this.delegationsBox, this.saisieVhService.getDelegationsActives(), (Object)this.delegationNull, this.getTranslation("mct.filtre.delegation.toutes", new Object[0]));
                if (!GLS.estVide((String)this.user.getDelegation())) {
                    int indice = MetierCommun.getIndiceObjetListe((List)this.saisieVhService.getDelegationsActives(), (Object)this.user.getDelegation());
                    Delegation d = (Delegation)this.saisieVhService.getDelegationsActives().get(indice);
                    this.delegationsBox.setValue((Object)d);
                    this.delegationsBox.setEnabled(false);
                    this.remplirComboAvecNull(this.centresBox, d.getCentres(), (Object)this.centreNull, this.getTranslation("mct.filtre.centre.toutes", new Object[0]));
                    if (!GLS.estVide((String)this.user.getCentre())) {
                        indice = MetierCommun.getIndiceObjetListe((List)d.getCentres(), (Object)this.user.getCentre());
                        Centre c = (Centre)d.getCentres().get(indice);
                        this.centresBox.setValue((Object)c);
                        this.centresBox.setEnabled(false);
                    }
                } else {
                    this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        this.centresBox.clear();
                        if (event.getValue() != null) {
                            Delegation delegation = (Delegation)event.getValue();
                            if (delegation.getCentres() != null) {
                                this.remplirComboAvecNull(this.centresBox, delegation.getCentres(), (Object)this.centreNull, this.getTranslation("mct.filtre.centre.tous", new Object[0]));
                                this.pasDeChangement.setVisible(true);
                                this.remiseZero.setVisible(true);
                                this.previsionPatrouille.setVisible(true);
                            }
                        } else {
                            this.remplirComboAvecNull(this.centresBox, null, (Object)this.centreNull, this.getTranslation("mct.filtre.centre.tous", new Object[0]));
                            this.pasDeChangement.setVisible(true);
                            this.remiseZero.setVisible(true);
                            this.previsionPatrouille.setVisible(true);
                        }
                        this.trierCircuitsCombBox();
                        this.chargerTable();
                    });
                    this.remplirComboAvecNull(this.centresBox, null, (Object)this.centreNull, this.getTranslation("mct.filtre.centre.tous", new Object[0]));
                }
                if (this.selectionBarreauxParDelegation) {
                    this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        if (event.getValue() != null) {
                            this.trierCircuitsCombBox();
                            this.chargerTable();
                            this.pasDeChangement.setVisible(true);
                            this.remiseZero.setVisible(true);
                            this.previsionPatrouille.setVisible(true);
                        } else {
                            this.pasDeChangement.setVisible(false);
                            this.remiseZero.setVisible(false);
                            this.previsionPatrouille.setVisible(false);
                        }
                    });
                    if (this.delegationsBox.getValue() != null) {
                        this.pasDeChangement.setVisible(true);
                        this.remiseZero.setVisible(true);
                        this.previsionPatrouille.setVisible(true);
                    }
                } else {
                    this.centresBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        if (this.delegationsBox.getValue() != null) {
                            this.trierCircuitsCombBox();
                            this.chargerTable();
                            this.pasDeChangement.setVisible(true);
                            this.remiseZero.setVisible(true);
                            this.previsionPatrouille.setVisible(true);
                        }
                    });
                    if (this.delegationsBox.getValue() != null) {
                        this.pasDeChangement.setVisible(true);
                        this.remiseZero.setVisible(true);
                        this.previsionPatrouille.setVisible(true);
                    }
                }
                this.chargerTable();
                break;
            }
            default: {
                if (this.filtrerParCircuit) {
                    this.circuits = this.saisieVhService.getCircuitsVHActifs();
                    this.circuitsBox.setItems((Collection)this.circuits);
                    this.circuitsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        int idCircuit = this.getCircuitPourSelection();
                        this.chargerTable(idCircuit);
                        if (idCircuit < 0) {
                            this.pasDeChangement.setVisible(false);
                            this.remiseZero.setVisible(false);
                            this.previsionPatrouille.setVisible(false);
                        } else {
                            this.pasDeChangement.setVisible(true);
                            this.remiseZero.setVisible(true);
                            this.previsionPatrouille.setVisible(true);
                        }
                    });
                    break;
                }
                this.delegationsBox.setItems((Collection)this.saisieVhService.getDelegationsActives());
                if (!GLS.estVide((String)this.user.getDelegation())) {
                    int indice = MetierCommun.getIndiceObjetListe((List)this.saisieVhService.getDelegationsActives(), (Object)this.user.getDelegation());
                    Delegation d = (Delegation)this.saisieVhService.getDelegationsActives().get(indice);
                    this.delegationsBox.setValue((Object)d);
                    this.delegationsBox.setEnabled(false);
                    this.centresBox.setItems((Collection)d.getCentres());
                    if (!GLS.estVide((String)this.user.getCentre())) {
                        indice = MetierCommun.getIndiceObjetListe((List)d.getCentres(), (Object)this.user.getCentre());
                        Centre c = (Centre)d.getCentres().get(indice);
                        this.centresBox.setValue((Object)c);
                        this.centresBox.setEnabled(false);
                    }
                } else {
                    this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        this.centresBox.clear();
                        if (event.getValue() != null) {
                            Delegation delegation = (Delegation)event.getValue();
                            this.centresBox.setItems((Collection)delegation.getCentres());
                            this.chargerTable(event.getValue().toString(), null);
                            this.pasDeChangement.setVisible(true);
                            this.remiseZero.setVisible(true);
                            this.previsionPatrouille.setVisible(true);
                        } else {
                            this.pasDeChangement.setVisible(false);
                            this.remiseZero.setVisible(false);
                            this.previsionPatrouille.setVisible(false);
                        }
                    });
                }
                if (this.selectionBarreauxParDelegation) {
                    this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        if (event.getValue() != null) {
                            this.chargerTable(event.getValue().toString(), null);
                            this.pasDeChangement.setVisible(true);
                            this.remiseZero.setVisible(true);
                            this.previsionPatrouille.setVisible(true);
                        } else {
                            this.pasDeChangement.setVisible(false);
                            this.remiseZero.setVisible(false);
                            this.previsionPatrouille.setVisible(false);
                        }
                    });
                    if (this.delegationsBox.getValue() == null) break;
                    this.chargerTable(((Delegation)this.delegationsBox.getValue()).getNom(), this.getCentrePourSelection());
                    this.pasDeChangement.setVisible(true);
                    this.remiseZero.setVisible(true);
                    this.previsionPatrouille.setVisible(true);
                    break;
                }
                this.centresBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                    if (this.delegationsBox.getValue() != null) {
                        this.chargerTable(((Delegation)this.delegationsBox.getValue()).getNom(), this.getCentrePourSelection());
                        this.pasDeChangement.setVisible(true);
                        this.remiseZero.setVisible(true);
                        this.previsionPatrouille.setVisible(true);
                    }
                });
                if (this.delegationsBox.getValue() == null) break;
                this.chargerTable(((Delegation)this.delegationsBox.getValue()).getNom(), this.getCentrePourSelection());
                this.pasDeChangement.setVisible(true);
                this.remiseZero.setVisible(true);
                this.previsionPatrouille.setVisible(true);
            }
        }
    }

    private void createTableau() {
        this.table.setSelectionMode(Grid.SelectionMode.MULTI);
        this.table.addSelectionListener((SelectionListener & Serializable)selection -> {
            Set col = selection.getAllSelectedItems();
        });
        this.table.addComponentColumn((ValueProvider & Serializable)i -> i.isPublie() ? new Image("ico/publish.png", "alt text") : null).setHeader(this.getTranslation("vh.champ.publie", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("publie"));
        ((Grid.Column)this.table.addColumn(BarreauVH::getIdGroupe).setHeader(this.getTranslation("vh.champ.idgroupe", new Object[0])).setSortable(true).setAutoWidth(true).setFrozen(true)).setFlexGrow(0).setVisible(this.tableColumns.contains("idGroupe"));
        ((Grid.Column)((Grid.Column)this.table.addColumn(BarreauVH::getTronconID).setHeader(this.getTranslation("vh.champ.id", new Object[0])).setSortable(true).setAutoWidth(true).setFrozen(true)).setFlexGrow(0).setResizable(true)).setVisible(this.tableColumns.contains("tronconId"));
        ((Grid.Column)((Grid.Column)this.table.addColumn(Troncon::getDescription).setHeader(this.getTranslation("vh.champ.description", new Object[0])).setSortable(true).setAutoWidth(true).setFrozen(true)).setResizable(true)).setVisible(this.tableColumns.contains("libelle"));
        this.table.addColumn(Troncon::getCircuit).setHeader(this.getTranslation("vh.champ.circuit", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("circuit"));
        this.table.addColumn((ValueProvider & Serializable)b -> {
            boolean dateBarreauInvalide;
            boolean bl = dateBarreauInvalide = !ConfigUtils.estAffichageValiditeBarreauxVHReel() && !b.estDateValide(this.DUREE_VALIDITE_VARIABLE, this.TIME_LIMIT);
            return b.getCch() != null ? (dateBarreauInvalide ? "NR" : b.getCch()) : "";
        }).setClassNameGenerator(BarreauVH::getCch).setHeader(this.getTranslation("vh.champ.cch", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("cch"));
        this.table.addColumn(BarreauVH::getCch2).setHeader(this.getTranslation("vh.champ.cch2", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("cch2"));
        this.table.addColumn(BarreauVH::getTendanceCC).setHeader(this.getTranslation("vh.champ.tendance", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("tendanceCC"));
        this.table.addColumn(BarreauVH::getMeteo).setHeader(this.getTranslation("vh.champ.meteo", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("meteo"));
        this.table.addColumn(BarreauVH::getTemperature).setHeader(this.getTranslation("vh.champ.temperature", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("temperature"));
        this.table.addColumn(BarreauVH::getVent).setHeader(this.getTranslation("vh.champ.vent", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("vent"));
        this.table.addColumn(BarreauVH::getEtatChaussee).setHeader(this.getTranslation("vh.champ.etat_chaussee", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("etatChaussee"));
        this.table.addColumn(BarreauVH::getEquipements).setHeader(this.getTranslation("vh.champ.equipements", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("equipements"));
        this.table.addColumn(BarreauVH::getTraitement).setHeader(this.getTranslation("vh.champ.traitement", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("traitement"));
        this.table.addColumn(BarreauVH::getCommentaireInterne).setHeader(this.getTranslation("vh.champ.comentaire_interne", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("commentaireInterne"));
        this.table.addColumn(BarreauVH::getCommentaire).setHeader(this.getTranslation("vh.champ.commentaire", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("commentaire"));
        this.table.addColumn(BarreauVH::getDuree).setHeader(this.getTranslation("vh.champ.duree_validite", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("dureeValidite"));
        this.table.addColumn((ValueProvider & Serializable)d -> {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            return d.getMajDate() != null ? sdf.format(d.getMajDate()) : "";
        }).setClassNameGenerator((SerializableFunction & Serializable)d -> d.estDateValide(this.DUREE_VALIDITE_VARIABLE, this.TIME_LIMIT) ? "OK" : "OUTDATED").setHeader(this.getTranslation("vh.champ.date", new Object[0])).setSortable(true).setAutoWidth(true).setVisible(this.tableColumns.contains("majDate"));
        this.table.addColumn(BarreauVHHisto::getUtilisateur).setHeader(this.getTranslation("vh.champ.auteur", new Object[0])).setAutoWidth(true).setVisible(this.tableColumns.contains("auteur"));
        this.table.addComponentColumn((ValueProvider & Serializable)i -> i.getTypePoste() == 1 ? new Image("images/ico/patrouilleur.png", "PATROUILLEUR") : new Image("images/ico/bureau.png", "BUREAU")).setHeader(this.getTranslation("vh.champ.source", new Object[0])).setVisible(this.tableColumns.contains("source"));
        this.table.addColumn(this.createViewButtonHistoriqueRenderer()).setHeader(this.getTranslation("vh.champ.historique", new Object[0])).setVisible(this.tableColumns.contains("historique"));
        this.table.setColumnReorderingAllowed(true);
        this.table.addThemeVariants(new GridVariant[]{GridVariant.LUMO_ROW_STRIPES});
    }

    private Renderer<BarreauVHHisto> createViewButtonHistoriqueRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)item -> {
            Icon buttonIcon = VaadinIcon.EYE.create();
            buttonIcon.setColor("var(--lumo-contrast)");
            Calendar cal = Calendar.getInstance();
            Calendar calYEsterday = Calendar.getInstance();
            calYEsterday.add(5, -1);
            if (item.getMajDate().after(calYEsterday.getTime())) {
                Anchor download = new Anchor();
                download.setTarget((AnchorTargetValue)AnchorTarget.BLANK);
                download.setHref(HistoriqueSaisieCCHExportController.Helper.createHistoriqueSaisieCCHExportURL((String)item.getId()));
                Button historiqueBarreauExportButton = new Button((Component)buttonIcon, (ComponentEventListener & Serializable)event -> download.setHref(HistoriqueSaisieCCHExportController.Helper.createHistoriqueSaisieCCHExportURL((String)item.getId())));
                download.add(new Component[]{historiqueBarreauExportButton});
                historiqueBarreauExportButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
                historiqueBarreauExportButton.setTooltipText(this.getTranslation("Historique", new Object[0]));
                return download;
            }
            return new Text("");
        });
    }

    private void chargerTable() {
        switch (this.filtreEvolue) {
            case 1: {
                this.chargerTable(this.getCircuitPourSelection());
                break;
            }
            case 2: {
                this.chargerTable(this.getDelegationPourSelection(), this.getCentrePourSelection());
                break;
            }
            case 3: {
                this.chargerTable(this.getDelegationPourSelection(), this.getCentrePourSelection(), this.getCircuitPourSelection());
                break;
            }
            default: {
                if (this.filtrerParCircuit) {
                    this.chargerTable(this.getCircuitPourSelection());
                    break;
                }
                this.chargerTable(this.getDelegationPourSelection(), this.getCentrePourSelection());
            }
        }
    }

    private void chargerTable(String delegation, String centre, int circuit) {
        List liste = this.saisieVhService.getBarreauxVH(delegation, centre, circuit, true);
        this.remplirTable(liste);
        this.updateCarto(liste);
    }

    private void chargerTable(String delegation, String centre) {
        List liste = new ArrayList();
        if (delegation != null) {
            liste = this.saisieVhService.getBarreauxVH(delegation, centre, -1, true);
        }
        this.remplirTable(liste);
        this.updateCarto(liste);
    }

    private void chargerTable(int circuit) {
        List liste = new ArrayList();
        if (circuit != -1) {
            liste = this.saisieVhService.getBarreauxVH(null, null, circuit, true);
        }
        this.remplirTable(liste);
        this.updateCarto(liste);
    }

    private void remplirTable(List<BarreauVHHisto> liste) {
        this.table.setItems(liste);
        this.recalculateColumnWidths();
        if (this.filtreEvolue == 3) {
            // empty if block
        }
    }

    @ClientCallable
    public void recalculateColumnWidths() {
        this.table.getDataProvider().refreshAll();
        this.table.recalculateColumnWidths();
    }

    private void updateCarto(List<BarreauVHHisto> barreaux) {
        HashSet<TronconSuivi> troncons = new HashSet<TronconSuivi>();
        for (BarreauVHHisto barreau : barreaux) {
            Vector xs = barreau.getXs();
            Vector ys = barreau.getYs();
            for (int i = 0; i < xs.size(); ++i) {
                TronconSuivi t = new TronconSuivi();
                t.setCode(barreau.getCch());
                float[] x = new float[((double[])xs.get(i)).length];
                float[] y = new float[((double[])ys.get(i)).length];
                for (int j = 0; j < x.length; ++j) {
                    x[j] = (float)((double[])xs.get(i))[j];
                    y[j] = (float)((double[])ys.get(i))[j];
                }
                t.setX(x);
                t.setY(y);
                troncons.add(t);
            }
        }
        this.tronconVhLayer.clearLayer();
        this.tronconVhLayer.setTronconsSuivis(troncons);
    }

    public void reinit() {
    }

    public int getActionId() {
        return 302;
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public Component getInfoComponent() {
        return this.headerInfoComponent;
    }

    public String getPath() {
        return this.getTranslation("vh.title", new Object[0]) + " > " + this.getTranslation("vh.saisieCCH.title", new Object[0]);
    }

    private String getDelegationPourSelection() {
        if (this.delegationsBox.getValue() != null) {
            return ((Delegation)this.delegationsBox.getValue()).toString();
        }
        return null;
    }

    private String getCentrePourSelection() {
        if (this.selectionBarreauxParDelegation) {
            return GLS.estVide((String)this.user.getCentre()) ? null : this.user.getCentre();
        }
        if (this.centresBox.getValue() != null) {
            return GLS.estVide((String)((Centre)this.centresBox.getValue()).toString()) ? null : ((Centre)this.centresBox.getValue()).toString();
        }
        return null;
    }

    private int getCircuitPourSelection() {
        int idCircuit = -1;
        if (this.circuitsBox.getValue() != null) {
            String circuitNom = GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString()) ? null : ((Circuit)this.circuitsBox.getValue()).toString();
            for (Circuit circuit : this.circuits) {
                if (!circuit.toString().equals(circuitNom)) continue;
                idCircuit = Integer.valueOf(circuit.getId());
            }
        }
        return idCircuit;
    }

    private void ecrireMainCourant(Vector<String> listeCommentaires) {
        if (listeCommentaires == null || listeCommentaires.size() == 0) {
            return;
        }
        MainCourante mainCourante = this.saisieVhService.getMainCourante();
        for (String comment : listeCommentaires) {
            Commentaire commentaire = MetierCommun.genereCommentaire((String)comment, (long)new Date().getTime(), null, (int)0);
            try {
                this.saisieVhService.ajoutCommentaire(mainCourante, commentaire);
            }
            catch (Exception e) {
                Log.error((Object)("Ecriture Main courante " + commentaire), (Throwable)e);
            }
        }
    }

    protected void publierCopieBarreauxVH() {
        this.saisieVhService.publierCopieBarreauxVH();
    }

    protected void publierBarreauxVH(List<BarreauVH> barreaux) {
        this.saisieVhService.publierBarreauxVH(barreaux);
        this.chargerTable();
        Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.ok", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.publieok", new Object[0])));
        notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
    }

    protected void depublierBarreauxVH(List<BarreauVH> barreaux) {
        this.saisieVhService.depublierBarreauxVH(barreaux);
        this.chargerTable();
        Notification notification = Notification.show((String)(this.getTranslation("vh.saisieCCH.message.ok", new Object[0]) + " " + this.getTranslation("vh.saisieCCH.message.depublieok", new Object[0])));
        notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
    }

    public String getMainMenu() {
        return "vh.title";
    }

    public Component getNotificationsComponent() {
        return null;
    }

    protected CheckboxGroup<ListeDestinataireMail> addField() {
        CheckboxGroup actions = new CheckboxGroup();
        actions.setSizeFull();
        List listeDestinataires = this.saisieVhService.getListeDestinataireMails();
        actions.setValue(listeDestinataires.stream().collect(Collectors.toSet()));
        return actions;
    }

    protected void interfaceChoixDestinataires() {
        Dialog win = new Dialog(this.getTranslation("vh.saisieCCH.choixdestinataires", new Object[0]));
        win.setModal(true);
        win.setResizable(false);
        win.setSizeUndefined();
        FormLayout layout = new FormLayout();
        CheckboxGroup actions = this.addField();
        layout.add(new Component[]{actions});
        win.add(new Component[]{layout});
        HorizontalLayout buttons = new HorizontalLayout();
        Button save = new Button(this.getTranslation("admin.send", new Object[0]));
        save.setWidth(100.0f, Unit.PERCENTAGE);
        buttons.add(new Component[]{save});
        Button cancel = new Button(this.getTranslation("admin.cancel", new Object[0]));
        cancel.setWidth(100.0f, Unit.PERCENTAGE);
        buttons.add(new Component[]{cancel});
        buttons.setWidth(100.0f, Unit.PERCENTAGE);
        layout.add(new Component[]{buttons});
        cancel.addClickListener((ComponentEventListener & Serializable)event -> win.close());
        save.addClickListener((ComponentEventListener & Serializable)event -> {
            try {
                Set selection = (Set)actions.getValue();
                ListeDestinataireMail listeMail = new ListeDestinataireMail();
                listeMail.setDestinataires(new ArrayList());
                for (Object actionProfil : selection) {
                    listeMail.getDestinataires().addAll(((ListeDestinataireMail)actionProfil).getDestinataires());
                }
                String urlInforoute = BusinessServiceFactory.getBusinessService().getConfiguration().getString("vh.envoimail.urlinforoute");
                StringBuffer sb = new StringBuffer();
                sb.append(this.mySynthese.getCommentaire());
                sb.append("<br>");
                sb.append("<br>");
                sb.append(urlInforoute);
                this.saisieVhService.diffusionVH(this.getTranslation("vh.mail.objet", new Object[0]), sb.toString(), listeMail);
            }
            catch (Exception e) {
                Log.error((Object)"Erreur envoi mail ", (Throwable)e);
            }
            win.close();
        });
        win.add(new Component[]{layout});
        win.setVisible(true);
    }

    public void updateTronconSuivi() {
        List barreauxVH = this.saisieVhService.getBarreauxVH(true);
        this.tronconsSuivi = this.convert(barreauxVH);
    }

    private Collection<TronconSuivi> convert(List<BarreauVH> barreauxVH) {
        Vector<TronconSuivi> troncons = new Vector<TronconSuivi>();
        Log.debug((Object)("######SuiviCC -> " + barreauxVH.size()));
        Timestamp now = new Timestamp(System.currentTimeMillis());
        for (BarreauVH barreauVH : barreauxVH) {
            if (barreauVH.getXs() == null) continue;
            Calendar cal = Calendar.getInstance();
            cal.setTime(barreauVH.getMajDate());
            if (this.DUREE_VALIDITE_VARIABLE) {
                cal.add(11, barreauVH.getDuree());
            } else {
                cal.add(11, (int)this.TIME_LIMIT_HOUR);
            }
            Vector xs = barreauVH.getXs();
            Vector ys = barreauVH.getYs();
            for (int j = 0; j < xs.size(); ++j) {
                float[] x = new float[((double[])xs.get(j)).length];
                float[] y = new float[((double[])ys.get(j)).length];
                for (int i = 0; i < ((double[])xs.get(j)).length; ++i) {
                    x[i] = (float)((double[])xs.get(j))[i];
                    y[i] = (float)((double[])ys.get(j))[i];
                }
                TronconSuivi troncon = new TronconSuivi();
                troncon.setDateFinValidite(new Timestamp(cal.getTimeInMillis()));
                if (troncon.getDateFinValidite().before(now)) {
                    troncon.setCode("NR");
                } else {
                    troncon.setCode(barreauVH.getStatus());
                }
                troncon.setIdTronconSuivi(barreauVH.getId());
                troncon.setLongueur(barreauVH.getLongueur());
                troncon.setX(x);
                troncon.setY(y);
                troncons.add(troncon);
            }
        }
        return troncons;
    }

    public Collection<TronconSuivi> getTronconsSuivi() {
        return this.tronconsSuivi;
    }

    public void addUpdateListener(SuiviVhUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void refresh() {
    }

    private void trierCircuitsCombBox() {
        this.circuitsBox.clear();
        ArrayList<Circuit> circuitsTries = new ArrayList<Circuit>();
        for (Circuit circuit : this.circuits) {
            if (circuit.getCentre() != null && !circuit.getCentre().equals("") && this.getCentrePourSelection() != null && !circuit.getCentre().equals(this.getCentrePourSelection()) && !this.getCentrePourSelection().equals("") || circuit.getDelegation() != null && !circuit.getDelegation().equals("") && this.getDelegationPourSelection() != null && !circuit.getDelegation().equals(this.getDelegationPourSelection()) && !this.getDelegationPourSelection().equals("")) continue;
            circuitsTries.add(circuit);
        }
        this.remplirComboAvecNull(this.circuitsBox, circuitsTries, (Object)this.circuitNull, this.getTranslation("mct.filtre.circuit.tous", new Object[0]));
    }

    private void remplirComboAvecNull(ComboBox combo, List liste, Object nullObject, String nullValue) {
        combo.clear();
        if (liste == null) {
            liste = new ArrayList();
        }
        List listeWithNullValue = liste.stream().collect(Collectors.toList());
        if (nullObject != null) {
            listeWithNullValue.add(nullObject);
        }
        combo.setItems(liste);
    }

    public String getPageTitle() {
        return this.getTranslation("vh.saisieCCH.title", new Object[0]);
    }
}

