/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.cch.historique.visualisation;

import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.geolocsystems.prismcentralvaadin.data.BusinessServiceFactory;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.neogls.prism.central.vaadin.view.mct.cch.saisie.SaisieCCHService;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.SuiviStyleService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PrismLayerFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.TronconVhLayer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.accordion.Accordion;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.controls.LeafletControl;
import org.vaadin.addons.componentfactory.leaflet.controls.ScaleControl;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;

@RolesAllowed(value={"ACTION_VH_CONSULTATION_HISTORIQUE_TRONCON"})
@Route(value="vh/visualisation-cch", layout=PrismLayout.class)
public class VisualisationCCH
extends Composite<VerticalLayout>
implements HasDynamicTitle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VisualisationCCH.class);
    public static int TAILLE_BOUTTON = 150;
    protected ICartoPane cartoPane = null;
    private LatLngBounds maxBounds;
    private TronconVhLayer tronconVhLayer;
    protected PrismCentralUser user;
    protected HorizontalLayout headerInfoComponent;
    protected HorizontalLayout hlFiltre;
    protected Button btVisualiser;
    protected DateTimePicker dateHistorique;
    protected Span labelHistorique;

    public VisualisationCCH(ConfigurationService configurationService, SuiviStyleService suiviStyleService, SaisieCCHService cchService, PrismLayerFactory prismLayerFactory, ClusterCartoPaneFactory clusterCartoPaneFactory) {
        this.user = cchService.getUserLogedIn();
        this.createIHM(configurationService, suiviStyleService, cchService, prismLayerFactory, clusterCartoPaneFactory);
    }

    protected void createIHM(ConfigurationService configurationService, SuiviStyleService suiviStyleService, SaisieCCHService cchService, PrismLayerFactory prismLayerFactory, ClusterCartoPaneFactory clusterCartoPaneFactory) {
        Span titre = new Span(this.getTranslation("vh.historiqueCCH.title", new Object[0]));
        titre.addClassNames(new String[]{"text-header", "p-s", "bg-base", "shadow-xs", "rounded-l"});
        ((VerticalLayout)this.getContent()).add(new Component[]{titre});
        this.hlFiltre = new HorizontalLayout();
        this.btVisualiser = new Button(this.getTranslation("vh.historiqueCCH.button.visualiser", new Object[0]));
        this.btVisualiser.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        this.btVisualiser.addClickListener((ComponentEventListener & Serializable)e -> this.visualisationHistorique());
        this.dateHistorique = new DateTimePicker(this.getTranslation("vh.historiqueCCH.datefiled.name", new Object[0]));
        this.dateHistorique.setStep(Duration.ofMinutes(1L));
        this.dateHistorique.setValue(LocalDateTime.now());
        this.dateHistorique.setDatePickerI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.labelHistorique = new Span();
        this.hlFiltre.add(new Component[]{this.dateHistorique});
        this.hlFiltre.add(new Component[]{this.btVisualiser});
        this.hlFiltre.add(new Component[]{this.labelHistorique});
        this.hlFiltre.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.btVisualiser});
        this.hlFiltre.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.labelHistorique});
        ((VerticalLayout)this.getContent()).add(new Component[]{this.hlFiltre});
        this.hlFiltre.setAlignItems(FlexComponent.Alignment.CENTER);
        this.cartoPane = clusterCartoPaneFactory.newClusterCartoPane(Integer.valueOf(cchService.getMainCourante().getCodeModuleMetier()));
        this.tronconVhLayer = prismLayerFactory.createTronconVhLayer(cchService.getMainCourante().getCodeModuleMetier());
        if (this.tronconVhLayer != null) {
            this.tronconVhLayer.addTo(this.cartoPane, "Barreaux VH");
        }
        this.cartoPane.addCartoLayer();
        prismLayerFactory.tryCreateCartoLayerSupp(cchService.getMainCourante().getCodeModuleMetier()).ifPresent(cartoLayers -> cartoLayers.forEach((layerName, layer) -> layer.addTo(this.cartoPane, layerName)));
        this.maxBounds = LeafletUtils.getMaxBounds((ConfigurationService)configurationService);
        if (this.cartoPane != null) {
            ScaleControl scaleControl = new ScaleControl();
            scaleControl.setMaxWidth(100);
            scaleControl.setPosition(LeafletControl.ControlPosition.bottomleft);
            scaleControl.addTo(this.cartoPane.getMap());
            this.cartoPane.setSizeFull();
            this.cartoPane.setWidthFull();
            this.cartoPane.setHeightFull();
            this.cartoPane.setHeight(95.0f, Unit.PERCENTAGE);
            this.cartoPane.setWidth(100.0f, Unit.PERCENTAGE);
            Accordion accordion = new Accordion();
            Image imageLegende = new Image("images/map/legend/cch/legende.png", "L\u00e9gende");
            accordion.add("L\u00e9gende", (Component)imageLegende);
            accordion.close();
            VerticalLayout layoutCarto = new VerticalLayout();
            layoutCarto.setMinWidth(100.0f, Unit.PIXELS);
            layoutCarto.setMargin(false);
            layoutCarto.setSpacing(false);
            layoutCarto.setPadding(false);
            ICartoPane iCartoPane = this.cartoPane;
            if (!(iCartoPane instanceof Component)) {
                throw new IllegalStateException("CartoPane should extends Component but %s does not".formatted(this.cartoPane.getClass().getSimpleName()));
            }
            Component cartoPaneComponent = (Component)iCartoPane;
            this.cartoPane.setSizeFull();
            layoutCarto.setSizeFull();
            layoutCarto.add(new Component[]{cartoPaneComponent, accordion});
            ((VerticalLayout)this.getContent()).add(new Component[]{layoutCarto});
            ((VerticalLayout)this.getContent()).setAlignItems(FlexComponent.Alignment.CENTER);
            ((VerticalLayout)this.getContent()).setSizeFull();
            ((VerticalLayout)this.getContent()).addClassNames(new String[]{"p-m", "box-border"});
        }
    }

    protected void visualisationHistorique() {
        Date dateHistoriqueRecherche = Date.from(((LocalDateTime)this.dateHistorique.getValue()).atZone(ZoneId.systemDefault()).toInstant());
        this.labelHistorique.setText(this.getTranslation("vh.historiqueTronconVH.date_recherche", new Object[0]) + new SimpleDateFormat("dd/MM/yyyy HH:mm").format(dateHistoriqueRecherche));
        List barreauxVH = BusinessServiceFactory.getBusinessService().getHistoriqueTronconVH(dateHistoriqueRecherche);
        this.updateCarto(barreauxVH);
    }

    private void updateCarto(List<BarreauVH> barreaux) {
        Set troncon = barreaux.stream().map(b -> {
            TronconSuivi suivi = new TronconSuivi();
            suivi.setCode(b.getCch());
            suivi.setX(b.getX());
            suivi.setY(b.getY());
            return suivi;
        }).collect(Collectors.toSet());
        this.tronconVhLayer.clearLayer();
        this.tronconVhLayer.setTronconsSuivis(troncon);
        LatLngBounds boundsLayer = this.tronconVhLayer.getLayerBounds();
        this.cartoPane.getMap().flyToBounds(boundsLayer);
    }

    public int getActionId() {
        return 318;
    }

    public String getPath() {
        return this.getTranslation("vh.title", new Object[0]) + " > " + this.getTranslation("vh.historiqueTronconVH.title", new Object[0]);
    }

    public String getPageTitle() {
        return "";
    }
}

