/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.cch.historique;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentral.beans.BarreauVHHisto;
import com.geolocsystems.prismcentral.beans.CommentaireMCIG;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.data.BusinessServiceFactory;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.cch.historique.HistoriqueSaisieCCHService;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.neogls.prism.central.vaadin.view.mct.cch.historique.ExportButtonHistoriqueSaisieCCH;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.renderer.IconRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.VaadinService;
import gls.outils.GLS;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CssImport(themeFor="vaadin-grid", value="themes/prism-theme/grid-vh.css")
@RolesAllowed(value={"ACTION_VH_HISTORIQUE_CCH_CONSULTATION"})
@Route(value="vh/cch-historique", layout=PrismLayout.class)
public class HistoriqueSaisieCCH
extends VerticalLayout {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HistoriqueSaisieCCH.class);
    private static final long serialVersionUID = 6923610040356981261L;
    public static int TAILLE_BOUTTON = 150;
    private static int TAILLE_PAGE_LENGTH_MAX = 15;
    private static int TAILLE_PAGE_LENGTH_MIN = 5;
    private long TIME_LIMIT_HOUR = 6L;
    private long TIME_LIMIT = this.TIME_LIMIT_HOUR * 60L * 60L * 1000L;
    protected static final String ENTETE_CSV = "TODO";
    private static final String ICON_PATROUILLEUR = "images/ico/patrouilleur.png";
    private static final String ICON_BUREAU = "images/ico/bureau.png";
    private static Image iconPatrouilleur = new Image("images/ico/patrouilleur.png", "PATROUILLEUR");
    private static Image iconBureau = new Image("images/ico/bureau.png", "BUREAU");
    private HorizontalLayout headerInfoComponent;
    private HorizontalLayout hlButtons;
    private HorizontalLayout hlCombo;
    private ComboBox delegationsBox;
    private ComboBox centresBox;
    private ComboBox circuitsBox;
    private Grid<BarreauVHHisto> table;
    private PrismCentralUser user;
    protected DatePicker dateDebutHistorique;
    protected DatePicker dateFinHistorique;
    private boolean selectionBarreauxParDelegation = false;
    private boolean filtrerParCircuit = false;
    private Image publishIcon;
    private List<Circuit> circuits;
    private int filtreEvolue = -1;
    private List<String> tableColumns;
    private List<String> tableAllColumns;
    protected Collection<TronconSuivi> tronconsSuivi = null;
    private HashMap<String, String> mapNomsCircuits;
    private Delegation delegationNull;
    private Centre centreNull;
    private Circuit circuitNull;
    private List<BarreauVHHisto> barreauxVhHisto = null;
    private HistoriqueSaisieCCHService historiqueSaisieCCHService;
    private ExportButtonHistoriqueSaisieCCH buttonExporter;

    public HistoriqueSaisieCCH(HistoriqueSaisieCCHService historiqueSaisieCCHService) {
        this.setSizeFull();
        this.setSpacing(true);
        this.setMargin(true);
        this.user = historiqueSaisieCCHService.getUserLogedIn();
        this.historiqueSaisieCCHService = historiqueSaisieCCHService;
        try {
            this.selectionBarreauxParDelegation = ConfigurationFactory.getInstance().getBoolean("vh.barreauxvh.delegation", true);
        }
        catch (Exception e) {
            this.selectionBarreauxParDelegation = true;
        }
        this.delegationNull = new Delegation();
        this.delegationNull.setNom("");
        this.centreNull = new Centre();
        this.centreNull.setNom("");
        this.circuitNull = new Circuit();
        this.circuitNull.setId("");
        this.filtrerParCircuit = BusinessServiceFactory.getBusinessService().getConfiguration().getBoolean("VH_BARREAUXVH_FILTRER_PAR_CIRCUIT", false);
        this.filtreEvolue = BusinessServiceFactory.getBusinessService().getConfiguration().getInt("VH_BARREAUXVH_FILTRE_EVOLUE", -1);
        this.TIME_LIMIT_HOUR = BusinessServiceFactory.getBusinessService().getConfiguration().getLong("validiteTronconVH", 6L);
        this.TIME_LIMIT = this.TIME_LIMIT_HOUR * 3600L * 1000L;
        String listeColonnes = BusinessServiceFactory.getBusinessService().getConfiguration().getString("VH_BARREAUXVH_LISTE_COLONNES");
        this.tableColumns = new ArrayList();
        this.tableAllColumns = new ArrayList();
        this.tableAllColumns.add("publie");
        this.tableAllColumns.add("circuit");
        this.tableAllColumns.add("idGroupe");
        this.tableAllColumns.add("tronconId");
        this.tableAllColumns.add("axe");
        this.tableAllColumns.add("libelle");
        this.tableAllColumns.add("cch");
        this.tableAllColumns.add("cch2");
        this.tableAllColumns.add("tendanceCC");
        this.tableAllColumns.add("meteo");
        this.tableAllColumns.add("temperature");
        this.tableAllColumns.add("vent");
        this.tableAllColumns.add("etatChaussee");
        this.tableAllColumns.add("equipements");
        this.tableAllColumns.add("traitement");
        this.tableAllColumns.add("commentaireInterne");
        this.tableAllColumns.add("commentaire");
        this.tableAllColumns.add("dureeValidite");
        this.tableAllColumns.add("majDate");
        this.tableAllColumns.add("auteur");
        this.tableAllColumns.add("source");
        if (listeColonnes != null && !listeColonnes.equals("")) {
            if (this.filtreEvolue == 3 && !listeColonnes.contains("circuit")) {
                this.tableColumns.add("circuit");
            }
            for (String colonne : listeColonnes.split(";")) {
                if (colonne.equals("historique")) continue;
                this.tableColumns.add(colonne);
            }
            if (!listeColonnes.contains("majDate")) {
                this.tableColumns.add("majDate");
            }
        } else {
            this.tableColumns = this.tableAllColumns;
        }
        this.headerInfoComponent = new HorizontalLayout();
        Span titre = new Span(this.getTranslation("vh.historiqueBarreauVH.title", new Object[0]));
        titre.addClassNames(new String[]{"text-header", "p-s", "bg-base", "shadow-xs", "rounded-l"});
        this.add(new Component[]{titre});
        this.createIHM();
    }

    private void createIHM() {
        this.createButtons();
        this.createTableau();
        this.createComboBox();
        this.add(new Component[]{this.hlCombo});
        this.add(new Component[]{this.table});
        this.setAlignItems(FlexComponent.Alignment.CENTER);
    }

    private void createButtons() {
        this.hlButtons = new HorizontalLayout();
        this.hlButtons.setSizeUndefined();
        this.hlButtons.setSpacing(true);
    }

    private void createComboBox() {
        this.hlCombo = new HorizontalLayout();
        this.hlCombo.setSizeUndefined();
        this.hlCombo.setSpacing(true);
        this.hlCombo.setMargin(true);
        this.delegationsBox = new ComboBox(this.getTranslation("global.delegation", new Object[0]));
        this.delegationsBox.setPlaceholder(this.getTranslation("mct.filtre.delegation.toutes", new Object[0]));
        this.delegationsBox.setClearButtonVisible(true);
        this.centresBox = new ComboBox(this.getTranslation("global.centre", new Object[0]));
        this.centresBox.setPlaceholder(this.getTranslation("mct.filtre.centre.tous", new Object[0]));
        this.centresBox.setClearButtonVisible(true);
        this.circuitsBox = new ComboBox(this.getTranslation("global.circuit", new Object[0]));
        this.circuitsBox.setPlaceholder(this.getTranslation("mct.filtre.circuit.tous", new Object[0]));
        this.circuitsBox.setClearButtonVisible(true);
        this.dateDebutHistorique = new DatePicker(this.getTranslation("vh.historiqueCCH.datefiled.name.debut", new Object[0]));
        this.dateDebutHistorique.setAllowedCharPattern("dd/MM/yyyy HH:mm");
        this.dateDebutHistorique.setWidth(150.0f, Unit.PIXELS);
        this.dateDebutHistorique.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.dateFinHistorique = new DatePicker(this.getTranslation("vh.historiqueCCH.datefiled.name.fin", new Object[0]));
        this.dateFinHistorique.setAllowedCharPattern("dd/MM/yyyy HH:mm");
        this.dateFinHistorique.setWidth(150.0f, Unit.PIXELS);
        this.dateFinHistorique.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        switch (this.filtreEvolue) {
            case 1: {
                this.hlCombo.add(new Component[]{this.circuitsBox});
                break;
            }
            case 2: {
                this.hlCombo.add(new Component[]{this.delegationsBox});
                if (this.selectionBarreauxParDelegation) break;
                this.hlCombo.add(new Component[]{this.centresBox});
                break;
            }
            case 3: {
                this.hlCombo.add(new Component[]{this.delegationsBox});
                if (!this.selectionBarreauxParDelegation) {
                    this.hlCombo.add(new Component[]{this.centresBox});
                }
                this.hlCombo.add(new Component[]{this.circuitsBox});
                break;
            }
            default: {
                if (this.filtrerParCircuit) {
                    this.hlCombo.add(new Component[]{this.circuitsBox});
                    break;
                }
                this.hlCombo.add(new Component[]{this.delegationsBox});
                if (this.selectionBarreauxParDelegation) break;
                this.hlCombo.add(new Component[]{this.centresBox});
            }
        }
        switch (this.filtreEvolue) {
            case 1: {
                this.circuits = BusinessServiceFactory.getBusinessService().getCircuitsVHActifs();
                this.circuitsBox.setItems((Collection)this.circuits);
                break;
            }
            case 2: {
                this.delegationsBox.setItems((Collection)BusinessServiceFactory.getBusinessService().getDelegationsActives());
                if (!GLS.estVide((String)this.user.getDelegation())) {
                    int indice = MetierCommun.getIndiceObjetListe((List)BusinessServiceFactory.getBusinessService().getDelegationsActives(), (Object)this.user.getDelegation());
                    Delegation d = (Delegation)BusinessServiceFactory.getBusinessService().getDelegationsActives().get(indice);
                    this.delegationsBox.setValue((Object)d);
                    this.delegationsBox.setEnabled(false);
                    this.centresBox.setItems((Collection)d.getCentres());
                    if (!GLS.estVide((String)this.user.getCentre())) {
                        indice = MetierCommun.getIndiceObjetListe((List)d.getCentres(), (Object)this.user.getCentre());
                        Centre c = (Centre)d.getCentres().get(indice);
                        this.centresBox.setValue((Object)c);
                        this.centresBox.setEnabled(false);
                    }
                } else {
                    this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        this.centresBox.clear();
                        if (event.getValue() != null) {
                            Delegation delegation = (Delegation)event.getValue();
                            this.centresBox.setValue((Object)delegation.getCentres());
                        }
                    });
                }
                if (!this.selectionBarreauxParDelegation) break;
                break;
            }
            case 3: {
                this.circuits = BusinessServiceFactory.getBusinessService().getCircuitsVHActifs();
                this.mapNomsCircuits = new HashMap();
                for (Circuit circuit : this.circuits) {
                    this.mapNomsCircuits.put(circuit.getId(), circuit.getNom());
                }
                this.circuitsBox.setItems((Collection)this.circuits);
                this.circuitsBox.setPlaceholder(this.getTranslation("mct.filtre.circuit.tous", new Object[0]));
                this.delegationsBox.setItems((Collection)BusinessServiceFactory.getBusinessService().getDelegationsActives());
                if (!GLS.estVide((String)this.user.getDelegation())) {
                    int indice = MetierCommun.getIndiceObjetListe((List)BusinessServiceFactory.getBusinessService().getDelegationsActives(), (Object)this.user.getDelegation());
                    Delegation d = (Delegation)BusinessServiceFactory.getBusinessService().getDelegationsActives().get(indice);
                    this.delegationsBox.setValue((Object)d);
                    this.delegationsBox.setEnabled(false);
                    this.centresBox.setItems((Collection)d.getCentres());
                    if (!GLS.estVide((String)this.user.getCentre())) {
                        indice = MetierCommun.getIndiceObjetListe((List)d.getCentres(), (Object)this.user.getCentre());
                        Centre c = (Centre)d.getCentres().get(indice);
                        this.centresBox.setValue((Object)c);
                        this.centresBox.setEnabled(false);
                    }
                } else {
                    this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        this.centresBox.clear();
                        if (event.getValue() != null) {
                            Delegation delegation = (Delegation)event.getValue();
                            if (delegation.getCentres() != null) {
                                this.centresBox.setItems((Collection)delegation.getCentres());
                            }
                        } else {
                            this.centresBox.setValue(null);
                        }
                        this.trierCircuitsCombBox();
                    });
                    this.centresBox.setValue(null);
                }
                if (this.selectionBarreauxParDelegation) {
                    this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        if (event.getValue() != null) {
                            this.trierCircuitsCombBox();
                        }
                    });
                    if (this.delegationsBox.getValue() == null) break;
                    break;
                }
                this.centresBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                    if (this.delegationsBox.getValue() != null) {
                        this.trierCircuitsCombBox();
                    }
                });
                if (this.delegationsBox.getValue() == null) break;
                break;
            }
            default: {
                if (this.filtrerParCircuit) {
                    this.circuits = BusinessServiceFactory.getBusinessService().getCircuitsVHActifs();
                    this.circuitsBox.setItems((Collection)this.circuits);
                    break;
                }
                this.delegationsBox.setItems((Collection)BusinessServiceFactory.getBusinessService().getDelegationsActives());
                if (!GLS.estVide((String)this.user.getDelegation())) {
                    int indice = MetierCommun.getIndiceObjetListe((List)BusinessServiceFactory.getBusinessService().getDelegationsActives(), (Object)this.user.getDelegation());
                    Delegation d = (Delegation)BusinessServiceFactory.getBusinessService().getDelegationsActives().get(indice);
                    this.delegationsBox.setValue((Object)d);
                    this.delegationsBox.setEnabled(false);
                    this.centresBox.setItems((Collection)d.getCentres());
                    if (!GLS.estVide((String)this.user.getCentre())) {
                        indice = MetierCommun.getIndiceObjetListe((List)d.getCentres(), (Object)this.user.getCentre());
                        Centre c = (Centre)d.getCentres().get(indice);
                        this.centresBox.setValue((Object)c);
                        this.centresBox.setEnabled(false);
                    }
                } else {
                    this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                        this.centresBox.clear();
                        if (event.getValue() != null) {
                            Delegation delegation = (Delegation)event.getValue();
                            this.centresBox.setItems((Collection)delegation.getCentres());
                        }
                    });
                }
                if (!this.selectionBarreauxParDelegation) break;
            }
        }
        this.hlCombo.add(new Component[]{this.dateDebutHistorique});
        this.hlCombo.add(new Component[]{this.dateFinHistorique});
        Button btAppliquer = new Button(this.getTranslation("vh.historiqueCCH.apply", new Object[0]));
        btAppliquer.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        btAppliquer.addClickListener((ComponentEventListener & Serializable)e -> {
            this.buttonExporter.setEnabled(true);
            this.buttonExporter.setDelegation(this.getDelegationPourSelection());
            this.buttonExporter.setCentre(this.getCentrePourSelection());
            Date dateDebut = Date.from(((LocalDate)this.dateDebutHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
            Date dateFin = null;
            dateFin = this.dateFinHistorique.getValue() == null ? new Date(dateDebut.getTime() + 86400000L) : Date.from(((LocalDate)this.dateFinHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
            this.buttonExporter.setDateDebut(dateDebut);
            this.buttonExporter.setDateFin(dateFin);
            this.buttonExporter.setMapNomsCircuits(this.mapNomsCircuits);
            this.buttonExporter.update();
            this.chargerTable();
        });
        this.buttonExporter = new ExportButtonHistoriqueSaisieCCH(this, this.historiqueSaisieCCHService.getExportFormats());
        this.buttonExporter.setEnabled(false);
        this.hlButtons.add(new Component[]{btAppliquer, this.buttonExporter});
        this.hlCombo.add(new Component[]{this.hlButtons});
        this.hlCombo.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.hlButtons});
    }

    private void createTableau() {
        this.table = new Grid();
        this.table.setWidth(100.0f, Unit.PERCENTAGE);
        this.table.setMinHeight(80.0f, Unit.PERCENTAGE);
        this.table.addThemeName("table-saisiecc");
        this.table.addComponentColumn((ValueProvider & Serializable)i -> i.isPublie() ? new Image("ico/publish.png", "alt text") : null).setHeader(this.getTranslation("vh.champ.publie", new Object[0])).setVisible(this.tableColumns.contains("publie"));
        this.table.addColumn(Troncon::getCircuit).setHeader(this.getTranslation("vh.champ.circuit", new Object[0])).setSortable(this.filtreEvolue == 3).setVisible(this.tableColumns.contains("circuit"));
        this.table.addColumn(BarreauVH::getIdGroupe).setHeader(this.getTranslation("vh.champ.idgroupe", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("idGroupe"));
        this.table.addColumn(BarreauVH::getTronconID).setHeader(this.getTranslation("vh.champ.id", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("tronconId"));
        this.table.addColumn(Troncon::getAxe).setHeader(this.getTranslation("vh.champ.axe", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("libelle"));
        this.table.addColumn(BarreauVH::getLibelle).setHeader(this.getTranslation("vh.champ.description", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("libelle"));
        this.table.addColumn(BarreauVH::getCch).setClassNameGenerator(BarreauVH::getCch).setHeader(this.getTranslation("vh.champ.cch", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("cch"));
        this.table.addColumn(BarreauVH::getCch2).setHeader(this.getTranslation("vh.champ.cch2", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("cch2"));
        this.table.addColumn(BarreauVH::getTendanceCC).setHeader(this.getTranslation("vh.champ.tendance", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("tendanceCC"));
        this.table.addColumn(BarreauVH::getMeteo).setHeader(this.getTranslation("vh.champ.meteo", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("meteo"));
        this.table.addColumn(BarreauVH::getTemperature).setHeader(this.getTranslation("vh.champ.temperature", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("temperature"));
        this.table.addColumn(BarreauVH::getVent).setHeader(this.getTranslation("vh.champ.vent", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("vent"));
        this.table.addColumn(BarreauVH::getEtatChaussee).setHeader(this.getTranslation("vh.champ.etat_chaussee", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("etatChaussee"));
        this.table.addColumn(BarreauVH::getEquipements).setHeader(this.getTranslation("vh.champ.equipements", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("equipements"));
        this.table.addColumn(BarreauVH::getTraitement).setHeader(this.getTranslation("vh.champ.traitement", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("traitement"));
        this.table.addColumn(BarreauVH::getCommentaireInterne).setHeader(this.getTranslation("vh.champ.comentaire_interne", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("commentaireInterne"));
        this.table.addColumn(BarreauVH::getCommentaire).setHeader(this.getTranslation("vh.champ.commentaire", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("commentaire"));
        this.table.addColumn(BarreauVH::getDuree).setHeader(this.getTranslation("vh.champ.duree_validite", new Object[0])).setSortable(true).setVisible(this.tableColumns.contains("dureeValidite"));
        this.table.addColumn((ValueProvider & Serializable)d -> {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            return d.getMajDate() != null ? sdf.format(d.getMajDate()) : "";
        }).setHeader(this.getTranslation("vh.champ.date", new Object[0])).setVisible(this.tableColumns.contains("majDate"));
        this.table.addColumn(BarreauVHHisto::getUtilisateur).setHeader(this.getTranslation("vh.champ.auteur", new Object[0])).setVisible(this.tableColumns.contains("auteur"));
        this.table.addComponentColumn((ValueProvider & Serializable)i -> i.getTypePoste() == 1 ? iconPatrouilleur : iconBureau).setHeader(this.getTranslation("vh.champ.source", new Object[0])).setVisible(this.tableColumns.contains("source"));
        this.table.setMultiSort(true, Grid.MultiSortPriority.APPEND);
    }

    private Renderer<CommentaireMCIG> createTypeRenderer() {
        return new IconRenderer((SerializableFunction & Serializable)commentaire -> {
            String image = commentaire.getIdTypePoste() == 2 ? ICON_BUREAU : ICON_PATROUILLEUR;
            return new Image(image, null);
        }, (ItemLabelGenerator & Serializable)item -> "");
    }

    private void chargerTable() {
        switch (this.filtreEvolue) {
            case 1: {
                this.chargerTable(this.getCircuitPourSelection());
                break;
            }
            case 2: {
                this.chargerTable(this.getDelegationPourSelection(), this.getCentrePourSelection());
                break;
            }
            case 3: {
                this.chargerTable(this.getDelegationPourSelection(), this.getCentrePourSelection(), this.getCircuitPourSelection());
                break;
            }
            default: {
                if (this.filtrerParCircuit) {
                    this.chargerTable(this.getCircuitPourSelection());
                    break;
                }
                this.chargerTable(this.getDelegationPourSelection(), this.getCentrePourSelection());
            }
        }
    }

    private void chargerTable(String delegation, String centre, int circuit) {
        Date dateDebut = Date.from(((LocalDate)this.dateDebutHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date dateFin = null;
        dateFin = this.dateFinHistorique.getValue() == null ? new Date(dateDebut.getTime() + 86400L) : Date.from(((LocalDate)this.dateFinHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        this.barreauxVhHisto = this.historiqueSaisieCCHService.getBarreauxVHHistorique(delegation, centre, circuit, true, dateDebut, dateFin);
        this.remplirTable(this.barreauxVhHisto);
    }

    private void chargerTable(String delegation, String centre) {
        Date dateDebut = Date.from(((LocalDate)this.dateDebutHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date dateFin = null;
        dateFin = this.dateFinHistorique.getValue() == null ? new Date(dateDebut.getTime() + 86400000L) : Date.from(((LocalDate)this.dateFinHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        this.barreauxVhHisto = this.historiqueSaisieCCHService.getBarreauxVHHistorique(delegation, centre, -1, true, dateDebut, dateFin);
        this.remplirTable(this.barreauxVhHisto);
    }

    private void chargerTable(int circuit) {
        if (circuit != -1) {
            Date dateDebut = Date.from(((LocalDate)this.dateDebutHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
            Date dateFin = null;
            dateFin = this.dateFinHistorique.getValue() == null ? new Date(dateDebut.getTime() + 86400000L) : Date.from(((LocalDate)this.dateFinHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
            this.barreauxVhHisto = this.historiqueSaisieCCHService.getBarreauxVHHistorique(null, null, circuit, true, dateDebut, dateFin);
        }
        this.remplirTable(this.barreauxVhHisto);
    }

    private void remplirTable(List<BarreauVHHisto> liste) {
        if (liste == null || liste.isEmpty()) {
            return;
        }
        this.table.setItems(liste);
    }

    public int getActionId() {
        return 322;
    }

    public Component getInfoComponent() {
        return this.headerInfoComponent;
    }

    public String getPath() {
        return this.getTranslation("vh.title", new Object[0]) + " > " + this.getTranslation("vh.historiqueBarreauVH.title", new Object[0]);
    }

    private String getDelegationPourSelection() {
        if (this.delegationsBox.getValue() != null) {
            return ((Delegation)this.delegationsBox.getValue()).toString();
        }
        return null;
    }

    private String getCentrePourSelection() {
        if (this.selectionBarreauxParDelegation) {
            return GLS.estVide((String)this.user.getCentre()) ? null : this.user.getCentre();
        }
        if (this.centresBox.getValue() != null) {
            return GLS.estVide((String)((Centre)this.centresBox.getValue()).toString()) ? null : ((Centre)this.centresBox.getValue()).toString();
        }
        return null;
    }

    private int getCircuitPourSelection() {
        int idCircuit = -1;
        if (this.circuitsBox.getValue() != null) {
            String circuitNom = GLS.estVide((String)((Circuit)this.circuitsBox.getValue()).toString()) ? null : ((Circuit)this.circuitsBox.getValue()).toString();
            for (Circuit circuit : this.circuits) {
                if (!circuit.toString().equals(circuitNom)) continue;
                idCircuit = Integer.valueOf(circuit.getId());
            }
        }
        return idCircuit;
    }

    public String getMainMenu() {
        return "vh.title";
    }

    public Component getNotificationsComponent() {
        return null;
    }

    private void trierCircuitsCombBox() {
        this.circuitsBox.clear();
        ArrayList<Circuit> circuitsTries = new ArrayList<Circuit>();
        for (Circuit circuit : this.circuits) {
            if (circuit.getCentre() != null && !circuit.getCentre().equals("") && this.getCentrePourSelection() != null && !circuit.getCentre().equals(this.getCentrePourSelection()) && !this.getCentrePourSelection().equals("") || circuit.getDelegation() != null && !circuit.getDelegation().equals("") && this.getDelegationPourSelection() != null && !circuit.getDelegation().equals(this.getDelegationPourSelection()) && !this.getDelegationPourSelection().equals("")) continue;
            circuitsTries.add(circuit);
        }
        this.circuitsBox.setItems(circuitsTries);
    }

    public List<BarreauVHHisto> getListPourExport() {
        return this.barreauxVhHisto;
    }

    public List<String[]> getCriteresPourExport() {
        return null;
    }

    public List<String> getFormats() {
        return null;
    }

    public String getTypeExport(String format) {
        return null;
    }

    public Map<String, Object> getParameter(String format) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("listeColumns", this.tableColumns);
        parameters.put("publie", this.getTranslation("vh.champ.publie", new Object[0]));
        parameters.put("circuit", this.getTranslation("vh.champ.circuit", new Object[0]));
        parameters.put("idGroupe", this.getTranslation("vh.champ.idgroupe", new Object[0]));
        parameters.put("tronconId", this.getTranslation("vh.champ.id", new Object[0]));
        parameters.put("axe", this.getTranslation("vh.champ.axe", new Object[0]));
        parameters.put("libelle", this.getTranslation("vh.champ.description", new Object[0]));
        parameters.put("cch", this.getTranslation("vh.champ.cch", new Object[0]));
        parameters.put("cch2", this.getTranslation("vh.champ.cch2", new Object[0]));
        parameters.put("tendanceCC", this.getTranslation("vh.champ.tendance", new Object[0]));
        parameters.put("meteo", this.getTranslation("vh.champ.meteo", new Object[0]));
        parameters.put("temperature", this.getTranslation("vh.champ.temperature", new Object[0]));
        parameters.put("vent", this.getTranslation("vh.champ.vent", new Object[0]));
        parameters.put("etatChaussee", this.getTranslation("vh.champ.etat_chaussee", new Object[0]));
        parameters.put("equipements", this.getTranslation("vh.champ.equipements", new Object[0]));
        parameters.put("traitement", this.getTranslation("vh.champ.traitement", new Object[0]));
        parameters.put("commentaireInterne", this.getTranslation("vh.champ.comentaire_interne", new Object[0]));
        parameters.put("commentaire", this.getTranslation("vh.champ.commentaire", new Object[0]));
        parameters.put("dureeValidite", this.getTranslation("vh.champ.duree_validite", new Object[0]));
        parameters.put("majDate", this.getTranslation("vh.champ.date", new Object[0]));
        parameters.put("auteur", this.getTranslation("vh.champ.auteur", new Object[0]));
        parameters.put("source", this.getTranslation("vh.champ.source", new Object[0]));
        parameters.put("patrouilleur", VaadinService.getCurrent().getResource("/VAADIN/themes/prism/ico/patrouilleur.png"));
        parameters.put("fixe", VaadinService.getCurrent().getResource("/VAADIN/themes/prism/ico/bureau.png"));
        return parameters;
    }
}

