/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.export.vh;

import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.common.component.dateinterval.DateRangePicker;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.bean.DateRange;
import com.neogls.prism.central.vaadin.service.export.vh.AnalysePatrouillesVHSearchData;
import com.neogls.prism.central.vaadin.service.export.vh.AnalysePatrouillesVHService;
import com.neogls.prism.central.vaadin.view.export.vh.AnalysePatrouillesVHExportButton;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.router.Route;
import jakarta.annotation.Nullable;
import jakarta.annotation.security.RolesAllowed;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.GregorianCalendar;

@RolesAllowed(value={"ACTION_VH_ANALYSE_PATROUILLES"})
@Route(value="/stats/rapport/rapport-analyse-patrouille-vh", layout=PrismLayout.class)
public class AnalysePatrouillesVH
extends VerticalLayout {
    private final IBusinessService businessService;
    private final UserPermissionService userPermissionService;
    private final AnalysePatrouillesVHService analysePatrouillesVHService;
    private Span errorMessage = new Span();
    private FormLayout formLayout = new FormLayout();
    private final DateRangePicker dateRange = new DateRangePicker();
    String separateur;
    private AnalysePatrouillesVHExportButton exporter;
    private final Binder<AnalysePatrouillesVHSearchData> binder = new Binder();
    private AnalysePatrouillesVHSearchData searchData;

    public AnalysePatrouillesVH(IBusinessService businessService, UserPermissionService userPermissionService, AnalysePatrouillesVHService analysePatrouilleVHService, @Nullable AnalysePatrouillesVHSearchData searchData) {
        this.businessService = businessService;
        this.userPermissionService = userPermissionService;
        this.analysePatrouillesVHService = analysePatrouilleVHService;
        this.separateur = this.businessService.getConfiguration().getString("SEPARATOR_CSV");
        if (this.separateur == null) {
            this.separateur = ";";
        }
        if (searchData == null) {
            searchData = new AnalysePatrouillesVHSearchData();
            searchData.setDateRange(new DateRange(LocalDate.now(), null));
        }
        this.initFields();
        this.initBinder();
        this.initButton();
        this.binder.readBean((Object)searchData);
        this.add(new Component[]{this.errorMessage});
        this.add(new Component[]{this.formLayout});
    }

    private void initFields() {
        this.dateRange.addValueChangeListener(arg_0 -> this.updateSearchData(arg_0));
        this.formLayout.addFormItem((Component)this.dateRange, this.getTranslation("logBook.journees", new Object[0]));
    }

    private void initBinder() {
        if (this.searchData == null) {
            this.searchData = new AnalysePatrouillesVHSearchData();
            this.searchData.setDateRange(new DateRange(LocalDate.now(), null));
        }
        this.binder.forField((HasValue)this.dateRange).asRequired().bind(AnalysePatrouillesVHSearchData::getDateRange, AnalysePatrouillesVHSearchData::setDateRange);
    }

    private void initButton() {
        this.exporter = new AnalysePatrouillesVHExportButton(this.searchData, this.analysePatrouillesVHService.getExportFormats());
        this.updateSearchData(null);
        this.formLayout.add(new Component[]{this.exporter});
    }

    private void createForm() {
    }

    private void update() {
        Log.debug((Object)"export update");
    }

    private <V> void updateSearchData(AbstractField.ComponentValueChangeEvent<?, V> event) {
        if (this.searchData != null) {
            if (this.binder.writeBeanIfValid((Object)this.searchData)) {
                this.testErreur();
            }
            if (this.exporter != null) {
                this.exporter.updateURL(this.searchData);
            }
        }
    }

    private boolean testErreur() {
        if (this.searchData.getDateRange().getBeginning() == null) {
            this.errorMessage.setText(this.getTranslation("rapport.date.debut.vide.error", new Object[0]));
            return true;
        }
        if (this.searchData.getDateRange().getEnd() != null && new Timestamp(GregorianCalendar.from(this.searchData.getDateRange().getEnd().atStartOfDay(ZoneId.systemDefault())).getTime().getTime()).before(new Timestamp(GregorianCalendar.from(this.searchData.getDateRange().getBeginning().atStartOfDay(ZoneId.systemDefault())).getTime().getTime()))) {
            this.errorMessage.setText(this.getTranslation("rapport.date.fin.error", new Object[0]));
            return true;
        }
        this.errorMessage.setText("");
        return false;
    }
}

