/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.export.logbook;

import com.geolocsystems.prismcentral.beans.CommentaireMCIG;
import com.geolocsystems.prismcentral.beans.MCIG;
import com.neogls.prism.central.vaadin.rest.logbook.patrolimage.LogBookPatrolImageController;
import com.neogls.prism.central.vaadin.service.logbook.LogBookService;
import com.neogls.prism.central.vaadin.view.export.logbook.LogBookDialog;
import com.neogls.prism.central.vaadin.view.export.logbook.LogBookExportButton;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogFactory;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.IconRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogBookViewer
extends Composite<VerticalLayout>
implements HasSize {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogBookViewer.class);
    private final MCIG mcig;
    private final LogBookService logBookService;
    private final EventSheetDialogFactory eventSheetDialogFactory;
    private static final String ICON_PATROUILLEUR = "images/ico/patrouilleur.png";
    private static final String ICON_BUREAU = "images/ico/bureau.png";

    public LogBookViewer(MCIG mcig, LogBookService logBookService, EventSheetDialogFactory eventSheetDialogFactory) {
        this.mcig = mcig;
        this.logBookService = logBookService;
        this.eventSheetDialogFactory = eventSheetDialogFactory;
        Grid grid = new Grid();
        grid.addColumn(CommentaireMCIG::getDateHeureCom).setHeader(this.getTranslation("logBook.date", new Object[0])).setFlexGrow(2);
        grid.addColumn(this.createTypeRenderer()).setFlexGrow(0);
        grid.addColumn(CommentaireMCIG::getNom).setHeader(this.getTranslation("logBook.emetteur", new Object[0])).setFlexGrow(2);
        grid.addColumn(CommentaireMCIG::getEquipier).setHeader("Equipier");
        grid.addColumn(this.getCommentaireRenderer()).setHeader(this.getTranslation("logBook.commentaire", new Object[0])).setFlexGrow(10);
        grid.addColumn(this.createViewButtonRenderer()).setFlexGrow(0).setAutoWidth(true);
        grid.setSelectionMode(Grid.SelectionMode.NONE);
        grid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_ROW_STRIPES, GridVariant.LUMO_COMPACT, GridVariant.LUMO_WRAP_CELL_CONTENT});
        grid.addClassName("text-xs");
        grid.setAllRowsVisible(true);
        grid.setItems((Collection)mcig.getCommentaireMcig());
        VerticalLayout layout = (VerticalLayout)this.getContent();
        if (mcig.getMcigId() != null) {
            LogBookExportButton exportButton = new LogBookExportButton(mcig, logBookService.getExportFormats());
            layout.add(new Component[]{exportButton});
        }
        layout.add(new Component[]{grid});
        if (logBookService.canShowPatrolImage()) {
            layout.add(new Component[]{new Image(LogBookPatrolImageController.Helper.createLogBookPatrolImageURL((MCIG)mcig), "")});
        }
        layout.setPadding(false);
        layout.setAlignItems(FlexComponent.Alignment.CENTER);
    }

    private Renderer<CommentaireMCIG> createTypeRenderer() {
        return new IconRenderer((SerializableFunction & Serializable)commentaire -> {
            String image = commentaire.getIdTypePoste() == 2 ? ICON_BUREAU : ICON_PATROUILLEUR;
            return new Image(image, null);
        }, (ItemLabelGenerator & Serializable)item -> "");
    }

    private Renderer<CommentaireMCIG> getCommentaireRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)item -> new Html("<div>" + Arrays.stream(item.getPhrComMcig().split(String.valueOf('\u00a7'))).map(arg_0 -> this.parseAddition(arg_0)).map(arg_0 -> this.parseDeletion(arg_0)).map(arg_0 -> this.parseModification(arg_0)).map(arg_0 -> this.parseLineFeed(arg_0)).collect(Collectors.joining("<br/>")) + "</div>"));
    }

    private String parseAddition(String line) {
        return line.startsWith("(+)") ? "<b>" + line.substring(3) + "</b>" : line;
    }

    private String parseDeletion(String line) {
        return line.startsWith("(-)") ? "<strike><b>" + line.substring(3) + "</b></strike>" : line;
    }

    private String parseModification(String line) {
        return line.startsWith("(*)") ? "<u><b>" + line.substring(3) + "</b></u>" : line;
    }

    private String parseLineFeed(String line) {
        return line.replace("\r", "").replace("\n", "<br/>");
    }

    private Renderer<CommentaireMCIG> createViewButtonRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)item -> {
            Icon buttonIcon = VaadinIcon.EYE.create();
            buttonIcon.setColor("var(--lumo-contrast)");
            if ((item.getPhrComMcig().equals("Prise de service") || item.getPhrComMcig().equals("Reprise de service")) && item.getMcigId() != null && !item.getMcigId().equals(this.mcig.getMcigId())) {
                Button viewLogBookButton = new Button((Component)buttonIcon, (ComponentEventListener & Serializable)event -> this.openLogBookDialog(item.getMcigId()));
                viewLogBookButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
                viewLogBookButton.setTooltipText(this.getTranslation("logBook.lien.maincourante", new Object[0]));
                return viewLogBookButton;
            }
            if (item.getIdEvenement() != -1L) {
                Button viewEventButton = new Button((Component)buttonIcon, (ComponentEventListener & Serializable)event -> this.openEventSheetDialog((int)item.getIdEvenement()));
                viewEventButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
                viewEventButton.setTooltipText(this.getTranslation("logBook.lien", new Object[0]));
                return viewEventButton;
            }
            return new Text("");
        });
    }

    private void openLogBookDialog(String mcigId) {
        this.logBookService.findMcigById(mcigId).ifPresentOrElse(mcig -> new LogBookDialog(mcig, this.logBookService, this.eventSheetDialogFactory).open(), () -> {});
    }

    private void openEventSheetDialog(int eventId) {
        this.eventSheetDialogFactory.createFromEventId(eventId, true).ifPresentOrElse(Dialog::open, () -> {
            log.error("Couldn't find the event with id = {}", (Object)eventId);
            Notification.show((String)"Ev\u00e9nement introuvable").addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
        });
    }
}

