/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.export.logbook;

import com.geolocsystems.prismcentral.beans.MCIG;
import com.neogls.prism.central.vaadin.common.component.PrismPaginator;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.logbook.LogBookService;
import com.neogls.prism.central.vaadin.view.export.logbook.LogBookSearchForm;
import com.neogls.prism.central.vaadin.view.export.logbook.LogBookViewer;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogFactory;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.List;

@RolesAllowed(value={"ACTION_VISUALISATION_MAIN_COURANTE"})
@Route(value="/log-book-search", layout=PrismLayout.class)
public class LogBookSearchView
extends VerticalLayout
implements HasDynamicTitle {
    private final PrismPaginator<MCIG> paginator;
    private final LogBookService logBookService;

    public LogBookSearchView(LogBookService logBookService, EventSheetDialogFactory eventSheetDialogFactory) {
        this.logBookService = logBookService;
        LogBookSearchForm form = new LogBookSearchForm(logBookService, null);
        form.setWidth(52.0f, Unit.EM);
        form.addClassName("mx-auto");
        this.paginator = new PrismPaginator(new ComponentRenderer((SerializableFunction & Serializable)mcig -> {
            LogBookViewer viewer = new LogBookViewer(mcig, logBookService, eventSheetDialogFactory);
            viewer.setSizeFull();
            return viewer;
        }));
        this.add(new Component[]{form, this.paginator});
        this.setFlexGrow(1.0, new HasElement[]{this.paginator});
        form.addFormValidatedListener(arg_0 -> this.onFormValidated(arg_0));
        this.setSizeFull();
        this.setAlignItems(FlexComponent.Alignment.STRETCH);
    }

    private void onFormValidated(LogBookSearchForm.FormValidatedEvent event) {
        List mcigList = this.logBookService.getMCIG(event.getSearchData());
        mcigList.forEach(mcig -> mcig.setMcigId(null));
        this.paginator.setItems(mcigList);
    }

    public String getPageTitle() {
        return this.getTranslation("logBook.title", new Object[0]);
    }
}

