/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.export.logbook;

import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Profil;
import com.neogls.prism.central.vaadin.common.component.dateinterval.DateRangePicker;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenter;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterField;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterFieldThemeVariant;
import com.neogls.prism.central.vaadin.service.bean.DateRange;
import com.neogls.prism.central.vaadin.service.logbook.LogBookSearchData;
import com.neogls.prism.central.vaadin.service.logbook.LogBookService;
import com.neogls.prism.central.vaadin.view.export.logbook.LogBookSearchForm;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.function.SerializablePredicate;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogBookSearchForm
extends FormLayout {
    private final DelegationAndCenterField delegationAndCenterField;
    private final ComboBox<String> cbAxe = new ComboBox();
    private final ComboBox<Profil> cbProfile = new ComboBox(arg_0 -> this.reloadUsers(arg_0));
    private final ComboBox<PrismCentralUser> cbUser = new ComboBox();
    private final Checkbox checkboxArchivedUsers = new Checkbox(this.getTranslation("logbook.emetteur.archive", new Object[0]), arg_0 -> this.reloadUsers(arg_0));
    private final DateRangePicker dateRange = new DateRangePicker();
    private final ComboBox<LogBookLevel> cbLevel = new ComboBox();
    private final Binder<LogBookSearchData> binder = new Binder();
    private final LogBookService service;

    public LogBookSearchForm(LogBookService service, @Nullable LogBookSearchData searchData) {
        this.service = service;
        Button bOk = new Button(this.getTranslation("logBook.ok", new Object[0]), arg_0 -> this.onOkButtonClick(arg_0));
        this.delegationAndCenterField = new DelegationAndCenterField((Collection)service.getDelegationsActives(), arg_0 -> this.reloadUsers(arg_0));
        this.initFields();
        this.initBinder();
        this.add(new Component[]{this.delegationAndCenterField});
        this.addFormItem((Component)this.cbAxe, this.getTranslation("global.axe", new Object[0]));
        this.addFormItem((Component)this.cbProfile, this.getTranslation("logBook.profil", new Object[0]));
        this.addFormItem((Component)this.cbUser, this.getTranslation("logBook.emetteur", new Object[0]));
        this.addFormItem((Component)this.checkboxArchivedUsers, (String)null);
        this.addFormItem((Component)this.dateRange, this.getTranslation("logBook.journees", new Object[0]));
        this.addFormItem((Component)this.cbLevel, this.getTranslation("logBook.niveau", new Object[0]));
        this.addFormItem((Component)new Div(new Component[]{bOk}), (String)null);
        this.setColspan((Component)this.delegationAndCenterField, 2);
        this.checkboxArchivedUsers.addClassName("pt-s");
        bOk.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 2, FormLayout.ResponsiveStep.LabelsPosition.TOP)});
        this.getStyle().set("--vaadin-form-layout-column-spacing", "var(--lumo-space-s)").set("--vaadin-form-item-row-spacing", "0").set("--vaadin-form-item-label-spacing", "0");
        if (searchData == null) {
            searchData = new LogBookSearchData();
            searchData.setDateRange(new DateRange(LocalDate.now(), null));
            searchData.setLevel(Integer.valueOf(0));
        }
        this.binder.readBean((Object)searchData);
    }

    private void initFields() {
        this.delegationAndCenterField.setDelegationPlaceholder(this.getTranslation("mct.filtre.delegation.toutes", new Object[0]));
        this.delegationAndCenterField.setCenterPlaceholder(this.getTranslation("mct.filtre.centre.tous", new Object[0]));
        this.delegationAndCenterField.addThemeVariants((ThemeVariant[])new DelegationAndCenterFieldThemeVariant[]{DelegationAndCenterFieldThemeVariant.HORIZONTAL});
        this.cbAxe.setPlaceholder(this.getTranslation("logBook.axe.tous", new Object[0]));
        this.cbAxe.setClearButtonVisible(true);
        this.cbProfile.setPlaceholder(this.getTranslation("logBook.profil.tous", new Object[0]));
        this.cbProfile.setClearButtonVisible(true);
        this.cbProfile.setItemLabelGenerator(Profil::getName);
        this.cbProfile.addClassName("readonly-placeholder-visible");
        this.cbUser.setPlaceholder(this.getTranslation("logBook.emetteur.tous", new Object[0]));
        this.cbUser.setClearButtonVisible(true);
        this.cbUser.setItemLabelGenerator(PrismCentralUser::getNom);
        this.cbUser.addClassName("readonly-placeholder-visible");
        this.dateRange.setClearButtonVisible(true);
        this.cbLevel.setItemLabelGenerator((ItemLabelGenerator & Serializable)level -> this.getTranslation(level.getI18nKey(), new Object[0]));
        List users = this.service.getUsers();
        List profiles = this.service.getProfiles((Collection)users);
        this.cbAxe.setItems((Collection)this.service.getAxes());
        this.cbProfile.setItems((Collection)profiles);
        this.cbUser.setItems((Collection)users).addFilter((SerializablePredicate & Serializable)prismCentralUser -> !prismCentralUser.isArchive() || (Boolean)this.checkboxArchivedUsers.getValue() != false).addFilter(arg_0 -> this.filterDelegation(arg_0)).addFilter(arg_0 -> this.filterCentre(arg_0)).addFilter(arg_0 -> this.filterProfile(arg_0));
        this.cbLevel.setItems((Object[])LogBookLevel.values());
        if (profiles.isEmpty()) {
            this.cbProfile.setReadOnly(true);
            this.cbProfile.setPlaceholder(this.getTranslation("logBook.profil.aucun", new Object[0]));
        }
    }

    private boolean filterDelegation(PrismCentralUser user) {
        return this.delegationAndCenterField.isEmpty() || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getDelegation() == null || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getDelegation().equals(user.getDelegation());
    }

    private boolean filterCentre(PrismCentralUser user) {
        return this.delegationAndCenterField.isEmpty() || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getCenter() == null || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getCenter().equals(user.getCentre());
    }

    private boolean filterProfile(PrismCentralUser user) {
        return this.cbProfile.isEmpty() || ((Profil)this.cbProfile.getValue()).getId() == -1 || (long)((Profil)this.cbProfile.getValue()).getId() == user.getIdProfil();
    }

    private void initBinder() {
        this.binder.bind((HasValue)this.delegationAndCenterField, DelegationAndCenterField.createGetter(LogBookSearchData::getDelegation, LogBookSearchData::getCenter), DelegationAndCenterField.createSetter(LogBookSearchData::setDelegation, LogBookSearchData::setCenter));
        this.binder.bind((HasValue)this.cbAxe, LogBookSearchData::getAxe, LogBookSearchData::setAxe);
        this.binder.bind((HasValue)this.cbProfile, LogBookSearchData::getProfile, LogBookSearchData::setProfile);
        this.binder.bind((HasValue)this.cbUser, LogBookSearchData::getUser, LogBookSearchData::setUser);
        this.binder.forField((HasValue)this.dateRange).asRequired().bind(LogBookSearchData::getDateRange, LogBookSearchData::setDateRange);
        this.binder.forField((HasValue)this.cbLevel).asRequired().withConverter(LogBookLevel::getValue, LogBookLevel::fromValue).bind(LogBookSearchData::getLevel, LogBookSearchData::setLevel);
    }

    private <V> void reloadUsers(AbstractField.ComponentValueChangeEvent<?, V> event) {
        this.cbUser.clear();
        this.cbUser.getDataProvider().refreshAll();
        boolean cbUserEmpty = this.cbUser.getListDataView().getItemCount() == 0;
        this.cbUser.setPlaceholder(cbUserEmpty ? this.getTranslation("logBook.emetteur.aucun", new Object[0]) : this.getTranslation("logBook.emetteur.tous", new Object[0]));
        this.cbUser.setReadOnly(cbUserEmpty);
    }

    private void onOkButtonClick(ClickEvent<Button> event) {
        LogBookSearchData searchData = new LogBookSearchData();
        if (this.binder.writeBeanIfValid((Object)searchData)) {
            this.fireEvent((ComponentEvent)new FormValidatedEvent(this, event.isFromClient(), searchData));
        }
    }

    public void addFormValidatedListener(ComponentEventListener<FormValidatedEvent> listener) {
        this.addListener(FormValidatedEvent.class, listener);
    }
}

