/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.vehicletype;

import com.geolocsystems.prismcentral.beans.MarqueVehicule;
import com.geolocsystems.prismcentral.beans.TypesMarques;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.rest.patrolicon.PatrolIconController;
import com.neogls.prism.central.vaadin.service.VehicleTypeService;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.vehicletype.VehicleTypeAdminEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.data.renderer.IconRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import lombok.Generated;

@RolesAllowed(value={"ACTION_ADMIN_VEHICULES"})
@Route(value="admin/vehicle-type", layout=PrismLayout.class)
public class VehicleTypeAdminView
extends AbstractAdminView<MarqueVehicule> {
    private final VehicleTypeService vehicleTypeService;

    protected void init() {
        this.grid.addColumn(this.createTypeRenderer()).setHeader(this.createTypeHeader()).setFlexGrow(0).setAutoWidth(true);
        this.grid.addColumn(MarqueVehicule::getNom).setHeader(this.getTranslation("admin.marque.head.nom", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)marqueVehicule -> ((TypesMarques)this.vehicleTypeService.getVehicleTypeCategoryById(marqueVehicule.getType()).orElseThrow()).getLabel()).setHeader(this.getTranslation("admin.marque.head.type", new Object[0]));
    }

    private Component createTypeHeader() {
        Image image = new Image("images/menu/vehicules_type.png", null);
        FlexLayout container = new FlexLayout(new Component[]{image});
        container.setAlignContent(FlexLayout.ContentAlignment.CENTER);
        container.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        return container;
    }

    private Renderer<MarqueVehicule> createTypeRenderer() {
        return new IconRenderer((SerializableFunction & Serializable)marqueVehicule -> new Image(PatrolIconController.Helper.createVehicleTypeIconURL((int)marqueVehicule.getIcone()), null), (ItemLabelGenerator & Serializable)item -> "");
    }

    protected Collection<MarqueVehicule> refreshItems() {
        return this.vehicleTypeService.getVehicleTypes();
    }

    protected void createItem(SaveEvent<MarqueVehicule> saveEvent) {
        this.vehicleTypeService.createVehicleType((MarqueVehicule)saveEvent.getValue());
    }

    protected void updateItem(SaveEvent<MarqueVehicule> saveEvent) {
        this.vehicleTypeService.updateVehicleType((MarqueVehicule)saveEvent.getValue());
    }

    protected void deleteItem(MarqueVehicule item) {
        throw new UnsupportedOperationException("A vehicle type cannot be deleted.");
    }

    protected AbstractAdminEditDialog<MarqueVehicule> createEditDialog(MarqueVehicule item) {
        return new VehicleTypeAdminEditDialog(item, this.vehicleTypeService);
    }

    protected boolean isDeletable(MarqueVehicule item) {
        return false;
    }

    public String getPageTitle() {
        return this.getTranslation("admin.marque.title", new Object[0]);
    }

    @Generated
    public VehicleTypeAdminView(VehicleTypeService vehicleTypeService) {
        this.vehicleTypeService = vehicleTypeService;
    }
}

