/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.vehicletype;

import com.geolocsystems.prismcentral.beans.MarqueVehicule;
import com.geolocsystems.prismcentral.beans.TypesMarques;
import com.neogls.prism.central.vaadin.rest.patrolicon.PatrolIconController;
import com.neogls.prism.central.vaadin.service.VehicleTypeService;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.List;

public class VehicleTypeAdminEditDialog
extends AbstractAdminEditDialog<MarqueVehicule> {
    private final TextField name = new TextField();
    private final TextField description = new TextField();
    private final ComboBox<TypesMarques> category = new ComboBox();
    private final IntegerField iconCode = new IntegerField();
    private final Image icon = new Image();
    private final FormLayout content = new FormLayout();
    private final Binder<MarqueVehicule> binder = new Binder();
    private final VehicleTypeService vehicleTypeService;

    VehicleTypeAdminEditDialog(MarqueVehicule oldItem, VehicleTypeService vehicleTypeService) {
        super((Object)oldItem);
        this.vehicleTypeService = vehicleTypeService;
        this.configureFields();
        this.add(new Component[]{this.content});
        this.configureBinder();
        this.binder.readBean((Object)oldItem);
    }

    private void configureFields() {
        this.category.setItems(this.vehicleTypeService.getVehicleTypeCategories());
        this.category.setItemLabelGenerator(TypesMarques::getLabel);
        this.iconCode.setValueChangeMode(ValueChangeMode.EAGER);
        this.iconCode.setStepButtonsVisible(true);
        this.iconCode.setMin(0);
        this.iconCode.setMax(50);
        this.content.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        this.content.setMaxWidth(30.0f, Unit.EM);
        this.content.getStyle().set("--vaadin-form-item-label-width", "10em");
        this.content.addFormItem((Component)this.name, this.getTranslation("admin.marque.nom", new Object[0]));
        this.content.addFormItem((Component)this.description, this.getTranslation("admin.marque.description", new Object[0]));
        this.content.addFormItem((Component)this.category, this.getTranslation("admin.marque.type", new Object[0]));
        this.content.addFormItem((Component)this.iconCode, this.getTranslation("admin.marque.icon", new Object[0]));
        FlexLayout iconContainer = new FlexLayout(new Component[]{this.icon});
        iconContainer.setAlignContent(FlexLayout.ContentAlignment.CENTER);
        iconContainer.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        this.content.addFormItem((Component)iconContainer, "");
        this.iconCode.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.icon.setSrc(this.iconCode.isEmpty() ? "" : PatrolIconController.Helper.createVehicleTypeIconURL((int)((Integer)event.getValue()))));
    }

    private void configureBinder() {
        this.binder.forField((HasValue)this.name).asRequired(this.getTranslation("admin.marque.error.nom", new Object[0])).bind(MarqueVehicule::getNom, MarqueVehicule::setNom);
        this.binder.bind((HasValue)this.description, MarqueVehicule::getDescription, MarqueVehicule::setDescription);
        this.binder.forField((HasValue)this.category).asRequired(this.getTranslation("admin.marque.error.type", new Object[0])).withConverter(TypesMarques::getCode, (SerializableFunction & Serializable)categoryId -> (TypesMarques)this.vehicleTypeService.getVehicleTypeCategoryById(categoryId.intValue()).orElseThrow()).bind(MarqueVehicule::getType, MarqueVehicule::setType);
        this.binder.forField((HasValue)this.iconCode).asRequired(this.getTranslation("admin.marque.error.icon", new Object[0])).bind(MarqueVehicule::getIcone, MarqueVehicule::setIcone);
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.marque.create", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.marque.edit", new Object[0]);
    }

    protected MarqueVehicule getValue() throws ValidationException {
        MarqueVehicule value = this.isEdition() ? (MarqueVehicule)this.oldItem : new MarqueVehicule();
        this.binder.writeBean((Object)value);
        return value;
    }
}

