/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.vehicle;

import com.geolocsystems.prismandroid.model.Vehicule;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.VehicleService;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.vehicle.VehicleAdminEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import gls.outils.ConstantesGLS;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import lombok.Generated;

@RolesAllowed(value={"ACTION_ADMIN_VEHICULES"})
@Route(value="admin/vehicle", layout=PrismLayout.class)
public class VehicleAdminView
extends AbstractAdminView<Vehicule> {
    private final VehicleService vehicleService;
    private String filterValue = "";
    private boolean showArchived = false;

    protected void init() {
        this.beforeControls.add(new Component[]{new Checkbox(this.getTranslation("admin.vehicle.checkbox.archives", new Object[0]), arg_0 -> this.onShowArchivedChange(arg_0))});
        this.grid.addColumn(Vehicule::getCode).setHeader(this.getTranslation("admin.vehicle.head.code", new Object[0])).setSortable(true);
        this.grid.addColumn(Vehicule::getImmatriculation).setHeader(this.getTranslation("admin.vehicle.head.immat", new Object[0])).setSortable(true);
        this.grid.addColumn(Vehicule::getDelegation).setHeader(this.getTranslation("global.delegation", new Object[0])).setSortable(true);
        this.grid.addColumn(Vehicule::getCentre).setHeader(this.getTranslation("global.centre", new Object[0])).setSortable(true);
        this.grid.addColumn((ValueProvider & Serializable)vehicle -> vehicle.isArchive() ? this.getTranslation("Global.Yes", new Object[0]) : null).setHeader(this.getTranslation("admin.vehicle.head.archive", new Object[0])).setSortable(true);
    }

    private void onShowArchivedChange(HasValue.ValueChangeEvent<Boolean> event) {
        this.showArchived = (Boolean)event.getValue();
        this.grid.getDataProvider().refreshAll();
    }

    protected Collection<Vehicule> refreshItems() {
        return this.vehicleService.getVehicles();
    }

    protected void createItem(SaveEvent<Vehicule> saveEvent) {
        this.vehicleService.createVehicle((Vehicule)saveEvent.getValue());
    }

    protected void updateItem(SaveEvent<Vehicule> saveEvent) {
        this.vehicleService.updateVehicle((Vehicule)saveEvent.getValue());
    }

    protected void deleteItem(Vehicule item) {
        throw new UnsupportedOperationException("A vehicle cannot be deleted.");
    }

    protected AbstractAdminEditDialog<Vehicule> createEditDialog(Vehicule item) {
        return new VehicleAdminEditDialog(item, this.vehicleService);
    }

    protected boolean isDeletable(Vehicule item) {
        return false;
    }

    protected boolean hasFilter() {
        return true;
    }

    protected void onFilterValueChange(String filterValue) {
        this.filterValue = filterValue.toLowerCase();
    }

    protected boolean filter(Vehicule item) {
        return this.filterArchived(item) && this.filterValue(item);
    }

    private boolean filterArchived(Vehicule item) {
        return !item.isArchive() || this.showArchived;
    }

    private boolean filterValue(Vehicule item) {
        return item.getCode().toLowerCase().contains(this.filterValue) || !ConstantesGLS.estVide((String)item.getImmatriculation()) && item.getImmatriculation().toLowerCase().contains(this.filterValue) || !ConstantesGLS.estVide((String)item.getDelegation()) && item.getDelegation().toLowerCase().contains(this.filterValue) || !ConstantesGLS.estVide((String)item.getCentre()) && item.getCentre().toLowerCase().contains(this.filterValue);
    }

    protected String getFilterPlaceholder() {
        return this.getTranslation("admin.vehicle.search", new Object[0]);
    }

    public String getPageTitle() {
        return this.getTranslation("admin.vehicle.title", new Object[0]);
    }

    @Generated
    public VehicleAdminView(VehicleService vehicleService) {
        this.vehicleService = vehicleService;
    }
}

