/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.vehicle;

import com.geolocsystems.prismandroid.model.Vehicule;
import com.geolocsystems.prismcentral.beans.MarqueVehicule;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterField;
import com.neogls.prism.central.vaadin.service.VehicleService;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import java.util.List;
import java.util.Map;

public class VehicleAdminEditDialog
extends AbstractAdminEditDialog<Vehicule> {
    private final TextField code = new TextField();
    private final TextField immat = new TextField();
    private final TextField description = new TextField();
    private final TextField telephone = new TextField();
    private final TextField radio = new TextField();
    private final DelegationAndCenterField delegationAndCenter;
    private final ComboBox<MarqueVehicule> type = new ComboBox();
    private final Checkbox archive = new Checkbox();
    private final Binder<Vehicule> binder = new Binder();
    private final Map<Integer, MarqueVehicule> vehicleTypesById;

    VehicleAdminEditDialog(Vehicule oldItem, VehicleService vehicleService) {
        super((Object)oldItem);
        this.vehicleTypesById = Maps.uniqueIndex((Iterable)vehicleService.getVehicleTypes(), MarqueVehicule::getId);
        this.delegationAndCenter = new DelegationAndCenterField(vehicleService.getActiveDelegations());
        this.delegationAndCenter.setLabelsVisible(false);
        this.type.setItems(this.vehicleTypesById.values());
        this.type.setItemLabelGenerator(MarqueVehicule::getNom);
        FormLayout content = new FormLayout();
        content.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        content.setMaxWidth(30.0f, Unit.EM);
        content.getStyle().set("--vaadin-form-item-label-width", "10em");
        content.addFormItem((Component)this.code, this.getTranslation("admin.vehicle.code", new Object[0]));
        content.addFormItem((Component)this.immat, this.getTranslation("admin.vehicle.immat", new Object[0]));
        content.addFormItem((Component)this.description, this.getTranslation("admin.vehicle.description", new Object[0]));
        content.addFormItem((Component)this.telephone, this.getTranslation("admin.vehicle.phone", new Object[0]));
        content.addFormItem((Component)this.radio, this.getTranslation("admin.vehicle.radio", new Object[0]));
        content.addFormItem((Component)this.delegationAndCenter, this.getTranslation("global.delegation", new Object[0]) + " & " + this.getTranslation("global.centre", new Object[0]));
        content.addFormItem((Component)this.type, this.getTranslation("admin.vehicle.type", new Object[0]));
        content.addFormItem((Component)this.archive, this.getTranslation("admin.vehicle.isarchive", new Object[0]));
        this.add(new Component[]{content});
        this.configureBinder();
        this.binder.readBean((Object)oldItem);
    }

    private void configureBinder() {
        this.binder.forField((HasValue)this.code).asRequired(this.getTranslation("admin.vehicle.error.code", new Object[0])).bind(Vehicule::getCode, Vehicule::setCode).setReadOnly(this.isEdition());
        this.binder.bind((HasValue)this.immat, Vehicule::getImmatriculation, Vehicule::setImmatriculation);
        this.binder.bind((HasValue)this.description, Vehicule::getDescription, Vehicule::setDescription);
        this.binder.bind((HasValue)this.telephone, Vehicule::getNumeroTelephone, Vehicule::setNumeroTelephone);
        this.binder.bind((HasValue)this.radio, Vehicule::getNumeroRadio, Vehicule::setNumeroRadio);
        this.binder.bind((HasValue)this.delegationAndCenter, DelegationAndCenterField.createGetter(Vehicule::getDelegation, Vehicule::getCentre), DelegationAndCenterField.createSetter(Vehicule::setDelegation, Vehicule::setCentre));
        this.binder.forField((HasValue)this.type).asRequired(this.getTranslation("admin.vehicle.error.type", new Object[0])).withConverter(MarqueVehicule::getId, this.vehicleTypesById::get).bind(Vehicule::getType, Vehicule::setType);
        this.binder.bind((HasValue)this.archive, Vehicule::isArchive, Vehicule::setArchive);
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.vehicle.create", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.vehicle.edit", new Object[0]);
    }

    protected Vehicule getValue() throws ValidationException {
        Vehicule value = this.isEdition() ? (Vehicule)this.oldItem : new Vehicule();
        this.binder.writeBean((Object)value);
        return value;
    }
}

