/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.user;

import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.bean.UserVaadinBean;
import com.neogls.prism.central.vaadin.service.mapper.UserVaadinBeanMapper;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.user.UserAdminEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import gls.outils.ConstantesGLS;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import lombok.Generated;

@RolesAllowed(value={"ACTION_ADMIN_UTILISATEURS"})
@Route(value="admin/user", layout=PrismLayout.class)
public class UserAdminView
extends AbstractAdminView<UserVaadinBean> {
    private final IBusinessService businessService;
    private final UserPermissionService userPermissionService;
    private String filterValue = "";
    private boolean showArchived = false;

    protected void init() {
        this.beforeControls.add(new Component[]{new Checkbox(this.getTranslation("admin.user.checkbox.archives", new Object[0]), arg_0 -> this.onShowArchivedChange(arg_0))});
        this.grid.addColumn(UserVaadinBean::getCode).setHeader(this.getTranslation("admin.user.head.id", new Object[0])).setSortable(true);
        this.grid.addColumn(UserVaadinBean::getNom).setHeader(this.getTranslation("admin.user.head.nom", new Object[0])).setSortable(true);
        this.grid.addColumn(UserVaadinBean::getDelegation).setHeader(this.getTranslation("global.delegation", new Object[0])).setSortable(true);
        this.grid.addColumn(UserVaadinBean::getCentre).setHeader(this.getTranslation("global.centre", new Object[0])).setSortable(true);
        this.grid.addColumn((ValueProvider & Serializable)user -> user.getProfil().getName()).setHeader(this.getTranslation("admin.user.head.profil", new Object[0])).setSortable(true);
        this.grid.addColumn((ValueProvider & Serializable)user -> user.isArchive() ? this.getTranslation("Global.Yes", new Object[0]) : null).setHeader(this.getTranslation("admin.user.head.archive", new Object[0])).setSortable(true);
    }

    private void onShowArchivedChange(HasValue.ValueChangeEvent<Boolean> event) {
        this.showArchived = (Boolean)event.getValue();
        this.grid.getDataProvider().refreshAll();
    }

    protected Collection<UserVaadinBean> refreshItems() {
        ImmutableMap profilesById = Maps.uniqueIndex((Iterable)this.businessService.getProfils(), profil -> profil.getId());
        AuthenticatedUser currentUser = this.userPermissionService.getCurrentUser();
        List users = currentUser.getDelegation() == null ? this.businessService.rechercheToutUtilisateur() : (currentUser.getCentre() == null ? this.businessService.rechercheUtilisateurParDelegation(currentUser.getPrismUser()) : this.businessService.rechercheUtilisateurParDelegationCentre(currentUser.getPrismUser()));
        for (PrismCentralUser user : users) {
            user.setProfil((Profil)profilesById.get((Object)user.getIdProfil()));
        }
        this.filterUsersForSecurity(users, currentUser.getPrismUser());
        return users.stream().map(arg_0 -> ((UserVaadinBeanMapper)UserVaadinBeanMapper.INSTANCE).mapToVaadinBean(arg_0)).toList();
    }

    private void filterUsersForSecurity(List<PrismCentralUser> users, PrismCentralUser currentUser) {
        users.removeIf(user -> user.getProfil() == null);
        users.removeIf(PrismCentralUser::isSysteme);
        if (!currentUser.isSuperAdmin()) {
            users.removeIf(PrismCentralUser::isSuperAdmin);
        }
        if (!this.canEditProfiles(currentUser)) {
            users.removeIf(arg_0 -> this.canEditProfiles(arg_0));
        }
    }

    private boolean canEditProfiles(PrismCentralUser user) {
        return user.canDo(14);
    }

    protected void createItem(SaveEvent<UserVaadinBean> saveEvent) {
        this.businessService.creerUtilisateur(UserVaadinBeanMapper.INSTANCE.mapToEntity((UserVaadinBean)saveEvent.getValue()), ((UserVaadinBean)saveEvent.getValue()).getPassword());
    }

    protected void updateItem(SaveEvent<UserVaadinBean> saveEvent) {
        this.businessService.updateUtilisateur(UserVaadinBeanMapper.INSTANCE.mapToEntity((UserVaadinBean)saveEvent.getValue()), ((UserVaadinBean)saveEvent.getValue()).getPassword());
    }

    protected void deleteItem(UserVaadinBean item) {
        this.businessService.anonymisation(UserVaadinBeanMapper.INSTANCE.mapToEntity(item));
        this.businessService.deleteUtilisateur(item.getId());
    }

    protected AbstractAdminEditDialog<UserVaadinBean> createEditDialog(UserVaadinBean item) {
        return new UserAdminEditDialog(item, this.businessService, this.userPermissionService);
    }

    protected boolean isDeletable(UserVaadinBean item) {
        return item.isArchive();
    }

    protected boolean hasFilter() {
        return true;
    }

    protected void onFilterValueChange(String filterValue) {
        this.filterValue = filterValue.toLowerCase();
    }

    protected boolean filter(UserVaadinBean item) {
        return this.filterArchived(item) && this.filterValue(item);
    }

    private boolean filterArchived(UserVaadinBean item) {
        return !item.isArchive() || this.showArchived;
    }

    private boolean filterValue(UserVaadinBean item) {
        return item.getCode().toLowerCase().contains(this.filterValue) || item.getNom().toLowerCase().contains(this.filterValue) || !ConstantesGLS.estVide((String)item.getDelegation()) && item.getDelegation().toLowerCase().contains(this.filterValue) || !ConstantesGLS.estVide((String)item.getCentre()) && item.getCentre().toLowerCase().contains(this.filterValue);
    }

    protected String getFilterPlaceholder() {
        return this.getTranslation("admin.user.search", new Object[0]);
    }

    public String getPageTitle() {
        return this.getTranslation("admin.user.title", new Object[0]);
    }

    @Generated
    public UserAdminView(IBusinessService businessService, UserPermissionService userPermissionService) {
        this.businessService = businessService;
        this.userPermissionService = userPermissionService;
    }
}

