/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.user;

import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.bean.UserVaadinBean;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.validator.EmailValidator;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializablePredicate;
import gls.outils.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class UserAdminEditDialog
extends AbstractAdminEditDialog<UserVaadinBean> {
    private static final int MAX_SNA_LENGTH = 15;
    private final TextField sna = new TextField(this.getTranslation("admin.user.sna", new Object[0]));
    private final TextField name = new TextField(this.getTranslation("admin.user.name", new Object[0]));
    private final TextField telephone = new TextField(this.getTranslation("admin.user.telephone", new Object[0]));
    private final TextField mail = new TextField(this.getTranslation("admin.user.mail", new Object[0]));
    private final PasswordField password = new PasswordField(this.getTranslation("admin.user.password", new Object[0]));
    private final PasswordField confirm = new PasswordField(this.getTranslation("admin.user.confirm", new Object[0]));
    private final ComboBox<Delegation> delegation = new ComboBox(this.getTranslation("global.delegation", new Object[0]));
    private final ComboBox<Centre> center = new ComboBox(this.getTranslation("global.centre", new Object[0]));
    private final Checkbox isArchive = new Checkbox(this.getTranslation("admin.user.isarchive", new Object[0]));
    private final ComboBox<Profil> profile = new ComboBox(this.getTranslation("admin.user.profile", new Object[0]));
    private final Binder<UserVaadinBean> binder = new Binder();
    private final Map<String, Delegation> delegations;
    private final Table<String, String, Centre> centers;
    private final boolean complexPassword;

    UserAdminEditDialog(UserVaadinBean oldItem, IBusinessService businessService, UserPermissionService userPermissionService) {
        super((Object)oldItem);
        this.delegations = Maps.uniqueIndex((Iterable)businessService.getDelegationsActives(), Delegation::getNom);
        this.centers = this.createCenterTable(this.delegations.values());
        this.complexPassword = businessService.getConfiguration().getBoolean("complexPassword", false);
        this.delegation.setClearButtonVisible(true);
        this.delegation.setItems(this.delegations.values());
        this.delegation.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.center.clear();
            this.center.setItems(((ComboBox)event.getSource()).isEmpty() ? List.of() : ((Delegation)event.getValue()).getCentres());
        });
        this.center.setClearButtonVisible(true);
        this.profile.setItemLabelGenerator(Profil::getName);
        this.profile.setItems((Collection)businessService.getProfils());
        VerticalLayout content = new VerticalLayout(new Component[]{this.sna, this.name, this.telephone, this.mail, this.password, this.confirm, this.delegation, this.center, this.isArchive, this.profile});
        content.setSpacing(false);
        content.setPadding(false);
        content.setAlignItems(FlexComponent.Alignment.STRETCH);
        this.add(new Component[]{content});
        this.binder.forField((HasValue)this.sna).asRequired(this.getTranslation("admin.user.error.sna", new Object[0])).withValidator((SerializablePredicate & Serializable)value -> value.length() <= 15 && !value.contains(" "), this.getTranslation("admin.user.error2.sna", new Object[0])).bind(UserVaadinBean::getCode, UserVaadinBean::setCode).setReadOnly(this.isEdition());
        this.binder.forField((HasValue)this.name).asRequired(this.getTranslation("admin.user.error.name", new Object[0])).bind(UserVaadinBean::getNom, UserVaadinBean::setNom);
        this.binder.bind((HasValue)this.telephone, UserVaadinBean::getTelephone, UserVaadinBean::setTelephone);
        this.binder.forField((HasValue)this.mail).withValidator((Validator)new EmailValidator(this.getTranslation("admin.user.error.mail", new Object[0]), true)).withNullRepresentation((Object)"").bind(UserVaadinBean::getMail, UserVaadinBean::setMail);
        Binder.Binding passwordBinding = this.binder.forField((HasValue)this.password).withValidator((SerializablePredicate & Serializable)value -> this.isEdition() || !value.isEmpty(), this.getTranslation("admin.user.error.pwd", new Object[0])).withValidator((SerializablePredicate & Serializable)value -> value.equals(this.confirm.getValue()), this.getTranslation("admin.user.error.pwddiff", new Object[0])).withValidator((arg_0, arg_1) -> this.complexPasswordValidation(arg_0, arg_1)).withNullRepresentation((Object)"").bind(UserVaadinBean::getPassword, UserVaadinBean::setPassword);
        this.binder.bind((HasValue)this.delegation, arg_0 -> this.getUserDelegation(arg_0), (arg_0, arg_1) -> this.setUserDelegation(arg_0, arg_1));
        this.binder.bind((HasValue)this.center, arg_0 -> this.getUserCenter(arg_0), (arg_0, arg_1) -> this.setUserCenter(arg_0, arg_1));
        this.binder.bind((HasValue)this.isArchive, UserVaadinBean::isArchive, UserVaadinBean::setArchive);
        this.binder.forField((HasValue)this.profile).asRequired(this.getTranslation("admin.user.error.profil", new Object[0])).bind(UserVaadinBean::getProfil, UserVaadinBean::setProfil);
        this.password.setValueChangeMode(ValueChangeMode.LAZY);
        this.confirm.setValueChangeMode(ValueChangeMode.LAZY);
        this.confirm.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> passwordBinding.validate());
        this.binder.readBean((Object)oldItem);
        AuthenticatedUser currentUser = userPermissionService.getCurrentUser();
        if (currentUser.getDelegation() != null) {
            this.delegation.setReadOnly(true);
            this.delegation.setValue((Object)currentUser.getDelegation());
        }
        if (currentUser.getCentre() != null) {
            this.center.setReadOnly(true);
            this.center.setValue((Object)currentUser.getCentre());
        }
    }

    private Table<String, String, Centre> createCenterTable(Collection<Delegation> delegations) {
        HashBasedTable table = HashBasedTable.create();
        for (Delegation d : delegations) {
            for (Centre c : d.getCentres()) {
                table.put((Object)d.getNom(), (Object)c.getNom(), (Object)c);
            }
        }
        return Tables.unmodifiableTable((Table)table);
    }

    private Delegation getUserDelegation(UserVaadinBean user) {
        return (Delegation)this.delegations.get(user.getDelegation());
    }

    private void setUserDelegation(UserVaadinBean user, Delegation delegation) {
        user.setDelegation(delegation != null ? delegation.getNom() : null);
    }

    private Centre getUserCenter(UserVaadinBean user) {
        return (Centre)this.centers.get((Object)user.getDelegation(), (Object)user.getCentre());
    }

    private void setUserCenter(UserVaadinBean user, Centre centre) {
        user.setCentre(centre != null ? centre.getNom() : null);
    }

    private ValidationResult complexPasswordValidation(String value, ValueContext valueContext) {
        try {
            if (this.complexPassword) {
                Util.isComplexPassword((String)value);
            }
            return ValidationResult.ok();
        }
        catch (Util.ExceptionNbCaracteres e) {
            return ValidationResult.error((String)this.getTranslation("admin.user.error.pwdnbcar", new Object[0]));
        }
        catch (Util.ExceptionReglesMotDePasse e) {
            return ValidationResult.error((String)this.getTranslation("admin.user.error.pwdrules", new Object[0]));
        }
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.user.create", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.user.edit", new Object[0]);
    }

    protected UserVaadinBean getValue() throws ValidationException {
        UserVaadinBean value = this.isEdition() ? ((UserVaadinBean)this.oldItem).toBuilder().build() : UserVaadinBean.builder().build();
        this.binder.writeBean((Object)value);
        return value;
    }
}

