/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.publication.parameter;

import com.geolocsystems.prismcentral.beans.ConfigurationBean;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.util.DateTimeFormatterUtils;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.publication.parameter.PublicationParameterConfigurationAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.publication.parameter.PublicationParameterConfigurationAdminViewService;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RolesAllowed(value={"ACTION_ADMIN_CONFIGURATION_PUBLICATION"})
@Route(value="admin/publication-parameter-configuration", layout=PrismLayout.class)
public class PublicationParameterConfigurationAdminView
extends AbstractAdminView<ConfigurationBean> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublicationParameterConfigurationAdminView.class);
    private final DateFormat beanValueDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final PublicationParameterConfigurationAdminViewService service;

    protected void init() {
        this.grid.addColumn(ConfigurationBean::getChamp).setHeader(this.getTranslation("admin.configuration.champ", new Object[0]));
        this.grid.addColumn(arg_0 -> this.getLabelColumnValue(arg_0)).setHeader(this.getTranslation("admin.configuration.label", new Object[0]));
        this.grid.addColumn(arg_0 -> this.getValueColumnValue(arg_0)).setHeader(this.getTranslation("admin.configuration.valeur", new Object[0]));
    }

    private String getLabelColumnValue(ConfigurationBean bean) {
        return switch (bean.getChamp()) {
            case "interval_maj" -> "D\u00e9lai de rafraichissement";
            case "date_debut_vh" -> "Date de debut de la Viabilit\u00e9 Hivernale";
            case "date_fin_vh" -> "Date de fin de la Viabilit\u00e9 Hivernale";
            case "afficher_bouton_restrictionPL" -> "Affichage du bouton Restrictions de circulation poids-lourds";
            default -> bean.getLabel();
        };
    }

    private String getValueColumnValue(ConfigurationBean bean) {
        if (bean.getLabel().equals("timestamp")) {
            try {
                return DateTimeFormatterUtils.getDateFormatter().format(this.beanValueDateFormat.parse(bean.getValeur()).toInstant());
            }
            catch (ParseException e) {
                log.warn("Impossible de parser la date '{}'", (Object)bean.getValeur(), (Object)e);
                return bean.getValeur();
            }
        }
        return bean.getValeur();
    }

    protected Collection<ConfigurationBean> refreshItems() {
        return this.service.getParameters();
    }

    protected void createItem(SaveEvent<ConfigurationBean> saveEvent) {
        throw new UnsupportedOperationException("Cr\u00e9ation impossible");
    }

    protected void updateItem(SaveEvent<ConfigurationBean> saveEvent) {
        this.service.saveParameter((ConfigurationBean)saveEvent.getValue());
    }

    protected void deleteItem(ConfigurationBean item) {
        throw new UnsupportedOperationException("Suppression impossible");
    }

    protected AbstractAdminEditDialog<ConfigurationBean> createEditDialog(ConfigurationBean item) {
        return new PublicationParameterConfigurationAdminEditDialog(item);
    }

    protected boolean isCreatable() {
        return false;
    }

    protected boolean isDeletable(ConfigurationBean item) {
        return false;
    }

    public String getPageTitle() {
        return this.getTranslation("admin.configuration.publication.title", new Object[0]);
    }

    @Generated
    public PublicationParameterConfigurationAdminView(PublicationParameterConfigurationAdminViewService service) {
        this.service = service;
    }
}

