/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.publication.parameter;

import com.geolocsystems.prismcentral.beans.ConfigurationBean;
import com.neogls.prism.central.vaadin.common.component.PrismFormItem;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.publication.parameter.PublicationParameterConfigurationAdminEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.ValidationException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class PublicationParameterConfigurationAdminEditDialog
extends AbstractAdminEditDialog<ConfigurationBean> {
    private static final DateTimeFormatter DATE_VALUE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final TextField fieldName = new TextField(this.getTranslation("admin.configuration.champ", new Object[0]));
    private final TextField textValue = new TextField(this.getTranslation("admin.configuration.valeur", new Object[0]));
    private final DatePicker dateValue = new DatePicker(this.getTranslation("admin.configuration.valeur", new Object[0]));
    private final ValueType valueType;

    public PublicationParameterConfigurationAdminEditDialog(ConfigurationBean oldItem) {
        super((Object)Objects.requireNonNull(oldItem));
        this.valueType = oldItem.getLabel().equals("timestamp") ? ValueType.DATE : ValueType.TEXT;
        this.initContent();
        this.readValue(oldItem);
    }

    private void initContent() {
        this.fieldName.setReadOnly(true);
        this.dateValue.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        PrismFormItem textValueFormItem = new PrismFormItem((Component)this.textValue);
        PrismFormItem dateValueFormItem = new PrismFormItem((Component)this.dateValue);
        FormLayout content = new FormLayout(new Component[]{new PrismFormItem((Component)this.fieldName), textValueFormItem, dateValueFormItem});
        content.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1)});
        content.setMaxWidth(30.0f, Unit.EM);
        this.add(new Component[]{content});
        textValueFormItem.setVisible(this.valueType == ValueType.TEXT);
        dateValueFormItem.setVisible(this.valueType == ValueType.DATE);
    }

    private void readValue(ConfigurationBean oldItem) {
        this.fieldName.setValue(oldItem.getChamp());
        if (this.valueType == ValueType.DATE) {
            this.dateValue.setValue(oldItem.getValeur().isEmpty() ? LocalDate.now() : DATE_VALUE_FORMAT.parse((CharSequence)oldItem.getValeur(), LocalDate::from));
        } else {
            this.textValue.setValue(oldItem.getValeur());
        }
    }

    protected String getCreateTitle() {
        throw new UnsupportedOperationException("Cr\u00e9ation impossible");
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.configuration.edit", new Object[0]);
    }

    protected ConfigurationBean getValue() throws ValidationException {
        ConfigurationBean value = new ConfigurationBean();
        value.setChamp(((ConfigurationBean)this.oldItem).getChamp());
        value.setValeur(switch (1.$SwitchMap$com$neogls$prism$central$vaadin$view$admin$publication$parameter$PublicationParameterConfigurationAdminEditDialog$ValueType[this.valueType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.textValue.getValue();
            case 2 -> this.dateValue.getOptionalValue().map(DATE_VALUE_FORMAT::format).orElse("");
        });
        return value;
    }
}

