/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.publication.message;

import com.geolocsystems.prismcentral.beans.MessageAlertePublication;
import com.neogls.prism.central.vaadin.common.component.PrismFormItem;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ButtonConfig;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ConfirmDialog;
import com.neogls.prism.central.vaadin.common.exception.CustomValidationException;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.publication.message.AlertMessageAdminViewService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.ValidationException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

public class AlertMessageAdminEditDialog
extends AbstractAdminEditDialog<MessageAlertePublication> {
    private final ComboBox<AlertMessageAdminViewService.Model> model = new ComboBox(this.getTranslation("admin.message.alerte.publication.libelle", new Object[0]));
    private final TextField label = new TextField(this.getTranslation("admin.message.alerte.publication.head.libelle", new Object[0]));
    private final TextArea message = new TextArea(this.getTranslation("admin.message.alerte.publication.texte", new Object[0]));
    private final DateTimePicker dateDebut = new DateTimePicker(this.getTranslation("admin.message.alerte.publication.date.debut", new Object[0]));
    private final DateTimePicker dateFin = new DateTimePicker(this.getTranslation("admin.message.alerte.publication.date.fin", new Object[0]));
    private final ComboBox<String> type = new ComboBox(this.getTranslation("admin.message.alerte.publication.type", new Object[0]));
    private final Checkbox defaultMessage = new Checkbox(this.getTranslation("admin.message.alerte.publication.defaut", new Object[0]));
    private static final String[] TYPES = new String[]{"D\u00e9roulant", "Fixe", "Clignotant"};

    public AlertMessageAdminEditDialog(Collection<AlertMessageAdminViewService.Model> models, MessageAlertePublication oldItem) {
        super((Object)oldItem);
        this.model.setItemLabelGenerator(AlertMessageAdminViewService.Model::getLabel);
        this.model.setItems(models);
        this.model.addValueChangeListener(arg_0 -> this.onModelValueChange(arg_0));
        this.label.setRequired(true);
        this.message.setRequired(true);
        this.dateDebut.setRequiredIndicatorVisible(true);
        this.dateDebut.setStep(Duration.ofMinutes(1L));
        this.dateDebut.setDatePickerI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.dateFin.setRequiredIndicatorVisible(true);
        this.dateFin.setStep(Duration.ofMinutes(1L));
        this.dateFin.setDatePickerI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.type.setRequired(true);
        this.type.setItems((Object[])TYPES);
        FormLayout content = new FormLayout(new Component[]{new PrismFormItem((Component)this.model), new PrismFormItem((Component)this.label), new PrismFormItem((Component)this.message), new PrismFormItem((Component)this.dateDebut), new PrismFormItem((Component)this.dateFin), new PrismFormItem((Component)this.type), new PrismFormItem((Component)this.defaultMessage)});
        content.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1)});
        content.setMaxWidth(40.0f, Unit.EM);
        content.getStyle().set("--vaadin-form-item-label-width", "10em");
        this.add(new Component[]{content});
        if (oldItem != null) {
            this.label.setValue(oldItem.getLibelle());
            this.message.setValue(oldItem.getTexte());
            this.dateDebut.setValue(oldItem.getDateDebut().toLocalDateTime());
            this.dateFin.setValue(oldItem.getDateFin().toLocalDateTime());
            this.type.setValue((Object)oldItem.getType());
            this.defaultMessage.setValue((Object)oldItem.isDefaut());
        }
    }

    private void onModelValueChange(HasValue.ValueChangeEvent<AlertMessageAdminViewService.Model> event) {
        if (event.getValue() == null) {
            return;
        }
        ConfirmDialog.builder().title(this.getTranslation("admin.user.confirm", new Object[0])).text("Appliquer le mod\u00e8le \"%s\" ?".formatted(((AlertMessageAdminViewService.Model)event.getValue()).getLabel())).confirm(ButtonConfig.builder().text(this.getTranslation("generic.apply", new Object[0])).buttonVariants(List.of(ButtonVariant.LUMO_PRIMARY)).listener((ComponentEventListener & Serializable)e -> this.message.setValue(((AlertMessageAdminViewService.Model)event.getValue()).getValue())).build()).cancel(ButtonConfig.builder().text(this.getTranslation("generic.cancel", new Object[0])).listener((ComponentEventListener & Serializable)e -> this.model.setValue((Object)((AlertMessageAdminViewService.Model)event.getOldValue()))).build()).build().open();
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.message.alerte.publication.title", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.message.alerte.publication.title", new Object[0]);
    }

    protected MessageAlertePublication getValue() throws ValidationException {
        boolean invalid = false;
        if (this.label.isEmpty()) {
            invalid = true;
            this.label.setErrorMessage(this.getTranslation("admin.message.alerte.publication.error.libelle", new Object[0]));
            this.label.setInvalid(true);
        }
        if (this.message.isEmpty()) {
            invalid = true;
            this.message.setErrorMessage(this.getTranslation("admin.message.alerte.publication.error.texte", new Object[0]));
            this.message.setInvalid(true);
        }
        if (this.dateDebut.isEmpty()) {
            invalid = true;
            this.dateDebut.setErrorMessage(this.getTranslation("admin.message.alerte.publication.error.date.debut", new Object[0]));
            this.dateDebut.setInvalid(true);
        }
        if (this.dateFin.isEmpty()) {
            invalid = true;
            this.dateFin.setErrorMessage(this.getTranslation("admin.message.alerte.publication.error.date.fin", new Object[0]));
            this.dateFin.setInvalid(true);
        }
        if (this.type.isEmpty()) {
            invalid = true;
            this.type.setErrorMessage("Type obligatoire");
            this.type.setInvalid(true);
        }
        if (invalid) {
            throw new CustomValidationException("Un ou plusieurs champs sont invalides.");
        }
        MessageAlertePublication newItem = new MessageAlertePublication();
        if (this.oldItem != null) {
            newItem.setId(((MessageAlertePublication)this.oldItem).getId());
        }
        newItem.setLibelle(this.label.getValue());
        newItem.setTexte(this.message.getValue());
        newItem.setDateDebut(Timestamp.valueOf((LocalDateTime)this.dateDebut.getValue()));
        newItem.setDateFin(Timestamp.valueOf((LocalDateTime)this.dateFin.getValue()));
        newItem.setType((String)this.type.getValue());
        newItem.setDefaut(((Boolean)this.defaultMessage.getValue()).booleanValue());
        return newItem;
    }
}

