/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.publication.configuration;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismcentral.beans.ReformulationDescription;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.PublicationConfigurationEditDialog;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoChamp;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoLigneReformulation;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoModuleMetier;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoNature;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoReformulation;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoSousNature;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class PublicationConfigurationViewService {
    private final IBusinessService businessService;

    public DtoModuleMetier getModulesMetier(int codeMM) {
        ModuleMetier moduleMetier = (ModuleMetier)this.businessService.getModulesMetiers().get(codeMM);
        if (moduleMetier == null) {
            throw new IllegalArgumentException("Aucun module m\u00e9tier trouv\u00e9 avec le code " + codeMM);
        }
        return this.mapModuleMetier(moduleMetier);
    }

    public List<DtoNature> getNatures() {
        return this.businessService.getNatures().values().stream().map(arg_0 -> this.mapNature(arg_0)).toList();
    }

    public PublicationConfigurationEditDialog createEditDialog(DtoNature nature, DtoSousNature sousNature) {
        return new PublicationConfigurationEditDialog(this.getReformulation(sousNature), nature, sousNature, this.getChampsNature(nature));
    }

    public DtoReformulation getReformulation(DtoSousNature sousNature) {
        return this.mapReformulation((ReformulationDescription)this.businessService.getReformulations().get(sousNature.getCode()));
    }

    public void saveReformulation(DtoNature nature, DtoSousNature sousNature, DtoReformulation reformulation) {
        this.businessService.updateReformulationPublication(this.mapReformulation(nature, sousNature, reformulation));
    }

    private List<DtoChamp> getChampsNature(DtoNature nature) {
        Nature entityNature = (Nature)this.businessService.getNatures().get(nature.getCode());
        return MetierCommun.getChamps((Nature)entityNature).values().stream().map(arg_0 -> this.mapChamp(arg_0)).toList();
    }

    private DtoModuleMetier mapModuleMetier(ModuleMetier moduleMetier) {
        return new DtoModuleMetier(moduleMetier.getCode(), moduleMetier.getLibelle());
    }

    private DtoNature mapNature(Nature nature) {
        List<DtoSousNature> sousNatures = ((List)this.businessService.getDescriptionsNatureMap().get(nature.getCode())).stream().map(arg_0 -> this.mapSousNature(arg_0)).toList();
        return new DtoNature(nature.getCode(), nature.getLabel(), nature.getCodeMM(), sousNatures);
    }

    private DtoSousNature mapSousNature(DescriptionNature sousNature) {
        return new DtoSousNature(sousNature.getCode(), sousNature.getLibelle());
    }

    private DtoReformulation mapReformulation(@Nullable ReformulationDescription reformulation) {
        reformulation = Objects.requireNonNullElseGet(reformulation, ReformulationDescription::new);
        DtoReformulation dto = new DtoReformulation();
        dto.setLigne1(new DtoLigneReformulation(reformulation.getType1(), reformulation.getValeur1()));
        dto.setLigne2(new DtoLigneReformulation(reformulation.getType2(), reformulation.getValeur2()));
        dto.setLigne3(new DtoLigneReformulation(reformulation.getType3(), reformulation.getValeur3()));
        dto.setLigne4(new DtoLigneReformulation(reformulation.getType4(), reformulation.getValeur4()));
        dto.setLigne5(new DtoLigneReformulation(reformulation.getType5(), reformulation.getValeur5()));
        return dto;
    }

    private ReformulationDescription mapReformulation(DtoNature nature, DtoSousNature sousNature, DtoReformulation reformulation) {
        ReformulationDescription entity = new ReformulationDescription();
        entity.setCodeNature(nature.getCode());
        entity.setCode(sousNature.getCode());
        entity.setLibelle(sousNature.getLabel());
        entity.setType1(reformulation.getLigne1().getType());
        entity.setValeur1(reformulation.getLigne1().getValue());
        entity.setType2(reformulation.getLigne2().getType());
        entity.setValeur2(reformulation.getLigne2().getValue());
        entity.setType3(reformulation.getLigne3().getType());
        entity.setValeur3(reformulation.getLigne3().getValue());
        entity.setType4(reformulation.getLigne4().getType());
        entity.setValeur4(reformulation.getLigne4().getValue());
        entity.setType5(reformulation.getLigne5().getType());
        entity.setValeur5(reformulation.getLigne5().getValue());
        return entity;
    }

    private DtoChamp mapChamp(Champ champ) {
        return new DtoChamp(champ.getNom(), champ.getLibelle());
    }

    @Generated
    public PublicationConfigurationViewService(IBusinessService businessService) {
        this.businessService = businessService;
    }
}

