/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.publication.configuration;

import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.PublicationConfigurationEditDialog;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.PublicationConfigurationViewService;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoModuleMetier;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoNature;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoSousNature;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RolesAllowed(value={"ACTION_ADMIN_PUBLICATION"})
@Route(value="admin/publication-configuration", layout=PrismLayout.class)
public class PublicationConfigurationView
extends VerticalLayout
implements HasDynamicTitle {
    private final PublicationConfigurationViewService service;
    private final ComboBox<DtoModuleMetier> cbModuleMetier = new ComboBox("Module m\u00e9tier");
    private final Map<DtoNature, Component> containersByNature = new HashMap();

    public PublicationConfigurationView(PublicationConfigurationViewService service) {
        this.service = service;
        this.cbModuleMetier.setClearButtonVisible(true);
        this.cbModuleMetier.setItemLabelGenerator(DtoModuleMetier::getLabel);
        this.cbModuleMetier.setWidth(50.0f, Unit.PERCENTAGE);
        this.cbModuleMetier.setMinWidth(20.0f, Unit.EM);
        this.cbModuleMetier.addValueChangeListener(arg_0 -> this.onModuleMetierChange(arg_0));
        this.add(new Component[]{this.cbModuleMetier});
        this.setMaxWidth(60.0f, Unit.EM);
        this.addClassName("mx-auto");
        this.refresh();
    }

    private void refresh() {
        DtoModuleMetier moduleMetier = (DtoModuleMetier)this.cbModuleMetier.getValue();
        this.containersByNature.values().forEach(Component::removeFromParent);
        this.containersByNature.clear();
        List natures = this.service.getNatures();
        this.cbModuleMetier.setItems(natures.stream().map(DtoNature::getCodeMM).distinct().map(arg_0 -> ((PublicationConfigurationViewService)this.service).getModulesMetier(arg_0)).toList());
        for (DtoNature value : natures) {
            Component container = this.createContainer(value);
            this.containersByNature.put(value, container);
            this.add(new Component[]{container});
        }
        if (moduleMetier != null && this.cbModuleMetier.getListDataView().contains((Object)moduleMetier)) {
            this.cbModuleMetier.setValue((Object)moduleMetier);
        }
    }

    private Component createContainer(DtoNature nature) {
        VerticalLayout container = new VerticalLayout();
        container.setPadding(false);
        container.setSpacing(false);
        Span title = new Span(nature.getLabel());
        title.addClassNames(new String[]{"text-l", "font-bold"});
        container.add(new Component[]{title});
        for (DtoSousNature sousNature : nature.getSousNatures()) {
            Div subContainer = new Div(new Component[]{new Button((Component)VaadinIcon.EDIT.create(), (ComponentEventListener & Serializable)event -> this.openConfigDialog(nature, sousNature)), new Span(this.getLabelSousNature(sousNature))});
            subContainer.addClassNames(new String[]{"flex", "gap-s", "items-baseline"});
            container.add(new Component[]{subContainer});
        }
        return container;
    }

    private String getLabelSousNature(DtoSousNature sousNature) {
        if (this.service.getReformulation(sousNature).isEmpty()) {
            return sousNature.getLabel();
        }
        return sousNature.getLabel() + " *";
    }

    private void openConfigDialog(DtoNature nature, DtoSousNature sousNature) {
        PublicationConfigurationEditDialog dialog = this.service.createEditDialog(nature, sousNature);
        dialog.addSaveListener((ComponentEventListener & Serializable)event -> {
            this.service.saveReformulation(nature, sousNature, event.getReformulation());
            this.refresh();
        });
        dialog.open();
    }

    private void onModuleMetierChange(HasValue.ValueChangeEvent<DtoModuleMetier> event) {
        if (event.getValue() == null) {
            for (Component container2 : this.containersByNature.values()) {
                container2.setVisible(true);
            }
        } else {
            this.containersByNature.forEach((nature, container) -> container.setVisible(nature.getCodeMM() == ((DtoModuleMetier)event.getValue()).getCode()));
        }
    }

    public String getPageTitle() {
        return this.getTranslation("admin.publication.title", new Object[0]);
    }
}

