/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.publication.configuration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.common.component.PrismFormItem;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.LigneReformulationInputField;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.PublicationConfigurationEditDialog;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoChamp;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoLigneReformulation;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoNature;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoReformulation;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoSousNature;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class PublicationConfigurationEditDialog
extends Dialog {
    private final LigneReformulationInputField ligne1;
    private final LigneReformulationInputField ligne2;
    private final LigneReformulationInputField ligne3;
    private final LigneReformulationInputField ligne4;
    private final LigneReformulationInputField ligne5;
    private static final String KEY_STR_LIGNE_REFORMULATION = "admin.publication.ligne";

    public PublicationConfigurationEditDialog(DtoReformulation reformulation, DtoNature nature, DtoSousNature sousNature, List<DtoChamp> champs) {
        ImmutableMap champMap = Maps.uniqueIndex(champs, DtoChamp::getName);
        this.ligne1 = new LigneReformulationInputField((Map)champMap);
        this.ligne2 = new LigneReformulationInputField((Map)champMap);
        this.ligne3 = new LigneReformulationInputField((Map)champMap);
        this.ligne4 = new LigneReformulationInputField((Map)champMap);
        this.ligne5 = new LigneReformulationInputField((Map)champMap);
        this.setCloseOnOutsideClick(false);
        this.setHeaderTitle(this.getTranslation("admin.publication.title", new Object[0]));
        Span subTitle = new Span(nature.getLabel() + " > " + sousNature.getLabel());
        subTitle.addClassNames(new String[]{"font-bold", "mx-auto"});
        FormLayout form = new FormLayout(new Component[]{new PrismFormItem(this.getTranslation(KEY_STR_LIGNE_REFORMULATION, new Object[0]) + " 1", (Component)this.ligne1), new PrismFormItem(this.getTranslation(KEY_STR_LIGNE_REFORMULATION, new Object[0]) + " 2", (Component)this.ligne2), new PrismFormItem(this.getTranslation(KEY_STR_LIGNE_REFORMULATION, new Object[0]) + " 3", (Component)this.ligne3), new PrismFormItem(this.getTranslation(KEY_STR_LIGNE_REFORMULATION, new Object[0]) + " 4", (Component)this.ligne4), new PrismFormItem(this.getTranslation(KEY_STR_LIGNE_REFORMULATION, new Object[0]) + " 5", (Component)this.ligne5)});
        form.setWidthFull();
        form.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1)});
        VerticalLayout layout = new VerticalLayout(new Component[]{subTitle, form});
        layout.setPadding(false);
        this.add(new Component[]{layout});
        Button bSave = new Button(this.getTranslation("admin.save", new Object[0]), arg_0 -> this.onSaveClick(arg_0));
        bSave.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        Button bCancel = new Button(this.getTranslation("admin.cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
        this.getFooter().add(new Component[]{bCancel, bSave});
        this.setMaxWidth(50.0f, Unit.EM);
        this.ligne1.setValue((Object)reformulation.getLigne1());
        this.ligne2.setValue((Object)reformulation.getLigne2());
        this.ligne3.setValue((Object)reformulation.getLigne3());
        this.ligne4.setValue((Object)reformulation.getLigne4());
        this.ligne5.setValue((Object)reformulation.getLigne5());
    }

    private void onSaveClick(ClickEvent<Button> event) {
        boolean valid = true;
        valid &= this.validateLigne(this.ligne1);
        valid &= this.validateLigne(this.ligne2);
        valid &= this.validateLigne(this.ligne3);
        valid &= this.validateLigne(this.ligne4);
        if (!(valid &= this.validateLigne(this.ligne5))) {
            return;
        }
        DtoReformulation reformulation = new DtoReformulation();
        reformulation.setLigne1((DtoLigneReformulation)this.ligne1.getValue());
        reformulation.setLigne2((DtoLigneReformulation)this.ligne2.getValue());
        reformulation.setLigne3((DtoLigneReformulation)this.ligne3.getValue());
        reformulation.setLigne4((DtoLigneReformulation)this.ligne4.getValue());
        reformulation.setLigne5((DtoLigneReformulation)this.ligne5.getValue());
        this.fireEvent((ComponentEvent)new SaveEvent(this, event.isFromClient(), reformulation));
        this.close();
    }

    private boolean validateLigne(LigneReformulationInputField field) {
        if (((DtoLigneReformulation)field.getOptionalValue().orElseThrow()).getValue() == null) {
            field.setErrorMessage("Le champ est obligatoire");
            field.setInvalid(true);
            return false;
        }
        field.setInvalid(false);
        return true;
    }

    public void addSaveListener(ComponentEventListener<SaveEvent> listener) {
        this.addListener(SaveEvent.class, listener);
    }
}

