/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.publication.configuration;

import com.geolocsystems.prismcentral.beans.ReformulationDescription;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoChamp;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.dto.DtoLigneReformulation;
import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.textfield.TextField;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class LigneReformulationInputField
extends AbstractCompositeField<Div, LigneReformulationInputField, DtoLigneReformulation>
implements HasValidation {
    private final ComboBox<Integer> cbType = new ComboBox();
    private final TextField tfTexteLibre = new TextField();
    private final ComboBox<DtoChamp> cbChamp = new ComboBox();
    private final Map<String, DtoChamp> champs;
    private static final List<Integer> TYPES = IntStream.of(ReformulationDescription.TYPES).boxed().toList();

    public LigneReformulationInputField(Map<String, DtoChamp> champs) {
        super(null);
        this.champs = champs;
        this.cbType.setItemLabelGenerator(arg_0 -> this.getTypeLabel(arg_0));
        this.cbType.setItems((Collection)TYPES);
        this.cbType.setValue((Object)0);
        this.cbType.setClearButtonVisible(true);
        this.cbChamp.setItemLabelGenerator(DtoChamp::getLabel);
        this.cbChamp.setItems(champs.values());
        this.cbType.addValueChangeListener(arg_0 -> this.onTypeChange(arg_0));
        this.tfTexteLibre.addValueChangeListener(arg_0 -> this.onTexteLibreChange(arg_0));
        this.cbChamp.addValueChangeListener(arg_0 -> this.onChampChange(arg_0));
        this.cbType.setWidthFull();
        this.tfTexteLibre.setWidthFull();
        this.cbChamp.setWidthFull();
        ((Div)this.getContent()).add(new Component[]{this.cbType, this.tfTexteLibre, this.cbChamp});
        ((Div)this.getContent()).addClassNames(new String[]{"flex", "gap-s"});
        this.tfTexteLibre.setVisible(false);
        this.cbChamp.setVisible(false);
    }

    private void onTypeChange(HasValue.ValueChangeEvent<Integer> event) {
        if (event.getOldValue() == null) {
            return;
        }
        if (this.cbType.isEmpty()) {
            this.cbType.setValue((Object)0);
        }
        this.tfTexteLibre.setVisible((Integer)this.cbType.getValue() == 3);
        this.cbChamp.setVisible((Integer)this.cbType.getValue() == 4);
        this.updateValue(event.isFromClient());
    }

    private void onTexteLibreChange(HasValue.ValueChangeEvent<String> event) {
        this.updateValue(event.isFromClient());
    }

    private void onChampChange(HasValue.ValueChangeEvent<DtoChamp> event) {
        this.updateValue(event.isFromClient());
    }

    private void updateValue(boolean fromClient) {
        Integer type = (Integer)this.cbType.getValue();
        String value = switch (type) {
            case 3 -> this.tfTexteLibre.getValue();
            case 4 -> this.cbChamp.getOptionalValue().map(DtoChamp::getName).orElse(null);
            default -> "";
        };
        this.setModelValue((Object)new DtoLigneReformulation(type.intValue(), value), fromClient);
    }

    private String getTypeLabel(int type) {
        return this.getTranslation("admin.publication.type." + type, new Object[0]);
    }

    protected void setPresentationValue(DtoLigneReformulation newPresentationValue) {
        this.cbType.setValue((Object)newPresentationValue.getType());
        if (newPresentationValue.getType() == 3) {
            this.tfTexteLibre.setValue(newPresentationValue.getValue());
        }
        if (newPresentationValue.getType() == 4) {
            this.cbChamp.setValue((Object)((DtoChamp)this.champs.get(newPresentationValue.getValue())));
        }
    }

    public void setErrorMessage(String errorMessage) {
        this.cbChamp.setErrorMessage(errorMessage);
    }

    public String getErrorMessage() {
        return this.cbChamp.getErrorMessage();
    }

    public void setInvalid(boolean invalid) {
        this.cbChamp.setInvalid(invalid);
    }

    public boolean isInvalid() {
        return this.cbChamp.isInvalid();
    }
}

