/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.profile;

import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.profile.ProfileAdminEditDialog;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.util.Collection;
import lombok.Generated;

@RolesAllowed(value={"ACTION_ADMIN_PROFIL"})
@Route(value="admin/profile", layout=PrismLayout.class)
public class ProfileAdminView
extends AbstractAdminView<Profil> {
    private final IBusinessService businessService;

    protected void init() {
        this.grid.addColumn(Profil::getName).setHeader(this.getTranslation("admin.profile.head.nom", new Object[0])).setSortable(true);
    }

    protected Collection<Profil> refreshItems() {
        return this.businessService.getProfils();
    }

    protected void createItem(SaveEvent<Profil> event) {
        this.businessService.creerProfil((Profil)event.getValue());
    }

    protected void updateItem(SaveEvent<Profil> event) {
        this.businessService.updateProfil((Profil)event.getValue());
    }

    protected void deleteItem(Profil profil) {
        this.businessService.deleteProfil(profil.getId());
    }

    protected AbstractAdminEditDialog<Profil> createEditDialog(Profil item) {
        return new ProfileAdminEditDialog(item, this.businessService.getActionsProfil());
    }

    public String getPageTitle() {
        return this.getTranslation("admin.profile.title", new Object[0]);
    }

    @Generated
    public ProfileAdminView(IBusinessService businessService) {
        this.businessService = businessService;
    }
}

