/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.profile;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismcentral.beans.ActionProfil;
import com.geolocsystems.prismcentral.beans.Profil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.common.component.checkboxtree.CheckboxTree;
import com.neogls.prism.central.vaadin.common.exception.CustomValidationException;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.profile.ActionDTO;
import com.neogls.prism.central.vaadin.view.admin.profile.ActionParametersEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.textfield.TextField;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;

public class ProfileAdminEditDialog
extends AbstractAdminEditDialog<Profil> {
    private final ImmutableMap<Integer, ActionDTO> actionById;
    private final TextField name = new TextField(this.getTranslation("admin.profile.name", new Object[0]));
    private final CheckboxTree<?, ActionDTO> checkboxTree;
    private final Map<Integer, MapDescription> parameters = new HashMap();

    protected ProfileAdminEditDialog(Profil oldItem, List<ActionProfil> availableActions) {
        super((Object)oldItem);
        List<ActionDTO> availableActionDTO = availableActions.stream().map(ActionDTO::fromActionProfil).sorted(Comparator.comparingInt(ActionDTO::getAction)).toList();
        this.actionById = Maps.uniqueIndex(availableActionDTO, ActionDTO::getAction);
        this.checkboxTree = new CheckboxTree(availableActionDTO, ActionDTO::getAction, ActionDTO::getActionParent, arg_0 -> this.getActionLabel(arg_0));
        this.checkboxTree.addRightClickListener(arg_0 -> this.onCheckboxTreeRightClick(arg_0));
        FlexLayout content = new FlexLayout(new Component[]{this.name, this.checkboxTree});
        content.setFlexDirection(FlexLayout.FlexDirection.COLUMN);
        content.setFlexGrow(1.0, new HasElement[]{this.checkboxTree});
        content.setSizeFull();
        this.add(new Component[]{content});
        this.setMinWidth(50.0f, Unit.EM);
        this.setHeightFull();
        if (oldItem != null) {
            this.name.setValue(oldItem.getName());
            this.checkboxTree.setValue((Object)this.profilActionGetter(oldItem));
            Optional.ofNullable(oldItem.getParametres()).ifPresent(this.parameters::putAll);
        }
        this.checkboxTree.updateItemLabels(null);
    }

    private String getActionLabel(ActionDTO actionDTO) {
        String label = Objects.requireNonNullElse(actionDTO.getDescription(), actionDTO.getNom());
        MapDescription actionParameters = (MapDescription)this.parameters.get(actionDTO.getAction());
        if (actionParameters != null && !actionParameters.toString().isBlank()) {
            return label + " *";
        }
        return label;
    }

    private void onCheckboxTreeRightClick(CheckboxTree.RightClickEvent<ActionDTO> event) {
        ActionDTO item = (ActionDTO)event.getItem();
        int actionId = item.getAction();
        new ActionParametersEditDialog(item, (MapDescription)this.parameters.get(actionId), actionParameters -> {
            if (actionParameters != null) {
                this.parameters.put(actionId, actionParameters);
            } else {
                this.parameters.remove(actionId);
            }
            this.checkboxTree.updateItemLabels((Object)item);
        }).open();
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.profile.create", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.profile.edit", new Object[0]);
    }

    protected Profil getValue() {
        if (this.name.getValue().isBlank()) {
            String errorMessage = this.getTranslation("admin.profile.erreur.name", new Object[0]);
            this.name.setInvalid(true);
            this.name.setErrorMessage(errorMessage);
            throw new CustomValidationException(errorMessage);
        }
        Profil value = new Profil();
        value.setName(this.name.getValue());
        this.profilActionSetter(value, (Set)this.checkboxTree.getValue());
        value.setParametres(this.parameters);
        if (this.oldItem != null) {
            value.setId(((Profil)this.oldItem).getId());
            value.setModule_accueil(((Profil)this.oldItem).getModule_accueil());
        }
        return value;
    }

    private Set<ActionDTO> profilActionGetter(Profil profil) {
        return SetUtils.emptyIfNull((Set)profil.getActions()).stream().map(arg_0 -> ((ImmutableMap)this.actionById).get(arg_0)).collect(Collectors.toSet());
    }

    private void profilActionSetter(Profil profil, Set<ActionDTO> actionDTOs) {
        profil.setActions(actionDTOs.stream().map(ActionDTO::getAction).collect(Collectors.toSet()));
    }
}

