/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.mail.recipient;

import com.geolocsystems.prismcentral.beans.DestinataireMail;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterField;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.mail.recipient.MailRecipientAdminService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import java.util.List;

public class MailRecipientAdminEditDialog
extends AbstractAdminEditDialog<DestinataireMail> {
    private final TextField name = new TextField();
    private final TextField email = new TextField();
    private final ComboBox<String> category = new ComboBox();
    private final DelegationAndCenterField delegationAndCenter;
    private final Binder<DestinataireMail> binder = new Binder();

    MailRecipientAdminEditDialog(DestinataireMail oldItem, MailRecipientAdminService mailRecipientAdminService) {
        super((Object)oldItem);
        this.category.setItems(mailRecipientAdminService.getMailRecipientCategories());
        this.delegationAndCenter = new DelegationAndCenterField(mailRecipientAdminService.getActiveDelegationsAndCenters());
        this.configureFields();
        this.configureBinder();
        this.binder.readBean((Object)oldItem);
    }

    private void configureFields() {
        this.delegationAndCenter.setLabelsVisible(false);
        FormLayout content = new FormLayout();
        content.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        content.setMaxWidth(30.0f, Unit.EM);
        content.getStyle().set("--vaadin-form-item-label-width", "10em");
        content.addFormItem((Component)this.name, this.getTranslation("admin.destinataire.nom", new Object[0]));
        content.addFormItem((Component)this.email, this.getTranslation("admin.destinataire.mail", new Object[0]));
        content.addFormItem((Component)this.category, this.getTranslation("admin.destinataire.categorie", new Object[0]));
        content.addFormItem((Component)this.delegationAndCenter, this.getTranslation("global.delegation", new Object[0]) + " & " + this.getTranslation("global.centre", new Object[0]));
        this.add(new Component[]{content});
    }

    private void configureBinder() {
        this.binder.forField((HasValue)this.name).asRequired(this.getTranslation("admin.destinataire.error.nom", new Object[0])).bind(DestinataireMail::getNom, DestinataireMail::setNom);
        this.binder.forField((HasValue)this.email).asRequired(this.getTranslation("admin.destinataire.error.mail", new Object[0])).bind(DestinataireMail::getMail, DestinataireMail::setMail);
        this.binder.forField((HasValue)this.category).asRequired(this.getTranslation("admin.destinataire.error.categorie", new Object[0])).bind(DestinataireMail::getCategorie, DestinataireMail::setCategorie);
        this.binder.bind((HasValue)this.delegationAndCenter, DelegationAndCenterField.createGetter(DestinataireMail::getDelegation, DestinataireMail::getCentre), DelegationAndCenterField.createSetter(DestinataireMail::setDelegation, DestinataireMail::setCentre));
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.destinataire.title", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.destinataire.title", new Object[0]);
    }

    protected DestinataireMail getValue() throws ValidationException {
        DestinataireMail value = this.isEdition() ? (DestinataireMail)this.oldItem : new DestinataireMail();
        this.binder.writeBean((Object)value);
        return value;
    }
}

