/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.mail.list;

import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.mail.dto.MailListDto;
import com.neogls.prism.central.vaadin.view.admin.mail.list.MailListAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.mail.list.MailListAdminService;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.util.Collection;
import lombok.Generated;

@RolesAllowed(value={"ACTION_ADMIN_MAIL"})
@Route(value="admin/mail-list", layout=PrismLayout.class)
public class MailListAdminView
extends AbstractAdminView<MailListDto> {
    private final MailListAdminService service;

    protected void init() {
        this.grid.addColumn(MailListDto::getName).setHeader(this.getTranslation("admin.listedestinataire.head.identifiant", new Object[0]));
        this.grid.addColumn(arg_0 -> this.getRecipientsNumber(arg_0)).setHeader(this.getTranslation("admin.listedestinataire.head.nb", new Object[0]));
    }

    private String getRecipientsNumber(MailListDto mailList) {
        return mailList.getEntries().size() + " " + this.getTranslation("admin.listedestinataire.nb", new Object[0]);
    }

    protected Collection<MailListDto> refreshItems() {
        return this.service.getMailList();
    }

    protected void createItem(SaveEvent<MailListDto> saveEvent) {
        this.service.createMailList((MailListDto)saveEvent.getValue());
    }

    protected void updateItem(SaveEvent<MailListDto> saveEvent) {
        this.service.updateMailList((MailListDto)saveEvent.getValue());
    }

    protected void deleteItem(MailListDto item) {
        this.service.deleteMailList(item);
    }

    protected AbstractAdminEditDialog<MailListDto> createEditDialog(MailListDto item) {
        return new MailListAdminEditDialog(item, this.service.getRecipients());
    }

    public String getPageTitle() {
        return this.getTranslation("admin.listedestinataire.title", new Object[0]);
    }

    @Generated
    public MailListAdminView(MailListAdminService service) {
        this.service = service;
    }
}

