/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.mail.list;

import com.geolocsystems.prismcentral.beans.DestinataireMail;
import com.geolocsystems.prismcentral.beans.ListeDestinataireMail;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.view.admin.mail.dto.MailListDto;
import com.neogls.prism.central.vaadin.view.admin.mail.dto.MailListEntryDto;
import com.neogls.prism.central.vaadin.view.admin.mail.dto.MailRecipientDto;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class MailListAdminService {
    private final IBusinessService businessService;

    public Collection<MailListDto> getMailList() {
        return this.businessService.getListeDestinataireMails().stream().map(listeDestinataireMail -> new MailListDto(listeDestinataireMail.getId(), listeDestinataireMail.getNom(), this.mapMailListEntries(listeDestinataireMail))).toList();
    }

    private List<MailListEntryDto> mapMailListEntries(ListeDestinataireMail listeDestinataireMail) {
        HashMap config = this.businessService.getDestinatairesFonctionsMail(listeDestinataireMail.getId());
        return listeDestinataireMail.getDestinataires().stream().map(destinataireMail -> this.mapMailListEntry(destinataireMail, (HashMap)config.get(destinataireMail.getId()))).toList();
    }

    private MailListEntryDto mapMailListEntry(DestinataireMail destinataireMail, HashMap<String, Boolean> entry) {
        return MailListEntryDto.builder().recipient(this.mapMailRecipient(destinataireMail)).creation(entry.get("creation_evt").booleanValue()).modification(entry.get("modification_evt").booleanValue()).cloture(entry.get("cloture_evt").booleanValue()).traitement(entry.get("traitement_evt").booleanValue()).build();
    }

    private MailRecipientDto mapMailRecipient(DestinataireMail destinataireMail) {
        return new MailRecipientDto(destinataireMail.getId(), destinataireMail.getNom(), destinataireMail.getMail());
    }

    public Collection<MailRecipientDto> getRecipients() {
        return this.businessService.getDestinatairesMail().stream().map(arg_0 -> this.mapMailRecipient(arg_0)).toList();
    }

    public void createMailList(MailListDto mailList) {
        int idListe = this.businessService.creerListeDestinatairesMail(this.mapListeDestinataireMail(mailList));
        this.businessService.updateDestinatairesFonctionsMail(idListe, this.mapMapDiffusion(mailList));
    }

    public void updateMailList(MailListDto mailList) {
        this.businessService.updateListeDestinatairesMail(this.mapListeDestinataireMail(mailList));
        this.businessService.updateDestinatairesFonctionsMail(mailList.getId(), this.mapMapDiffusion(mailList));
    }

    public void deleteMailList(MailListDto mailList) {
        this.businessService.deleteListeDestinatairesMail(this.mapListeDestinataireMail(mailList));
    }

    private ListeDestinataireMail mapListeDestinataireMail(MailListDto mailList) {
        ImmutableMap destinataires = Maps.uniqueIndex((Iterable)this.businessService.getDestinatairesMail(), DestinataireMail::getId);
        ListeDestinataireMail liste = new ListeDestinataireMail();
        liste.setId(mailList.getId());
        liste.setNom(mailList.getName());
        liste.setDestinataires(mailList.getEntries().stream().map(MailListEntryDto::getRecipient).map(MailRecipientDto::getId).map(arg_0 -> ((ImmutableMap)destinataires).get(arg_0)).toList());
        return liste;
    }

    private HashMap<Integer, HashMap<String, Boolean>> mapMapDiffusion(MailListDto mailList) {
        HashMap<Integer, HashMap<String, Boolean>> mapDiffusion = new HashMap<Integer, HashMap<String, Boolean>>();
        for (MailListEntryDto entry : mailList.getEntries()) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("creation_evt", entry.isCreation());
            map.put("modification_evt", entry.isModification());
            map.put("cloture_evt", entry.isCloture());
            map.put("traitement_evt", entry.isTraitement());
            mapDiffusion.put(entry.getRecipient().getId(), map);
        }
        return mapDiffusion;
    }

    @Generated
    public MailListAdminService(IBusinessService businessService) {
        this.businessService = businessService;
    }
}

