/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.mail.list;

import com.neogls.prism.central.vaadin.common.exception.CustomValidationException;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.mail.dto.MailListDto;
import com.neogls.prism.central.vaadin.view.admin.mail.dto.MailListEntryDto;
import com.neogls.prism.central.vaadin.view.admin.mail.dto.MailRecipientDto;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.grid.dataview.GridListDataView;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class MailListAdminEditDialog
extends AbstractAdminEditDialog<MailListDto> {
    private final TextField name = new TextField();
    private final ComboBox<MailRecipientDto> cbRecipientToAdd = new ComboBox();
    private final Button bAddRecipient = new Button("Ajouter", (Component)VaadinIcon.PLUS.create(), arg_0 -> this.onAddRecipientClick(arg_0));
    private final Map<MailRecipientDto, MailListEntryDto> entries = new LinkedHashMap();
    private final Grid<MailListEntryDto> entriesGrid = new Grid();
    private final GridListDataView<MailListEntryDto> gridDataView = (GridListDataView)this.entriesGrid.setItems(this.entries.values());

    MailListAdminEditDialog(MailListDto oldItem, Collection<MailRecipientDto> availableRecipients) {
        super((Object)oldItem);
        this.name.setRequiredIndicatorVisible(true);
        this.cbRecipientToAdd.setItemLabelGenerator((ItemLabelGenerator & Serializable)recipient -> recipient.getNom() + " <" + recipient.getEmail() + ">");
        this.cbRecipientToAdd.setItems(availableRecipients);
        this.configureGrid();
        this.configureFields();
        if (oldItem != null) {
            this.name.setValue(oldItem.getName());
            for (MailListEntryDto entry : oldItem.getEntries()) {
                this.entries.put(entry.getRecipient(), entry.toBuilder().build());
            }
            this.gridDataView.refreshAll();
        }
    }

    private void configureGrid() {
        this.entriesGrid.setSelectionMode(Grid.SelectionMode.NONE);
        this.entriesGrid.addColumn((ValueProvider & Serializable)entry -> entry.getRecipient().getNom()).setHeader("Nom");
        this.entriesGrid.addComponentColumn(this.createCheckboxValueProvider(MailListEntryDto::isCreation, MailListEntryDto::setCreation)).setHeader("Cr\u00e9ation");
        this.entriesGrid.addComponentColumn(this.createCheckboxValueProvider(MailListEntryDto::isModification, MailListEntryDto::setModification)).setHeader("Modification");
        this.entriesGrid.addComponentColumn(this.createCheckboxValueProvider(MailListEntryDto::isCloture, MailListEntryDto::setCloture)).setHeader("Cl\u00f4ture");
        this.entriesGrid.addComponentColumn(this.createCheckboxValueProvider(MailListEntryDto::isTraitement, MailListEntryDto::setTraitement)).setHeader("Traitement");
        this.entriesGrid.addComponentColumn(arg_0 -> this.createDeleteButton(arg_0)).setHeader("Supprimer");
        this.entriesGrid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_ROW_STRIPES, GridVariant.LUMO_COMPACT});
    }

    private ValueProvider<MailListEntryDto, Checkbox> createCheckboxValueProvider(ValueProvider<MailListEntryDto, Boolean> getter, Setter<MailListEntryDto, Boolean> setter) {
        return (ValueProvider & Serializable)entry -> new Checkbox(((Boolean)getter.apply(entry)).booleanValue(), (HasValue.ValueChangeListener & Serializable)event -> {
            setter.accept(entry, (Object)((Boolean)event.getValue()));
            this.gridDataView.refreshItem(entry);
        });
    }

    private Button createDeleteButton(MailListEntryDto entry) {
        Button bDelete = new Button((Component)VaadinIcon.TRASH.create(), (ComponentEventListener & Serializable)event -> {
            this.entries.remove(entry.getRecipient());
            this.gridDataView.refreshAll();
        });
        bDelete.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ERROR});
        return bDelete;
    }

    private void configureFields() {
        FormLayout content = new FormLayout();
        content.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1)});
        content.setMaxWidth(50.0f, Unit.EM);
        content.getStyle().set("--vaadin-form-item-label-width", "10em");
        content.addFormItem((Component)this.name, this.getTranslation("admin.listedestinataire.nom", new Object[0]));
        this.cbRecipientToAdd.addClassName("flex-grow");
        HorizontalLayout layoutAddRecipient = new HorizontalLayout(new Component[]{this.cbRecipientToAdd, this.bAddRecipient});
        layoutAddRecipient.setSpacing(false);
        layoutAddRecipient.addClassName("gap-s");
        content.addFormItem((Component)layoutAddRecipient, "Liste globale");
        content.addFormItem((Component)this.entriesGrid, this.getTranslation("admin.listedestinataire.dest", new Object[0])).addClassName("form-item-vertical");
        this.add(new Component[]{content});
    }

    private void onAddRecipientClick(ClickEvent<Button> event) {
        this.cbRecipientToAdd.getOptionalValue().filter(Predicate.not(this.entries.keySet()::contains)).ifPresent(arg_0 -> this.addRecipient(arg_0));
        this.cbRecipientToAdd.clear();
    }

    private void addRecipient(MailRecipientDto recipient) {
        MailListEntryDto newEntry = MailListEntryDto.builder().recipient(recipient).build();
        this.entries.put(recipient, Optional.ofNullable((MailListDto)this.oldItem).map(MailListDto::getEntries).map(oldEntries -> oldEntries.indexOf(newEntry)).filter(i -> i != -1).map(i -> ((MailListEntryDto)((MailListDto)this.oldItem).getEntries().get((int)i)).toBuilder().build()).orElse(newEntry));
        this.gridDataView.refreshAll();
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.listedestinataire.title", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.listedestinataire.title", new Object[0]);
    }

    protected MailListDto getValue() throws ValidationException {
        if (this.name.isEmpty()) {
            throw new CustomValidationException(this.getTranslation("admin.listedestinataire.error.nom", new Object[0]));
        }
        return new MailListDto(this.oldItem != null ? ((MailListDto)this.oldItem).getId() : 0, this.name.getValue(), this.entries.values().stream().toList());
    }
}

