/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.mail.distribution;

import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.view.admin.mail.distribution.MailDistributionConfigurationService;
import com.neogls.prism.central.vaadin.view.admin.mail.distribution.NatureDescriptionDto;
import com.neogls.prism.central.vaadin.view.admin.mail.distribution.NatureDto;
import com.neogls.prism.central.vaadin.view.admin.mail.dto.MailListDto;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

@RolesAllowed(value={"ACTION_ADMIN_MAIL"})
@Route(value="admin/mail-distribution", layout=PrismLayout.class)
public class MailDistributionConfigurationView
extends FormLayout
implements HasDynamicTitle {
    private final MailDistributionConfigurationService service;
    private final AtomicReference<Object> recipientsLists = new AtomicReference();
    private final AtomicReference<Object> distributionLists = new AtomicReference();
    private final AtomicReference<Object> eventDistributionLists = new AtomicReference();

    @PostConstruct
    private void init() {
        this.initAlertDistribution();
        this.initEventDistribution();
        Button bSave = new Button(this.getTranslation("admin.save", new Object[0]), (ComponentEventListener & Serializable)event -> {
            this.service.save(this.getDistributionLists(), this.getEventDistributionLists());
            ((UI)this.getUI().orElseThrow()).refreshCurrentRoute(false);
        });
        Button bCancel = new Button(this.getTranslation("admin.cancel", new Object[0]), (ComponentEventListener & Serializable)event -> ((UI)this.getUI().orElseThrow()).refreshCurrentRoute(false));
        HorizontalLayout controls = new HorizontalLayout(new Component[]{bSave, bCancel});
        controls.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        controls.addClassName("mt-m");
        this.add(new Component[]{controls});
        this.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1)});
        this.getStyle().set("--vaadin-form-item-label-width", "20em");
        this.setMaxWidth(60.0f, Unit.EM);
        this.addClassNames(new String[]{"mx-auto", "p-m", "form-item-label-right"});
    }

    private void initAlertDistribution() {
        this.add(new Component[]{new H3(this.getTranslation("admin.diffusion.title", new Object[0]))});
        for (Map.Entry list : this.getDistributionLists().entrySet()) {
            this.createListComboBox(this.getTranslation("diffusion.listename." + (String)list.getKey(), new Object[0]), (MailListDto)list.getValue(), (HasValue.ValueChangeListener & Serializable)event -> this.getDistributionLists().put((String)list.getKey(), (MailListDto)event.getValue()));
        }
    }

    private void initEventDistribution() {
        H3 title = new H3(this.getTranslation("admin.diffusionevt.title", new Object[0]));
        title.addClassName("mt-s");
        this.add(new Component[]{title});
        for (NatureDto nature : this.getEventDistributionLists()) {
            H4 natureLabel = new H4(nature.getLabel());
            natureLabel.addClassName("mt-m");
            this.addFormItem((Component)natureLabel, "");
            for (NatureDescriptionDto description : nature.getDescriptions()) {
                this.createListComboBox(description.getLabel(), description.getMailList(), (HasValue.ValueChangeListener & Serializable)event -> description.setMailList((MailListDto)event.getValue()));
            }
        }
    }

    private void createListComboBox(String label, MailListDto value, HasValue.ValueChangeListener<HasValue.ValueChangeEvent<MailListDto>> listener) {
        ComboBox cb = new ComboBox();
        cb.setPlaceholder(this.getTranslation("diffusion.nodiff", new Object[0]));
        cb.setClearButtonVisible(true);
        cb.setItemLabelGenerator(MailListDto::getName);
        cb.setItems(this.getRecipientsLists());
        cb.setValue((Object)value);
        cb.addValueChangeListener(listener);
        this.addFormItem((Component)cb, label);
    }

    public String getPageTitle() {
        return this.getTranslation("admin.diffusionevt.title", new Object[0]);
    }

    @Generated
    public MailDistributionConfigurationView(MailDistributionConfigurationService service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Collection<MailListDto> getRecipientsLists() {
        Object $value = this.recipientsLists.get();
        if ($value == null) {
            AtomicReference atomicReference = this.recipientsLists;
            synchronized (atomicReference) {
                $value = this.recipientsLists.get();
                if ($value == null) {
                    List actualValue = this.service.getRecipientsLists();
                    $value = actualValue == null ? this.recipientsLists : actualValue;
                    this.recipientsLists.set($value);
                }
            }
        }
        return $value == this.recipientsLists ? null : $value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Map<String, MailListDto> getDistributionLists() {
        Object $value = this.distributionLists.get();
        if ($value == null) {
            AtomicReference atomicReference = this.distributionLists;
            synchronized (atomicReference) {
                $value = this.distributionLists.get();
                if ($value == null) {
                    HashMap actualValue = new HashMap(this.service.getDistributionLists());
                    $value = actualValue == null ? this.distributionLists : actualValue;
                    this.distributionLists.set($value);
                }
            }
        }
        return $value == this.distributionLists ? null : $value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public List<NatureDto> getEventDistributionLists() {
        Object $value = this.eventDistributionLists.get();
        if ($value == null) {
            AtomicReference atomicReference = this.eventDistributionLists;
            synchronized (atomicReference) {
                $value = this.eventDistributionLists.get();
                if ($value == null) {
                    List actualValue = this.service.getEventDistributionLists();
                    $value = actualValue == null ? this.eventDistributionLists : actualValue;
                    this.eventDistributionLists.set($value);
                }
            }
        }
        return $value == this.eventDistributionLists ? null : $value;
    }
}

